/*
 * Decompiled with CFR 0.152.
 */
import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.PrivateKey;
import com.icodici.universa.HashId;
import java.io.Serializable;
import scala.App;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.mutable.ListBuffer;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import smartcontracts.Account;
import smartcontracts.Asset;
import universa.Logging;
import universa.RegistrationException;

public final class SmartContractsTest$
implements App,
Logging {
    public static SmartContractsTest$ MODULE$;
    private final Enumeration.Value minLogLevel;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new SmartContractsTest$();
    }

    @Override
    public void log(Function0<String> text, Enumeration.Value level) {
        Logging.log$(this, text, level);
    }

    @Override
    public void debug(Function0<String> text) {
        Logging.debug$(this, text);
    }

    @Override
    public void info(Function0<String> text) {
        Logging.info$(this, text);
    }

    @Override
    public void error(Function0<String> text) {
        Logging.error$(this, text);
    }

    @Override
    public Enumeration.Value log$default$2() {
        return Logging.log$default$2$(this);
    }

    @Override
    public String[] args() {
        return App.args$(this);
    }

    @Override
    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$(this, body2);
    }

    @Override
    public void main(String[] args) {
        App.main$(this, args);
    }

    @Override
    public Enumeration.Value minLogLevel() {
        return this.minLogLevel;
    }

    @Override
    public void universa$Logging$_setter_$minLogLevel_$eq(Enumeration.Value x$1) {
        this.minLogLevel = x$1;
    }

    @Override
    public long executionStart() {
        return this.executionStart;
    }

    @Override
    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    @Override
    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    @Override
    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    @Override
    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    @Override
    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public void testAccountTransfering() {
        Failure failure;
        Throwable x;
        Failure failure2;
        Throwable x2;
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "-- testing accounts and transfers --");
        Party bank = new Party("bank");
        Party partyA = new Party("A");
        Party partyB = new Party("B");
        Party partyC = new Party("C");
        Account corrA = bank.account("corr_A", "EUR", bank.account$default$3());
        Account corrB = bank.account("corr_B", "EUR", bank.account$default$3());
        Account corrC = bank.account("corr_C", "USD", bank.account$default$3());
        this.checkBalance(corrA, BigDecimal$.MODULE$.int2bigDecimal(0), this.checkBalance$default$3());
        this.checkBalance(corrB, BigDecimal$.MODULE$.int2bigDecimal(0), this.checkBalance$default$3());
        this.checkBalance(corrC, BigDecimal$.MODULE$.int2bigDecimal(0), this.checkBalance$default$3());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> !corrA.blocked(), this.ensure$default$2());
        Account blockedAccount = bank.account("corr_C", "USD", true).block(Predef$.MODULE$.wrapRefArray((Object[])new PrivateKey[]{bank.privateKey()}));
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> blockedAccount.blocked(), this.ensure$default$2());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: create blocked account");
        ObjectRef<Asset> asset1 = ObjectRef.create(corrA.createAsset(BigDecimal$.MODULE$.int2bigDecimal(10), bank.privateKey()));
        Asset qual$1 = (Asset)asset1.elem;
        boolean x$3 = qual$1.register$default$1();
        qual$1.register(x$3, Predef$.MODULE$.$conforms());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> ((Asset)asset1$1.elem).networkState().state.isApproved(), this.ensure$default$2());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OK: registered basic asset: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{(Asset)asset1$1.elem})));
        this.checkBalance(corrA, BigDecimal$.MODULE$.int2bigDecimal(10), this.checkBalance$default$3());
        this.checkBalance(corrB, BigDecimal$.MODULE$.int2bigDecimal(0), this.checkBalance$default$3());
        this.checkBalance(corrC, BigDecimal$.MODULE$.int2bigDecimal(0), this.checkBalance$default$3());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: balance is updated properly");
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> BoxesRunTime.equalsNumObject(((Asset)asset1$1.elem).amount(), BoxesRunTime.boxToInteger(10)), this.ensure$default$2());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> {
            String string = ((Asset)asset1$1.elem).currency();
            String string2 = "EUR";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, this.ensure$default$2());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> {
            Account account = ((Asset)asset1$1.elem).account();
            Account account2 = corrA;
            return !(account != null ? !account.equals(account2) : account2 != null);
        }, this.ensure$default$2());
        Tuple2<Asset, Asset> tuple2 = ((Asset)asset1.elem).extractAmount(BigDecimal$.MODULE$.int2bigDecimal(8), bank.privateKey(), partyA.publicKey());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Asset a1 = tuple2._1();
        Asset a2 = tuple2._2();
        Tuple2<Asset, Asset> tuple22 = new Tuple2<Asset, Asset>(a1, a2);
        Tuple2<Asset, Asset> tuple23 = tuple22;
        Asset a12 = tuple23._1();
        Asset a22 = tuple23._2();
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> BoxesRunTime.equalsNumObject(a12.amount(), BoxesRunTime.boxToInteger(2)), this.ensure$default$2());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> BoxesRunTime.equalsNumObject(a22.amount(), BoxesRunTime.boxToInteger(8)), this.ensure$default$2());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> a12.canPerformRole("owner", Predef$.MODULE$.wrapRefArray((Object[])new AbstractKey[]{bank.publicKey()})), this.ensure$default$2());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> a22.canPerformRole("owner", Predef$.MODULE$.wrapRefArray((Object[])new AbstractKey[]{partyA.publicKey()})), this.ensure$default$2());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> !a22.canPerformRole("owner", Predef$.MODULE$.wrapRefArray((Object[])new AbstractKey[]{bank.publicKey()})), this.ensure$default$2());
        a12.register(a12.register$default$1(), Predef$.MODULE$.$conforms());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: splitted amount is registered");
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> a2$1.networkState().state.isApproved(), this.ensure$default$2());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: second part is already registered");
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> !((Asset)asset1$1.elem).networkState().state.isApproved(), this.ensure$default$2());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: parent is no more registered");
        this.checkBalance(corrA, BigDecimal$.MODULE$.int2bigDecimal(10), this.checkBalance$default$3());
        this.checkBalance(corrB, BigDecimal$.MODULE$.int2bigDecimal(0), this.checkBalance$default$3());
        this.checkBalance(corrC, BigDecimal$.MODULE$.int2bigDecimal(0), this.checkBalance$default$3());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: balance is updated properly");
        asset1.elem = a12.join(Predef$.MODULE$.wrapRefArray((Object[])new Asset[]{a22}), Predef$.MODULE$.wrapRefArray((Object[])new PrivateKey[]{bank.privateKey(), partyA.privateKey()}));
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> BoxesRunTime.equalsNumObject(((Asset)asset1$1.elem).amount(), BoxesRunTime.boxToInteger(10)), this.ensure$default$2());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> ((Asset)asset1$1.elem).canPerformRole("owner", Predef$.MODULE$.wrapRefArray((Object[])new AbstractKey[]{bank.publicKey()})), this.ensure$default$2());
        Asset qual$2 = (Asset)asset1.elem;
        boolean x$4 = qual$2.register$default$1();
        qual$2.register(x$4, Predef$.MODULE$.$conforms());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: assets joined and registered");
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> !a2$1.networkState().state.isApproved(), this.ensure$default$2());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: old, joined asset is no more valid");
        Try try_ = Try$.MODULE$.apply((Function0<Nothing$> & Serializable & scala.Serializable)() -> (Nothing$)((Asset)asset1$1.elem).transferTo(corrC, bank.privateKey()).register(true, Predef$.MODULE$.$conforms()));
        if (!(try_ instanceof Failure) || !((x2 = (failure2 = (Failure)try_).exception()) instanceof RegistrationException)) {
            throw this.fatal("registration must fail!");
        }
        RegistrationException registrationException = (RegistrationException)x2;
        this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OK: transfering to wrong account was rejected: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{registrationException})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Try try_2 = Try$.MODULE$.apply((Function0<Nothing$> & Serializable & scala.Serializable)() -> (Nothing$)((Asset)asset1$1.elem).transferTo(blockedAccount, bank.privateKey()).register(true, Predef$.MODULE$.$conforms()));
        if (!(try_2 instanceof Failure) || !((x = (failure = (Failure)try_2).exception()) instanceof RegistrationException)) {
            throw this.fatal("registration must fail!");
        }
        RegistrationException registrationException2 = (RegistrationException)x;
        this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OK: transfering to blocked account was rejected: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{registrationException2})));
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        Asset qual$3 = ((Asset)asset1.elem).transferTo(corrB, bank.privateKey());
        boolean x$5 = qual$3.register$default$1();
        asset1.elem = (Asset)qual$3.register(x$5, Predef$.MODULE$.$conforms());
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OK: Asset registered to another good account: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{(Asset)asset1.elem})));
        this.checkBalance(corrA, BigDecimal$.MODULE$.int2bigDecimal(0), false);
        this.checkBalance(corrB, BigDecimal$.MODULE$.int2bigDecimal(10), false);
        this.checkBalance(corrC, BigDecimal$.MODULE$.int2bigDecimal(0), this.checkBalance$default$3());
    }

    public void ensure(Function0<Object> cond, String message) {
        if (!cond.apply$mcZ$sp()) {
            throw this.fatal("ensure failed");
        }
    }

    public String ensure$default$2() {
        return "condition failed";
    }

    public Nothing$ fatal(String message) {
        throw new RuntimeException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{message})));
    }

    public void checkBalance(Account a, BigDecimal expected, boolean doTrace) {
        BigDecimal saldo;
        BigDecimal bigDecimal = saldo = a.recheckBalance(doTrace);
        BigDecimal bigDecimal2 = expected;
        if (bigDecimal == null ? bigDecimal2 != null : !((Object)bigDecimal).equals(bigDecimal2)) {
            throw this.fatal(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": saldo is ", " while expected ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{a, saldo, expected})));
        }
    }

    public boolean checkBalance$default$3() {
        return false;
    }

    public void testOverSpending() {
        Failure failure;
        Throwable x;
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "-- testing overspending and transfers --");
        Party bank = new Party("bank");
        Party partyA = new Party("A");
        Account corrA = bank.account("corr_A", "EUR", bank.account$default$3());
        ObjectRef<Asset> asset1 = ObjectRef.create(corrA.createAsset(BigDecimal$.MODULE$.int2bigDecimal(10), bank.privateKey()));
        Asset qual$4 = (Asset)asset1.elem;
        boolean x$6 = qual$4.register$default$1();
        qual$4.register(x$6, Predef$.MODULE$.$conforms());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> ((Asset)asset1$2.elem).networkState().state.isApproved(), this.ensure$default$2());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OK: registered basic asset: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{(Asset)asset1$2.elem})));
        HashId aid = ((Asset)asset1.elem).hashId();
        Tuple2<Asset, Asset> tuple2 = ((Asset)asset1.elem).extractAmount(BigDecimal$.MODULE$.int2bigDecimal(8), bank.privateKey(), partyA.publicKey());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Asset a1 = tuple2._1();
        Asset a2 = tuple2._2();
        Tuple2<Asset, Asset> tuple22 = new Tuple2<Asset, Asset>(a1, a2);
        Tuple2<Asset, Asset> tuple23 = tuple22;
        Asset a12 = tuple23._1();
        Asset a22 = tuple23._2();
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> BoxesRunTime.equalsNumObject(a12.amount(), BoxesRunTime.boxToInteger(2)), this.ensure$default$2());
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> BoxesRunTime.equalsNumObject(a22.amount(), BoxesRunTime.boxToInteger(8)), this.ensure$default$2());
        a12.state().update("amount", BoxesRunTime.boxToInteger(12));
        a12.contract().seal();
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> BoxesRunTime.equalsNumObject(a12.amount(), BoxesRunTime.boxToInteger(12)), this.ensure$default$2());
        Try try_ = Try$.MODULE$.apply((Function0<Nothing$> & Serializable & scala.Serializable)() -> (Nothing$)a12.register(true, Predef$.MODULE$.$conforms()));
        if (!(try_ instanceof Failure) || !((x = (failure = (Failure)try_).exception()) instanceof RegistrationException)) {
            throw this.fatal("registration must fail!");
        }
        RegistrationException registrationException = (RegistrationException)x;
        this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OK: overspending is rejected: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{registrationException})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.ensure((JFunction0$mcZ$sp & scala.Serializable)() -> ((Asset)asset1$2.elem).networkState().state.isApproved(), this.ensure$default$2());
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "OK: source contract (before overspending) is still approved");
    }

    public final void delayedEndpoint$SmartContractsTest$1() {
        this.testAccountTransfering();
        this.testOverSpending();
    }

    private SmartContractsTest$() {
        MODULE$ = this;
        App.$init$(this);
        Logging.$init$(this);
        this.delayedInit(new SmartContractsTest.delayedInit.body(this));
    }
}

