/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.BlockCipher;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.SymmetricKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongycastle.crypto.engines.AESFastEngine;
import org.spongycastle.crypto.params.KeyParameter;

public class AES256
implements BlockCipher {
    private @NonNull org.spongycastle.crypto.BlockCipher aesEngine = new AESFastEngine();
    private @Nullable byte[] key;

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int getKeySize() {
        return 32;
    }

    @Override
    public String getTag() {
        return "AES256";
    }

    @Override
    public void initialize(BlockCipher.Direction direction, SymmetricKey key) {
        this.key = key.getKey();
        if (this.initialized()) {
            KeyParameter params = new KeyParameter(this.key);
            this.aesEngine.init(direction == BlockCipher.Direction.ENCRYPT, params);
        }
    }

    protected boolean initialized() {
        return this.key != null && this.key.length == this.getKeySize();
    }

    @Override
    public byte[] transformBlock(byte[] block) throws EncryptionError {
        if (!this.initialized()) {
            throw new EncryptionError("Not initialized with proper key");
        }
        byte[] buf = new byte[this.getBlockSize()];
        this.aesEngine.processBlock(block, 0, buf, 0);
        return buf;
    }
}

