/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.Capsule;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.KeyAddress;
import com.icodici.crypto.KeyInfo;
import com.icodici.crypto.KeyMatcher;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.digest.Digest;
import com.icodici.crypto.digest.HMAC;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sergeych.tools.Bindable;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.utils.Base64;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractKey
implements Bindable,
KeyMatcher {
    public static final int FINGERPRINT_SHA256 = 7;
    public static final int FINGERPRINT_SHA384 = 8;
    protected KeyInfo keyInfo;
    static Charset utf8 = Charset.forName("utf-8");
    private KeyAddress shortAddress;
    private KeyAddress longAddress;

    public byte[] encrypt(byte[] plain) throws EncryptionError {
        throw new UnsupportedOperationException("this key can't encrypt");
    }

    public byte[] decrypt(byte[] plain) throws EncryptionError {
        throw new UnsupportedOperationException("this key can't decrypt");
    }

    public byte[] sign(InputStream input, HashType hashType) throws EncryptionError, IOException {
        throw new UnsupportedOperationException("this key can't sign");
    }

    public byte[] sign(byte[] input, HashType hashType) throws EncryptionError {
        try {
            return this.sign(new ByteArrayInputStream(input), hashType);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IO exception while signing", e);
        }
    }

    public boolean verify(InputStream input, byte[] signature, HashType hashType) throws EncryptionError, IOException {
        throw new UnsupportedOperationException("this key can not verify signatures");
    }

    public boolean verify(byte[] input, byte[] signature, HashType hashType) throws EncryptionError {
        try {
            return this.verify(new ByteArrayInputStream(input), signature, hashType);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IO exception", e);
        }
    }

    public boolean verify(String input, byte[] signature, HashType hashType) throws EncryptionError {
        return this.verify(input.getBytes(utf8), signature, hashType);
    }

    public KeyInfo info() {
        return this.keyInfo;
    }

    public byte[] packedInfo() {
        return this.info().pack();
    }

    public byte[] pack() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String packToBase64String() {
        return Base64.encodeString(this.pack());
    }

    public void unpack(byte[] bytes) throws EncryptionError {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean canSign() {
        return false;
    }

    public boolean isPublic() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public AbstractKey getPublicKey() {
        if (this.isPublic()) {
            return this;
        }
        throw new UnsupportedOperationException("this key can't provide public key");
    }

    @Override
    public final Binder toBinder() {
        return new Binder("keyInfo", this.packedInfo(), "data", this.pack());
    }

    @Override
    public final <T> T updateFrom(Binder source) throws IOException {
        KeyInfo ki = new KeyInfo(source.getBinary("keyInfo"));
        return (T)ki.unpackKey(source.getBinary("data"));
    }

    public static AbstractKey fromBinder(Binder binder) throws IOException, EncryptionError {
        KeyInfo info = new KeyInfo(binder.getBinary("keyInfo"));
        return info.unpackKey(binder.getBinary("data"));
    }

    public boolean matchType(AbstractKey other) {
        return this.info().matchType(other.info());
    }

    public boolean matchTag(AbstractKey other) {
        return this.info().matchTag(other.info());
    }

    public void setTag(String tag) {
        try {
            this.setTag(tag.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("utf8 is not supported?");
        }
    }

    public void setTag(byte[] tag) {
        this.info().setTag(tag);
    }

    public String toString() {
        AbstractKey k = this instanceof PrivateKey ? this.getPublicKey() : this;
        return this.info().toString() + ":" + this.info().getBase64Tag();
    }

    public Capsule.KeySource asKeySource() {
        return new Capsule.KeySource(){

            @Override
            public Collection<AbstractKey> findKey(KeyInfo keyInfo) {
                ArrayList<AbstractKey> results = new ArrayList<AbstractKey>();
                if (AbstractKey.this.info().matchType(keyInfo)) {
                    results.add(AbstractKey.this);
                }
                return results;
            }
        };
    }

    public byte[] fingerprint() {
        throw new RuntimeException("this key does not support fingerprints");
    }

    public Digest updateDigestWithKeyComponents(Digest digest) {
        throw new RuntimeException("this key does not support fingerprints");
    }

    public byte[] createAnonymousId() {
        byte[] rvector = Do.randomBytes(32);
        HMAC hmac = new HMAC(this.fingerprint());
        hmac.update(rvector);
        byte[] result = new byte[64];
        System.arraycopy(rvector, 0, result, 0, 32);
        System.arraycopy(hmac.digest(), 0, result, 32, 32);
        return result;
    }

    public boolean matchAnonymousId(@NonNull byte[] packedId) throws IOException {
        assert (packedId.length == 64);
        HMAC hmac = new HMAC(this.fingerprint());
        hmac.update(packedId, 0, 32);
        byte[] idDigest = Arrays.copyOfRange(packedId, 32, 64);
        return Arrays.equals(hmac.digest(), idDigest);
    }

    public KeyAddress address(boolean useSha3_384, int keyMark) {
        return new KeyAddress(this, keyMark, useSha3_384);
    }

    public final KeyAddress getShortAddress() {
        if (this.shortAddress == null) {
            this.shortAddress = this.address(false, 0);
        }
        return this.shortAddress;
    }

    public final KeyAddress getLongAddress() {
        if (this.longAddress == null) {
            this.longAddress = this.address(true, 0);
        }
        return this.longAddress;
    }

    @Override
    public boolean isMatchingKey(AbstractKey key) {
        return this.getShortAddress().isMatchingKeyAddress(key.getShortAddress());
    }

    @Override
    public final boolean isMatchingKeyAddress(KeyAddress other) {
        return other.isLong() ? this.getLongAddress().isMatchingKeyAddress(other) : this.getShortAddress().isMatchingKeyAddress(other);
    }
}

