/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.AbstractAsymmetricKey;
import com.icodici.crypto.AbstractPublicKey;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sergeych.tools.Hashable;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractPrivateKey
extends AbstractAsymmetricKey
implements Hashable {
    public abstract void generate(int var1, HashType var2);

    public abstract boolean isInitialized();

    public abstract int getBitStrength();

    @Override
    public abstract AbstractPublicKey getPublicKey() throws IllegalStateException;

    public abstract boolean canDecrypt();

    @Override
    public abstract byte[] decrypt(byte[] var1) throws EncryptionError;

    public abstract byte[] sign(InputStream var1, HashType var2, @Nullable byte[] var3) throws IOException;

    @Override
    public byte[] sign(InputStream input, HashType hashType) throws IOException {
        return this.sign(input, hashType, null);
    }

    public byte[] sign(byte[] data, HashType hashType, @Nullable byte[] salt) {
        try {
            return this.sign(new ByteArrayInputStream(data), hashType, salt);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to sign", e);
        }
    }

    @Override
    public byte[] sign(byte[] data, HashType hashType) {
        try {
            return this.sign(new ByteArrayInputStream(data), hashType);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to sign", e);
        }
    }

    public byte[] sign(String data, HashType hashType, @Nullable byte[] salt) {
        return this.sign(data.getBytes(), hashType, salt);
    }

    public byte[] sign(String data, HashType hashType) {
        return this.sign(data.getBytes(), hashType);
    }
}

