/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.AbstractAsymmetricKey;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sergeych.tools.Hashable;

public abstract class AbstractPublicKey
extends AbstractAsymmetricKey
implements Hashable {
    public abstract boolean canEncrypt();

    public abstract int getBitStrength();

    public abstract boolean isInitialized();

    @Override
    public abstract byte[] encrypt(byte[] var1) throws EncryptionError;

    public abstract boolean checkSignature(InputStream var1, byte[] var2, HashType var3, int var4) throws IOException, IllegalStateException;

    public boolean checkSignature(InputStream input, byte[] signature, HashType hashType) throws IOException, IllegalStateException {
        return this.checkSignature(input, signature, hashType, MAX_SALT_LENGTH);
    }

    public abstract String algorithmTag();

    public boolean checkSignature(byte[] input, byte[] signature, HashType hashType, int saltLength) {
        try {
            return this.checkSignature(new ByteArrayInputStream(input), signature, hashType, saltLength);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean checkSignature(byte[] input, byte[] signature, HashType hashType) {
        try {
            return this.checkSignature(new ByteArrayInputStream(input), signature, hashType, MAX_SALT_LENGTH);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean checkSignature(String data, byte[] signature, HashType hashType) {
        return this.checkSignature(data.getBytes(), signature, hashType);
    }

    public byte[] encrypt(String data) throws EncryptionError {
        return this.encrypt(data.getBytes());
    }
}

