/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.SymmetricKey;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import net.sergeych.boss.Boss;
import net.sergeych.farcall.BossConnector;
import net.sergeych.farcall.Command;
import net.sergeych.farcall.Connector;
import net.sergeych.farcall.Farcall;
import net.sergeych.tools.AsyncEvent;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.utils.Bytes;
import net.sergeych.utils.LogPrinter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BitrustedConnector
implements Farcall.Target,
Connector {
    private static final int MY_VERSION = 2;
    private static LogPrinter log = new LogPrinter("BRCN");
    private static ExecutorService pool = Executors.newCachedThreadPool();
    private final PrivateKey myKey;
    private final SymmetricKey mySessionKey = new SymmetricKey();
    private final byte[] myNonce = Do.randomBytes(32);
    private int handshakeTimeoutMillis = 2000;
    private Farcall connection;
    private PublicKey remoteKey;
    private SymmetricKey remoteSessionKey;
    private Predicate<byte[]> isTrustedKey;
    private AsyncEvent ready = new AsyncEvent();
    private boolean connected = false;
    private BlockingQueue<Binder> inputQueue = new LinkedBlockingQueue<Binder>();

    public BitrustedConnector(PrivateKey myKey, InputStream input, OutputStream output) throws IOException {
        this.myKey = myKey;
        this.connection = new Farcall(new BossConnector(input, output));
        this.connection.asyncCommands(Executors.newSingleThreadExecutor());
    }

    @Override
    public void send(Map<String, Object> data) throws IOException {
        this.checkConnected();
        byte[] packed = this.mySessionKey.etaEncrypt(Boss.pack(data));
        if (this.connection.isClosed()) {
            throw new EOFException("connection closed");
        }
        this.connection.sendParams("block", new Object[]{packed});
    }

    @Override
    public Map<String, Object> receive() throws IOException {
        try {
            return this.inputQueue.take();
        }
        catch (InterruptedException e) {
            throw new EOFException("input is interrupted/being closed");
        }
    }

    @Override
    public void close() {
        this.connected = false;
        this.connection.close();
    }

    private void checkConnected() {
        if (!this.connected) {
            throw new IllegalStateException("connector is not connected");
        }
    }

    public BitrustedConnector connect(Predicate<byte[]> isTrustedKey) throws Error, TimeoutException, InterruptedException {
        Future<Boolean> initDone = pool.submit(() -> {
            this.isTrustedKey = isTrustedKey;
            this.connection.start(this);
            Binder result = Binder.from(this.connection.sendKeyParams("hello", "protocol", "bitrusted", "version", 2, "public_key", this.myKey.getPublicKey().pack(), "session_key", this.mySessionKey.pack(), "nonce", this.myNonce).waitSuccess());
            try {
                this.processHelloAnswer(result);
            }
            catch (EncryptionError e) {
                log.e("Encryption error my k: " + this.myKey + " remote k: " + this.remoteKey, new Object[0]);
                return false;
            }
            this.ready.await();
            return true;
        });
        try {
            initDone.get(this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
            this.connected = true;
        }
        catch (InterruptedException | TimeoutException e) {
            initDone.cancel(true);
            throw e;
        }
        catch (Exception e) {
            initDone.cancel(true);
            throw new Error("initialization failed", e.getCause());
        }
        return this;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void processHelloAnswer(Binder result) throws EncryptionError {
        byte[] data = result.getBinaryOrThrow("data");
        byte[] signature = result.getBinaryOrThrow("signature");
        this.setRemoteKey(result.getBinaryOrThrow("public_key"));
        if (!this.remoteKey.verify(data, signature, HashType.SHA256)) {
            throw new EncryptionError("bad signature in hello answer");
        }
        Binder answer = Boss.unpack(this.myKey.decrypt(data));
        if (!Arrays.equals(answer.getBinaryOrThrow("nonce"), this.myNonce)) {
            throw new EncryptionError("nonce mismatch");
        }
        this.remoteSessionKey = new SymmetricKey(answer.getBinary("session_key"));
    }

    @Override
    public Object onCommand(Command command) throws Exception {
        switch (command.getName()) {
            case "hello": {
                return this.onHello(Binder.from(command.getKeyParams()));
            }
            case "block": {
                return this.decryptBlock(command);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object decryptBlock(Command command) throws EncryptionError {
        try {
            SymmetricKey symmetricKey = this.remoteSessionKey;
            synchronized (symmetricKey) {
                Bytes ciphertext = (Bytes)command.getParam(0);
                if (ciphertext == null) {
                    throw new IllegalStateException("missing block data");
                }
                Binder plain = Boss.unpack(this.remoteSessionKey.etaDecrypt(ciphertext.toArray()));
                this.inputQueue.put(plain);
            }
        }
        catch (SymmetricKey.AuthenticationFailed authenticationFailed) {
            throw new EncryptionError("authentication failed on bitrusted block");
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        catch (Exception e) {
            log.wtf("failed to process block", e);
            e.printStackTrace();
        }
        return null;
    }

    private Object onHello(Binder params) throws IOException {
        if (!params.getStringOrThrow("protocol").equals("bitrusted")) {
            throw new IOException("unsupported protocol, needs bitrusted'");
        }
        if (params.getIntOrThrow("version") > 2) {
            throw new IOException("unsupported protocol version, needs <= 2");
        }
        byte[] nonce = params.getBinaryOrThrow("nonce");
        this.setRemoteKey(params.getBinaryOrThrow("public_key"));
        this.remoteSessionKey = new SymmetricKey(params.getBinaryOrThrow("session_key"));
        byte[] result = Boss.pack(Binder.fromKeysValues("session_key", this.mySessionKey.pack(), "nonce", nonce));
        result = this.remoteKey.encrypt(result);
        byte[] signature = this.myKey.sign(result, HashType.SHA256);
        this.ready.fire(null);
        return Binder.fromKeysValues("data", result, "signature", signature, "public_key", this.myKey.getPublicKey().pack());
    }

    public int getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeoutMillis(int handshakeTimeoutMillis) {
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
    }

    public SymmetricKey getMySessionKey() {
        return this.mySessionKey;
    }

    public SymmetricKey getRemoteSessionKey() {
        return this.remoteSessionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteKey(@NonNull byte[] packedKey) throws EncryptionError {
        if (this.isTrustedKey != null && !this.isTrustedKey.test(packedKey)) {
            throw new IllegalArgumentException("public key is not accepted");
        }
        PublicKey rk = new PublicKey(packedKey);
        AsyncEvent asyncEvent = this.ready;
        synchronized (asyncEvent) {
            if (this.remoteKey == null) {
                this.remoteKey = rk;
            } else if (!rk.equals(this.remoteKey)) {
                throw new IllegalArgumentException("remote key already set to a different value");
            }
        }
    }

    class Error
    extends IOException {
        public Error() {
        }

        public Error(String message) {
            super(message);
        }

        public Error(String message, Throwable cause) {
            super(message, cause);
        }

        public Error(Throwable cause) {
            super(cause);
        }
    }
}

