/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.BlockCipher;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.SymmetricKey;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

class CTRTransformer {
    private static final SecureRandom rng;
    private final BlockCipher cipher;
    private final byte[] nonce;
    private int counter;
    private int index = 0;
    private final int blockSize;
    private byte[] source;
    private final byte[] counterBytes;

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        rng.nextBytes(bytes);
        return bytes;
    }

    public static byte[] randomBytes(int minLength, int maxLength) {
        int length = rng.nextInt(maxLength - minLength);
        byte[] bytes = new byte[length];
        rng.nextBytes(bytes);
        return bytes;
    }

    public byte[] getIV() {
        return this.nonce;
    }

    public CTRTransformer(BlockCipher cipher, byte[] iv) throws EncryptionError {
        this.cipher = cipher;
        this.blockSize = cipher.getBlockSize();
        this.nonce = iv == null ? CTRTransformer.randomBytes(this.blockSize) : iv;
        this.counter = 0;
        this.source = new byte[this.blockSize];
        this.counterBytes = new byte[4];
        this.prepareBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareBlock() throws EncryptionError {
        System.arraycopy(this.nonce, 0, this.source, 0, this.blockSize);
        this.counterBytes[0] = (byte)(this.counter >> 24);
        this.counterBytes[1] = (byte)(this.counter >> 16);
        this.counterBytes[2] = (byte)(this.counter >> 8);
        this.counterBytes[3] = (byte)this.counter;
        CTRTransformer.applyXor(this.source, this.blockSize - 4, this.counterBytes);
        BlockCipher blockCipher = this.cipher;
        synchronized (blockCipher) {
            this.source = this.cipher.transformBlock(this.source);
        }
        ++this.counter;
        this.index = 0;
    }

    private byte nextByte() throws EncryptionError {
        if (this.index >= this.blockSize) {
            this.prepareBlock();
        }
        return this.source[this.index++];
    }

    public int transformByte(int source) throws EncryptionError {
        return (source ^ this.nextByte()) & 0xFF;
    }

    public static void applyXor(byte[] source, int offset, byte[] mask) {
        int end = offset + mask.length;
        if (end > source.length) {
            throw new IllegalArgumentException("source is too short for this offset and mask");
        }
        int sourceIndex = offset;
        int maskIndex = 0;
        do {
            int n = sourceIndex++;
            source[n] = (byte)(source[n] ^ mask[maskIndex++]);
        } while (sourceIndex < end);
    }

    public static BlockCipher makeCipher(Class<? extends BlockCipher> cipherClass, byte[] key) throws EncryptionError {
        try {
            BlockCipher cipher = cipherClass.newInstance();
            cipher.initialize(BlockCipher.Direction.DECRYPT, new SymmetricKey(key));
            return cipher;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EncryptionError("failed to instantiate BlockCipher class " + cipherClass.getName(), e);
        }
    }

    public static int nextRandom(int max) {
        return max <= 0 ? rng.nextInt() : rng.nextInt(max);
    }

    static {
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Can't create suitable PRNG");
        }
    }
}

