/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.CTRTransformer;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.KeyInfo;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.SymmetricKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Capsule {
    private boolean partiallySigned = false;
    private boolean decryptionFailed;
    private boolean signed = false;
    private Binder publicData = new Binder();
    private Binder privateData = new Binder();
    private Collection<AbstractKey> encryptingKeys = new ArrayList<AbstractKey>();
    private HashMap<String, Binder> signers = new HashMap();

    public Capsule(final String password, byte[] packed) throws EncryptionError, BadSignatureException {
        KeySource src = new KeySource(){

            @Override
            public Collection<AbstractKey> findKey(KeyInfo keyInfo) {
                ArrayList<AbstractKey> list = new ArrayList<AbstractKey>();
                if (keyInfo.isPassword()) {
                    list.add(keyInfo.derivePassword(password));
                }
                return list;
            }
        };
        this.load(packed, src, true, false);
    }

    public boolean isPartiallySigned() {
        return this.partiallySigned;
    }

    public boolean decryptionFailed() {
        return this.decryptionFailed;
    }

    public void setPrivateData(Object ... keysAndValues) {
        this.setPrivateData(new Binder(keysAndValues));
    }

    public boolean isSigned() {
        return this.signed;
    }

    public Collection<AbstractKey> getSigningKeys() {
        ArrayList<AbstractKey> kk = new ArrayList<AbstractKey>();
        for (Binder b : this.signers.values()) {
            kk.add((AbstractKey)b.get("key"));
        }
        return kk;
    }

    public Map<String, Binder> getSigners() {
        return Collections.unmodifiableMap(this.signers);
    }

    public Capsule() {
    }

    public Capsule(byte[] packed, KeySource keySource) throws BadSignatureException, IOException {
        this();
        this.load(packed, keySource, false, false);
    }

    public Capsule(byte[] packed, KeySource keySource, boolean allowPartiallySigned, boolean allowOnlyPublic) throws BadSignatureException, IOException {
        this();
        this.load(packed, keySource, allowPartiallySigned, allowOnlyPublic);
    }

    public Capsule load(byte[] packedCoffer, KeySource keySource, boolean allowPartiallySigned, boolean allowOnlyPublic) throws BadSignatureException, EncryptionError {
        try {
            Binder payload = this.unpackPayload(packedCoffer, allowPartiallySigned);
            Binder secret = payload.getBinder("private");
            this.decryptionFailed = false;
            if (!secret.isEmpty()) {
                this.privateData = null;
                byte[] encryptedData = secret.getBinary("data");
                block5: for (Binder b : secret.getBinders("keys")) {
                    for (AbstractKey k : keySource.findKey(new KeyInfo(b.getBinary("keyInfo")))) {
                        byte[] encryptedKey = b.getBinary("key");
                        try {
                            SymmetricKey sk = new SymmetricKey(k.decrypt(encryptedKey));
                            this.privateData = Boss.unpack(sk.etaDecrypt(encryptedData));
                            break block5;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (this.privateData == null) {
                    if (!allowOnlyPublic) {
                        throw new DecryptionFailedException("can't decrypt private data");
                    }
                    this.decryptionFailed = true;
                }
            }
            return this;
        }
        catch (BadSignatureException | DecryptionFailedException e) {
            throw e;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new FormatException("failed to read capsule", e);
        }
    }

    private @NonNull Binder unpackPayload(byte[] packedCoffer, boolean allowPartiallySigned) throws EncryptionError {
        this.signed = false;
        Binder outer = Boss.unpack(packedCoffer);
        ArrayList<Binder> signatures = outer.getBinders("signatures");
        byte[] source = outer.getBinary("content");
        Binder payload = Boss.unpack(source);
        if (!payload.get("type").equals("capsule")) {
            throw new FormatException("not capsule/unknown type");
        }
        this.checkSignatures(source, signatures, payload, allowPartiallySigned);
        this.publicData = payload.getBinder("public");
        return payload;
    }

    private void checkSignatures(byte[] src, Collection<Binder> signatures, Binder payload, boolean allowPartiallySigned) throws EncryptionError {
        AbstractKey k;
        this.signed = false;
        this.partiallySigned = false;
        this.clearSigners();
        if (signatures == null || signatures.isEmpty()) {
            return;
        }
        for (Binder b : payload.getBinders("signers")) {
            k = new PublicKey();
            ((PublicKey)k).unpack(b.getBinary("key"));
            Binder result = new Binder();
            result.put("key", k);
            String id = b.getStringOrThrow("id");
            result.put("id", id);
            result.put("data", b.getBinder("data"));
            this.signers.put(id, result);
        }
        if (this.signers.size() != signatures.size() && !allowPartiallySigned) {
            throw new BadSignatureException("signatures do not match signers");
        }
        for (Binder sig : signatures) {
            k = (AbstractKey)this.signers.get(sig.getStringOrThrow("key")).get("key");
            if (k.verify(src, sig.getBinary("signature"), HashType.SHA512)) continue;
            throw new BadSignatureException("signature is broken at " + sig.getStringOrThrow("key"));
        }
        if (this.signers.isEmpty()) {
            this.partiallySigned = false;
            this.signed = false;
        } else {
            this.signed = this.signers.size() == signatures.size();
            this.partiallySigned = !this.signed;
        }
    }

    public void setPublicData(Binder publicData) {
        this.publicData = publicData;
    }

    public Binder getPublicData() {
        return this.publicData;
    }

    public void setPrivateData(Binder privateData) {
        this.privateData = privateData;
    }

    public Binder getPrivateData() {
        return this.privateData;
    }

    public void clearSigners() {
        this.signers.clear();
    }

    public void addSigners(Collection<AbstractKey> signers) {
        for (AbstractKey k : signers) {
            this.addSigner(k, null);
        }
    }

    public void addSigners(AbstractKey ... keys) {
        this.addSigners(Do.collection(keys));
    }

    public String addSigner(AbstractKey key, Binder signerData) {
        String id = String.valueOf(this.signers.size());
        this.signers.put(id, new Binder("id", id, "key", key, "data", signerData));
        return id;
    }

    Binder getSigner(AbstractKey key) {
        for (Binder b : this.signers.values()) {
            if (!b.get("key").equals(key)) continue;
            return b;
        }
        throw new IllegalArgumentException("key is not found");
    }

    String getSignerId(AbstractKey key) {
        return this.getSigner(key).getStringOrThrow("id");
    }

    AbstractKey getSignerKey(String signerKeyId) {
        return (AbstractKey)this.signers.get(signerKeyId).get("key");
    }

    public Binder getSignerData(AbstractKey key) {
        return this.getSigner(key).getBinder("data");
    }

    public Binder getSignerData(String signerKeyId) {
        return this.signers.get(signerKeyId).getBinder("data");
    }

    public void clearKeys() {
        this.encryptingKeys.clear();
    }

    public void addKeys(Collection<AbstractKey> keys) {
        this.encryptingKeys.addAll(keys);
    }

    public void addKeys(AbstractKey ... keys) {
        this.addKeys(Do.collection(keys));
    }

    public byte[] pack() throws EncryptionError {
        Binder payload = this.preparePayload();
        HashMap<String, AbstractKey> sigIds = this.prepareSigners(payload);
        Binder outer = new Binder();
        byte[] content = Boss.pack(payload);
        outer.put("content", content);
        if (!sigIds.isEmpty()) {
            ArrayList<Binder> signatures = outer.set("signatures", new ArrayList());
            for (Map.Entry<String, AbstractKey> e : sigIds.entrySet()) {
                signatures.add(new Binder("key", e.getKey(), "signature", e.getValue().sign(content, HashType.SHA512)));
            }
        }
        return Boss.pack(outer);
    }

    private @NonNull HashMap<String, AbstractKey> prepareSigners(Binder payload) {
        HashMap<String, AbstractKey> sigIds = new HashMap<String, AbstractKey>();
        if (this.signers != null && !this.signers.isEmpty()) {
            ArrayList<Binder> s = payload.set("signers", new ArrayList());
            boolean i = false;
            for (Binder b : this.signers.values()) {
                String id = b.getStringOrThrow("id");
                AbstractKey key = (AbstractKey)b.get("key");
                sigIds.put(id, key);
                Binder signerData = new Binder("id", id, "key", key.getPublicKey().pack(), "data", b.getBinder("data"));
                s.add(signerData);
            }
        }
        return sigIds;
    }

    private @NonNull Binder preparePayload() throws EncryptionError {
        Binder payload = new Binder();
        if (this.hasPrivate()) {
            if (this.encryptingKeys == null || this.encryptingKeys.isEmpty()) {
                throw new IllegalStateException("missing encryption keys");
            }
            SymmetricKey mainKey = new SymmetricKey();
            byte[] packedMainKey = mainKey.pack();
            Binder data = payload.set("private", new Binder());
            ArrayList<Binder> keys = data.set("keys", new ArrayList());
            for (AbstractKey k : this.encryptingKeys) {
                if (k == null) {
                    throw new IllegalStateException("null is forbidden in encryption keys");
                }
                Binder b = new Binder("keyInfo", k.packedInfo(), "key", k.encrypt(packedMainKey));
                keys.add(b);
            }
            byte[] packedPrivate = Boss.dumpToArray(this.privateData, new Object[]{CTRTransformer.randomBytes(0, 117)});
            data.put("data", mainKey.etaEncrypt(packedPrivate));
        }
        if (this.hasPublic()) {
            payload.put("public", this.publicData);
        }
        payload.put("type", "capsule");
        return payload;
    }

    private boolean hasPublic() {
        return this.publicData != null && !this.publicData.isEmpty();
    }

    private boolean hasPrivate() {
        return this.privateData != null && !this.privateData.isEmpty();
    }

    public void setPublicData(Object ... keysAndValues) {
        this.setPublicData(new Binder(keysAndValues));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Capsule)) {
            return false;
        }
        Capsule other = (Capsule)obj;
        if (this.publicData != null && !this.publicData.equals(other.publicData)) {
            return false;
        }
        return this.privateData == null || this.privateData.equals(other.privateData);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Capsule(");
        if (this.hasPublic()) {
            b.append("public:" + Arrays.toString(this.publicData.entrySet().toArray()));
        }
        if (this.hasPrivate()) {
            if (this.hasPublic()) {
                b.append(",");
            }
            b.append("private:" + Arrays.toString(this.privateData.entrySet().toArray()));
        }
        return b.toString() + ")";
    }

    public static interface KeySource {
        public Collection<AbstractKey> findKey(KeyInfo var1);
    }

    public class DecryptionFailedException
    extends EncryptionError {
        public DecryptionFailedException(String reason) {
            super(reason);
        }

        public DecryptionFailedException(String reason, Throwable cause) {
            super(reason, cause);
        }
    }

    public class BadSignatureException
    extends FormatException {
        public BadSignatureException() {
            super("bad coffer signature");
        }

        public BadSignatureException(String message) {
            super(message);
        }

        public BadSignatureException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public class FormatException
    extends EncryptionError {
        public FormatException() {
            super("bad coffer format");
        }

        public FormatException(String message) {
            super(message);
        }

        public FormatException(String message, Throwable cause) {
            super(message, cause);
        }

        Capsule getCoffer() {
            return Capsule.this;
        }
    }
}

