/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.BlockCipher;
import com.icodici.crypto.CTRTransformer;
import com.icodici.crypto.EncryptionError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sergeych.tools.Do;

public class DecryptingStream
extends InputStream {
    private final InputStream inputStream;
    private final CTRTransformer transformer;

    public DecryptingStream(BlockCipher cipher, InputStream inputStream) throws EncryptionError, IOException {
        this.inputStream = inputStream;
        byte[] iv = new byte[cipher.getBlockSize()];
        inputStream.read(iv);
        this.transformer = new CTRTransformer(cipher, iv);
    }

    public DecryptingStream(Class<? extends BlockCipher> cipherClass, byte[] key, InputStream inputStream) throws EncryptionError, IOException {
        this(CTRTransformer.makeCipher(cipherClass, key), inputStream);
    }

    @Override
    public int read() throws IOException {
        try {
            int i = this.inputStream.read();
            return i >= 0 ? this.transformer.transformByte(i) : -1;
        }
        catch (EncryptionError encryptionError) {
            throw new IOException("decryption failed", encryptionError);
        }
    }

    public static byte[] decrypt(Class<? extends BlockCipher> cipherClass, byte[] key, byte[] encryptedData) throws EncryptionError {
        ByteArrayInputStream bis = new ByteArrayInputStream(encryptedData);
        try {
            return Do.read(new DecryptingStream(cipherClass, key, bis));
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOException", e);
        }
    }

    public static byte[] decrypt(BlockCipher cipher, byte[] encryptedData) throws EncryptionError {
        ByteArrayInputStream bis = new ByteArrayInputStream(encryptedData);
        try {
            return Do.read(new DecryptingStream(cipher, bis));
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOException", e);
        }
    }
}

