/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.BlockCipher;
import com.icodici.crypto.CTRTransformer;
import com.icodici.crypto.EncryptionError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptingStream
extends OutputStream {
    private final CTRTransformer transformer;
    private final OutputStream outputStream;

    public EncryptingStream(Class<? extends BlockCipher> cipherClass, byte[] key, OutputStream outputStream) throws EncryptionError, IOException {
        this(CTRTransformer.makeCipher(cipherClass, key), outputStream);
    }

    public EncryptingStream(BlockCipher cipher, OutputStream outputStream) throws EncryptionError, IOException {
        this.transformer = new CTRTransformer(cipher, null);
        this.outputStream = outputStream;
        outputStream.write(this.transformer.getIV());
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.outputStream.write(this.transformer.transformByte(b));
        }
        catch (EncryptionError encryptionError) {
            throw new RuntimeException("can't encrypt data", encryptionError);
        }
    }

    static byte[] encrypt(Class<? extends BlockCipher> cipherClass, byte[] key, byte[] source) throws EncryptionError {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            new EncryptingStream(cipherClass, key, bos).write(source);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOException", e);
        }
        return bos.toByteArray();
    }

    static byte[] encrypt(BlockCipher cipher, byte[] source) throws EncryptionError {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            new EncryptingStream(cipher, bos).write(source);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOException", e);
        }
        return bos.toByteArray();
    }
}

