/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA3Digest;
import org.spongycastle.crypto.digests.SHA512Digest;

public enum HashType {
    SHA1,
    SHA256,
    SHA512,
    SHA3_256,
    SHA3_384,
    SHA3_512;

    private static Map algorithmByType;
    private static Map algorithmNameByType;
    private static Map algorithmTypeByName;

    public Digest makeDigest() {
        Digest result = (Digest)algorithmByType.get((Object)this);
        try {
            return (Digest)result.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format("Unsupported digest %s", new Object[]{this}));
        }
    }

    public String getAlgorithmName() {
        return (String)algorithmNameByType.get((Object)this);
    }

    public static HashType getByAlgorithmName(String algorithmName) {
        HashType hashTypeClass = (HashType)((Object)algorithmTypeByName.get(algorithmName));
        if (hashTypeClass == null) {
            return null;
        }
        return hashTypeClass;
    }

    static {
        algorithmByType = Collections.unmodifiableMap(new HashMap<HashType, Digest>(){
            {
                this.put(SHA1, new SHA1Digest());
                this.put(SHA256, new SHA256Digest());
                this.put(SHA512, new SHA512Digest());
                this.put(SHA3_256, new SHA3Digest(256));
                this.put(SHA3_384, new SHA3Digest(384));
                this.put(SHA3_512, new SHA3Digest(512));
            }
        });
        algorithmNameByType = Collections.unmodifiableMap(new HashMap<HashType, String>(){
            {
                for (Object key : algorithmByType.keySet()) {
                    this.put((HashType)((Object)key), ((Digest)algorithmByType.get(key)).getAlgorithmName());
                }
            }
        });
        algorithmTypeByName = Collections.unmodifiableMap(new HashMap<String, HashType>(){
            {
                for (Object key : algorithmByType.keySet()) {
                    this.put(((Digest)algorithmByType.get(key)).getAlgorithmName(), (HashType)((Object)key));
                }
            }
        });
    }
}

