/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.KeyInfo;
import com.icodici.crypto.KeyMatcher;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.digest.Crc32;
import com.icodici.crypto.digest.Digest;
import com.icodici.crypto.digest.Sha3_256;
import com.icodici.crypto.digest.Sha3_384;
import com.icodici.crypto.digest.SpongyCastleDigest;
import java.util.Arrays;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Safe58;

public class KeyAddress
implements KeyMatcher {
    private final int keyMask;
    private final byte[] keyDigest;
    private boolean _isLong;
    private byte[] packed;
    private int typeMark;

    public KeyAddress() {
        this.keyMask = 0;
        this.keyDigest = null;
    }

    public KeyAddress(AbstractKey key, int typeMark, boolean useSha3_384) {
        this.typeMark = typeMark;
        if ((typeMark & 0xF0) != 0) {
            throw new IllegalArgumentException("type mark must be in [0..15] range");
        }
        this.keyMask = KeyAddress.mask(key);
        SpongyCastleDigest digest = useSha3_384 ? new Sha3_384() : new Sha3_256();
        this._isLong = useSha3_384;
        this.packed = new byte[5 + ((Digest)digest).getLength()];
        this.packed[0] = (byte)((this.keyMask << 4 | typeMark) & 0xFF);
        this.keyDigest = key.updateDigestWithKeyComponents(digest).digest();
        System.arraycopy(this.keyDigest, 0, this.packed, 1, this.keyDigest.length);
        Crc32 crc = new Crc32();
        crc.update(this.packed, 0, 1 + ((Digest)digest).getLength());
        System.arraycopy(crc.digest(), 0, this.packed, 1 + ((Digest)digest).getLength(), 4);
    }

    public KeyAddress(byte[] packedSource) throws IllegalAddressException {
        this.packed = packedSource;
        this.typeMark = packedSource[0] & 0xF;
        this.keyMask = (packedSource[0] & 0xFF) >> 4;
        if (this.keyMask == 0) {
            throw new IllegalAddressException("keyMask is 0");
        }
        this._isLong = packedSource.length == 53;
        SpongyCastleDigest digest = this._isLong ? new Sha3_384() : new Sha3_256();
        int digestLength1 = 1 + ((Digest)digest).getLength();
        this.keyDigest = Arrays.copyOfRange(this.packed, 1, digestLength1);
        Crc32 crc = new Crc32();
        crc.update(this.packed, 0, digestLength1);
        if (!Arrays.equals(crc.digest(), Arrays.copyOfRange(this.packed, digestLength1, digestLength1 + 4))) {
            throw new IllegalAddressException("control code failed, address is broken");
        }
    }

    public KeyAddress(String packedString) throws IllegalAddressException {
        this(Safe58.decode(packedString));
    }

    public KeyAddress(Binder binder) {
        this.keyMask = 0;
        this.keyDigest = new byte[0];
    }

    @Override
    public boolean isMatchingKey(AbstractKey key) {
        KeyAddress other = new KeyAddress(key, 0, this._isLong);
        if (other.keyMask != this.keyMask) {
            return false;
        }
        return Arrays.equals(this.keyDigest, other.keyDigest);
    }

    @Override
    public boolean isMatchingKeyAddress(KeyAddress other) {
        if (this._isLong != other._isLong) {
            throw new IllegalArgumentException("can't match addresses of different length");
        }
        return other.keyMask == this.keyMask && Arrays.equals(this.keyDigest, other.keyDigest);
    }

    public final boolean isLong() {
        return this._isLong;
    }

    public final byte[] getPacked() {
        return this.packed;
    }

    public final int getTypeMark() {
        return this.typeMark;
    }

    public String toString() {
        return Safe58.encode(this.packed);
    }

    protected static int mask(AbstractKey k) {
        KeyInfo i = k.info();
        switch (i.getAlgorythm()) {
            case RSAPublic: 
            case RSAPrivate: {
                if (((PublicKey)k).getPublicExponent() != 65537L) break;
                int l = i.getKeyLength();
                if (l == 256) {
                    return 1;
                }
                if (l != 512) break;
                return 2;
            }
        }
        throw new IllegalArgumentException("key can't be masked for address: " + i);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyAddress) {
            KeyAddress ka = (KeyAddress)obj;
            return Arrays.equals(ka.getPacked(), this.getPacked());
        }
        return super.equals(obj);
    }

    static {
        DefaultBiMapper.registerAdapter(KeyAddress.class, new BiAdapter(){

            public Binder serialize(Object object, BiSerializer serializer) {
                return Binder.of("uaddress", serializer.serialize(((KeyAddress)object).getPacked()), new Object[0]);
            }

            public Object deserialize(Binder binder, BiDeserializer deserializer) {
                try {
                    return new KeyAddress(binder.getBinaryOrThrow("uaddress"));
                }
                catch (IllegalAddressException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("can't reconstruct KeyAddress");
                }
            }

            @Override
            public String typeName() {
                return "KeyAddress";
            }
        });
    }

    public static class IllegalAddressException
    extends Exception {
        public IllegalAddressException() {
        }

        public IllegalAddressException(String message) {
            super(message);
        }

        public IllegalAddressException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

