/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.Capsule;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.KeyInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sergeych.tools.Bindable;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import org.checkerframework.checker.nullness.qual.NonNull;

public class KeyRing
implements Capsule.KeySource,
Bindable {
    private final HashSet<AbstractKey> keys = new HashSet();

    @Override
    public Binder toBinder() {
        ArrayList<Binder> result = new ArrayList<Binder>();
        for (AbstractKey k : this.keys) {
            result.add(k.toBinder());
        }
        return new Binder("keys", result);
    }

    public static KeyRing fromBinder(Binder source) throws IOException, EncryptionError {
        return new KeyRing().updateFrom(source);
    }

    public KeyRing updateFrom(Binder source) throws IOException, EncryptionError {
        for (Binder kb : source.getBinders("keys")) {
            KeyInfo ki = new KeyInfo(kb.getBinary("keyInfo"));
            AbstractKey k = ki.unpackKey(kb.getBinary("data"));
            this.keys.add(k);
        }
        return this;
    }

    public void clear() {
        this.keys.clear();
    }

    public void addKey(AbstractKey key) {
        this.keys.add(key);
    }

    public boolean removeKey(AbstractKey key) {
        return this.keys.remove(key);
    }

    @Override
    public @NonNull Collection<AbstractKey> findKey(KeyInfo keyInfo) {
        ArrayList<AbstractKey> result = new ArrayList<AbstractKey>();
        for (AbstractKey k : this.keys) {
            KeyInfo ki = k.info();
            if (!ki.matchType(keyInfo)) continue;
            if (ki.matchTag(keyInfo)) {
                result.add(0, k);
                continue;
            }
            result.add(k);
        }
        return result;
    }

    public void addKeys(AbstractKey ... newKeys) {
        this.keys.addAll(Do.collection(newKeys));
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyRing) {
            return this.keys.equals(((KeyRing)obj).keys);
        }
        return super.equals(obj);
    }

    public String toString() {
        return "KeyRing(" + this.keys.toString() + ")";
    }

    public boolean contains(AbstractKey k) {
        return this.keys.contains(k);
    }

    Set<AbstractKey> keySet() {
        return this.keys;
    }
}

