/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.digest.Digest;
import com.icodici.crypto.digest.HMAC;
import java.nio.charset.Charset;
import java.util.Arrays;

public class PBKDF2 {
    private static Charset utf8 = Charset.forName("utf-8");
    private final Class<? extends Digest> hashClass;
    private final byte[] salt;
    private final int c;
    private final int dkLen;
    private final int hLen;
    private byte[] computed;
    private byte[] passwordBytes;

    private PBKDF2(Class<? extends Digest> hashClass, String password, byte[] salt, int c, int dkLen) {
        this.hashClass = hashClass;
        this.passwordBytes = password.getBytes(utf8);
        this.salt = salt;
        this.c = c;
        this.dkLen = dkLen;
        Digest d = this.hashInstance();
        this.hLen = d.getLength();
    }

    private byte[] compute() {
        if (this.computed == null) {
            int nBlocks = (this.dkLen + this.hLen - 1) / this.hLen;
            byte[] result = new byte[nBlocks * this.hLen];
            for (int i = 0; i < nBlocks; ++i) {
                System.arraycopy(this.F(i + 1), 0, result, i * this.hLen, this.hLen);
            }
            this.computed = Arrays.copyOf(result, this.dkLen);
        }
        return this.computed;
    }

    private byte[] F(int i) {
        byte[] block;
        Digest d = this.hashInstance();
        d.update(this.salt);
        d.update(i >> 24 & 0xFF);
        d.update(i >> 16 & 0xFF);
        d.update(i >> 8 & 0xFF);
        d.update(i & 0xFF);
        byte[] u1 = block = d.digest();
        for (int k = 1; k < this.c; ++k) {
            d = this.hashInstance();
            d.update(u1);
            byte[] u2 = d.digest();
            for (int j = 0; j < this.hLen; ++j) {
                int n = j;
                block[n] = (byte)(block[n] ^ u2[j]);
            }
            u1 = u2;
        }
        return block;
    }

    private Digest hashInstance() {
        return new HMAC(this.passwordBytes, this.hashClass);
    }

    public static byte[] derive(Class<? extends Digest> hash, String password, byte[] salt, int c, int dkLen) {
        return new PBKDF2(hash, password, salt, c, dkLen).compute();
    }
}

