/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.KeyInfo;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.digest.Digest;
import com.icodici.crypto.rsaoaep.RSAOAEPPrivateKey;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.utils.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PrivateKey
extends AbstractKey {
    private final RSAOAEPPrivateKey privateKey = new RSAOAEPPrivateKey();
    private PublicKey cachedPublicKey;

    public PrivateKey(byte[] packedBinaryKey, KeyInfo info) throws EncryptionError {
        this(packedBinaryKey);
    }

    public PrivateKey(byte[] packedBinaryKey) throws EncryptionError {
        List parts = (List)Boss.load(packedBinaryKey);
        if ((Integer)parts.get(0) == 0) {
            try {
                Binder pp = new Binder("e", ((Bytes)parts.get(1)).toArray(), "p", ((Bytes)parts.get(2)).toArray(), "q", ((Bytes)parts.get(3)).toArray());
                this.privateKey.updateFromHash(pp);
            }
            catch (Exception error) {
                error.printStackTrace();
                throw new EncryptionError("failed to parse private key", error);
            }
        } else {
            throw new EncryptionError("Bad or unknown private key type");
        }
    }

    public PrivateKey(int bitStrength) {
        this.privateKey.generate(bitStrength, HashType.SHA1);
    }

    public PrivateKey() {
    }

    @Override
    public byte[] decrypt(byte[] encrypted) throws EncryptionError {
        return this.privateKey.decrypt(encrypted);
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.cachedPublicKey == null) {
            this.cachedPublicKey = new PublicKey(this.privateKey.getPublicKey());
        }
        return this.cachedPublicKey;
    }

    @Override
    public byte[] pack() {
        @NonNull Map<String, Object> params = this.privateKey.toHash();
        return Boss.dumpToArray(new Object[]{0, params.get("e"), params.get("p"), params.get("q")}, new Object[0]);
    }

    @Override
    public byte[] sign(InputStream input, HashType hashType) throws EncryptionError, IOException {
        return this.privateKey.sign(input, hashType);
    }

    @Override
    public KeyInfo info() {
        if (this.keyInfo == null) {
            KeyInfo i = this.getPublicKey().info();
            this.keyInfo = new KeyInfo(KeyInfo.Algorythm.RSAPrivate, i.getTag(), this.privateKey.getBitStrength() / 8);
        }
        return super.info();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PrivateKey)) {
            return false;
        }
        Map<String, Object> a = this.privateKey.toHash();
        Map<String, Object> b = ((PrivateKey)obj).privateKey.toHash();
        return Arrays.equals((byte[])a.get("e"), (byte[])b.get("e")) && Arrays.equals((byte[])a.get("p"), (byte[])b.get("p")) && Arrays.equals((byte[])a.get("q"), (byte[])b.get("q"));
    }

    public int hashCode() {
        Map<String, Object> a = this.privateKey.toHash();
        byte[] key = (byte[])a.get("p");
        return key[0] + (key[1] << 8) + (key[2] << 16) + (key[3] << 24);
    }

    @Override
    public byte[] fingerprint() {
        return this.getPublicKey().fingerprint();
    }

    public static PrivateKey fromPath(Path path) throws IOException {
        return new PrivateKey(Do.read(path.toAbsolutePath().toString()));
    }

    @Override
    public Digest updateDigestWithKeyComponents(Digest digest) {
        return this.getPublicKey().updateDigestWithKeyComponents(digest);
    }

    static {
        DefaultBiMapper.registerAdapter(PrivateKey.class, new BiAdapter(){

            public Binder serialize(Object object, BiSerializer serializer) {
                return Binder.fromKeysValues("packed", ((PrivateKey)object).pack());
            }

            public Object deserialize(Binder binder, BiDeserializer deserializer) {
                try {
                    return new PrivateKey(binder.getBinaryOrThrow("packed"));
                }
                catch (EncryptionError encryptionError) {
                    return null;
                }
            }

            @Override
            public String typeName() {
                return "RSAPrivateKey";
            }
        });
    }
}

