/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.AbstractPublicKey;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.KeyInfo;
import com.icodici.crypto.digest.Digest;
import com.icodici.crypto.digest.Sha256;
import com.icodici.crypto.rsaoaep.RSAOAEPPublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Hashable;
import net.sergeych.utils.Bytes;
import net.sergeych.utils.Ut;

public class PublicKey
extends AbstractKey {
    private final RSAOAEPPublicKey publicKey;
    private byte[] cachedHint;
    private boolean publicExponent;
    private byte[] _fingerprint;
    public static final BiAdapter PUBLIC_KEY_BI_ADAPTER = new BiAdapter(){

        public Binder serialize(Object object, BiSerializer serializer) {
            return Binder.of("packed", serializer.serialize(((PublicKey)object).pack()), new Object[0]);
        }

        public Object deserialize(Binder binder, BiDeserializer deserializer) {
            try {
                return new PublicKey(binder.getBinaryOrThrow("packed"));
            }
            catch (EncryptionError encryptionError) {
                return null;
            }
        }

        @Override
        public String typeName() {
            return "RSAPublicKey";
        }
    };

    public PublicKey(AbstractPublicKey publicKey) {
        this.publicKey = (RSAOAEPPublicKey)publicKey;
        this.setupInfo(this.pack());
    }

    public PublicKey() {
        this.publicKey = new RSAOAEPPublicKey();
    }

    public PublicKey(byte[] bytes) throws EncryptionError {
        this.publicKey = new RSAOAEPPublicKey();
        this.unpack(bytes);
    }

    public PublicKey(byte[] bytes, KeyInfo info) throws EncryptionError {
        this.publicKey = new RSAOAEPPublicKey();
        this.unpack(bytes, info);
    }

    @Override
    public void unpack(byte[] bytes) throws EncryptionError {
        this.unpack(bytes, null);
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    public int getBitStrength() {
        return this.publicKey.getBitStrength();
    }

    public void unpack(byte[] bytes, KeyInfo info) throws EncryptionError {
        List parts = (List)Boss.load(bytes);
        if ((Integer)parts.get(0) != 1) {
            throw new EncryptionError("invalid packed public key");
        }
        try {
            Binder pp = new Binder("e", ((Bytes)parts.get(1)).toArray(), "n", ((Bytes)parts.get(2)).toArray());
            this.setComponents(pp);
        }
        catch (Exception error) {
            error.printStackTrace();
            throw new EncryptionError("failed to parse public key", error);
        }
        if (info == null) {
            this.setupInfo(bytes);
        } else {
            this.keyInfo = info;
        }
    }

    private void setupInfo(byte[] bytes) {
        this.keyInfo = new KeyInfo(KeyInfo.Algorythm.RSAPublic, Arrays.copyOfRange(this.fingerprint(), 1, 6), this.publicKey.getBitStrength() / 8);
    }

    private void setComponents(Binder pp) throws Hashable.Error {
        this.publicKey.updateFromHash(pp);
        this.cachedHint = null;
    }

    public byte[] encrypt(String plainText) throws EncryptionError {
        return this.encrypt(plainText.getBytes(Ut.utf8));
    }

    @Override
    public byte[] encrypt(byte[] bytes) throws EncryptionError {
        return this.publicKey.encrypt(bytes);
    }

    @Override
    public byte[] pack() {
        Map<String, Object> params = this.publicKey.toHash();
        return Boss.dumpToArray(new Object[]{1, params.get("e"), params.get("n")}, new Object[0]);
    }

    @Override
    public boolean verify(InputStream source, byte[] signature, HashType hashType) throws IOException {
        return this.publicKey.checkSignature(source, signature, hashType);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PublicKey) {
            PublicKey k = (PublicKey)obj;
            Map<String, Object> a = this.publicKey.toHash();
            Map<String, Object> b = k.publicKey.toHash();
            return Arrays.equals((byte[])a.get("e"), (byte[])b.get("e")) && Arrays.equals((byte[])a.get("n"), (byte[])b.get("n"));
        }
        return super.equals(obj);
    }

    public int hashCode() {
        Map<String, Object> a = this.publicKey.toHash();
        byte[] key = (byte[])a.get("n");
        return key[0] + (key[1] << 8) + (key[2] << 16) + (key[3] << 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] fingerprint() {
        RSAOAEPPublicKey rSAOAEPPublicKey = this.publicKey;
        synchronized (rSAOAEPPublicKey) {
            if (this._fingerprint == null) {
                this._fingerprint = new byte[33];
                this._fingerprint[0] = 7;
                System.arraycopy(this.updateDigestWithKeyComponents(new Sha256()).digest(), 0, this._fingerprint, 1, 32);
            }
            return this._fingerprint;
        }
    }

    @Override
    public Digest updateDigestWithKeyComponents(Digest digest) {
        Map<String, Object> a = this.publicKey.toHash();
        digest.update((byte[])a.get("e")).update((byte[])a.get("n"));
        return digest;
    }

    public long getPublicExponent() {
        Map<String, Object> params = this.publicKey.toHash();
        byte[] arr = (byte[])params.get("e");
        long e = 0L;
        for (int i = 0; i < arr.length; ++i) {
            e = e << 8 | (long)arr[i];
        }
        return e;
    }

    static {
        DefaultBiMapper.registerAdapter(PublicKey.class, PUBLIC_KEY_BI_ADAPTER);
    }
}

