/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto;

import com.icodici.crypto.AES256;
import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.BlockCipher;
import com.icodici.crypto.CTRTransformer;
import com.icodici.crypto.DecryptingStream;
import com.icodici.crypto.EncryptingStream;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.KeyInfo;
import com.icodici.crypto.digest.HMAC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import net.sergeych.tools.ByteRingBuffer;
import net.sergeych.tools.Do;
import net.sergeych.tools.Hashable;

public class SymmetricKey
extends AbstractKey
implements Serializable,
Hashable {
    private byte[] key;
    private BlockCipher cipher = null;

    public static SymmetricKey fromPassword(String password, int rounds) {
        return SymmetricKey.fromPassword(password, rounds, null);
    }

    public static SymmetricKey fromPassword(String password, int rounds, byte[] salt) {
        return new KeyInfo(KeyInfo.PRF.HMAC_SHA256, rounds, salt, null).derivePassword(password);
    }

    public SymmetricKey() {
        this.key = CTRTransformer.randomBytes(32);
        this.keyInfo = new KeyInfo(KeyInfo.Algorythm.AES256, null, 32);
    }

    public SymmetricKey(byte[] key) {
        this.setKey(key);
    }

    public SymmetricKey(byte[] key, KeyInfo keyInfo) {
        this.setKey(key);
        this.keyInfo = keyInfo;
    }

    public void setKey(byte[] key) {
        this.cipher = null;
        this.key = key;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getBitStrength() {
        return this.getSize() * 8;
    }

    public int getSize() {
        return this.key.length;
    }

    @Override
    public Map<String, Object> toHash() throws IllegalStateException {
        return Do.map("key", this.key);
    }

    @Override
    public void updateFromHash(Map<String, Object> hash) throws Hashable.Error {
        this.setKey((byte[])hash.get("key"));
    }

    protected BlockCipher getCipher() {
        if (this.cipher == null) {
            this.cipher = new AES256();
            this.cipher.initialize(BlockCipher.Direction.ENCRYPT, this);
        }
        return this.cipher;
    }

    @Override
    public byte[] encrypt(byte[] plaintext) throws EncryptionError {
        return EncryptingStream.encrypt(this.getCipher(), plaintext);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws EncryptionError {
        return DecryptingStream.decrypt(this.getCipher(), ciphertext);
    }

    public OutputStream encryptStream(OutputStream outputStream) throws IOException, EncryptionError {
        return new EncryptingStream(this.getCipher(), outputStream);
    }

    public InputStream decryptStream(InputStream inputStream) throws IOException, EncryptionError {
        return new DecryptingStream(this.getCipher(), inputStream);
    }

    public EtaEncryptingStream etaEncryptStream(OutputStream out) throws IOException, EncryptionError {
        return new EtaEncryptingStream(out);
    }

    public EtaDecryptingStream etaDecryptStream(InputStream in) throws IOException, EncryptionError {
        return new EtaDecryptingStream(in);
    }

    public byte[] etaEncrypt(byte[] data) throws EncryptionError {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            EtaEncryptingStream s = this.etaEncryptStream(bos);
            s.write(data);
            s.end();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOError", e);
        }
    }

    public byte[] etaSign(byte[] data) throws EncryptionError {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            EtaEncryptingStream s = new EtaEncryptingStream(bos, false);
            s.write(data);
            s.end();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOError", e);
        }
    }

    public byte[] etaDecrypt(byte[] data) throws EncryptionError, AuthenticationFailed {
        try {
            return Do.read(this.etaDecryptStream(new ByteArrayInputStream(data)));
        }
        catch (AuthenticationFailed e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOError", e);
        }
    }

    public static byte[] xor(byte[] src, int value) {
        byte[] result = new byte[src.length];
        for (int i = 0; i < src.length; ++i) {
            result[i] = (byte)((src[i] ^ value) & 0xFF);
        }
        return result;
    }

    @Override
    public byte[] pack() {
        if (this.key == null) {
            throw new IllegalStateException("key is not yet initialized, no keyInfo is available");
        }
        return this.key;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SymmetricKey)) {
            return false;
        }
        return Arrays.equals(this.key, ((SymmetricKey)obj).key);
    }

    public int hashCode() {
        return this.key[0] + (this.key[1] << 8) + (this.key[2] << 16) + (this.key[3] << 24);
    }

    public class EtaEncryptingStream
    extends OutputStream {
        private final HMAC hmac;
        private boolean done = false;
        private OutputStream outputStream;
        private CTRTransformer transformer;

        EtaEncryptingStream(OutputStream outputStream) throws IOException, EncryptionError {
            this(outputStream, true);
        }

        EtaEncryptingStream(OutputStream outputStream, boolean encrypt) throws IOException, EncryptionError {
            int blockSize = 64;
            this.outputStream = outputStream;
            this.hmac = new HMAC(SymmetricKey.this.key);
            if (encrypt) {
                this.transformer = new CTRTransformer(SymmetricKey.this.getCipher(), null);
                outputStream.write(this.transformer.getIV());
            }
        }

        public void end() throws IOException {
            if (this.done) {
                return;
            }
            this.done = true;
            this.outputStream.write(this.hmac.digest());
        }

        @Override
        public void close() throws IOException {
            if (!this.done) {
                this.end();
            }
            this.outputStream.close();
        }

        @Override
        public void write(int plain) throws IOException {
            if (this.done) {
                throw new EOFException("can't write past the end()");
            }
            try {
                int encrypted = this.transformer == null ? plain : this.transformer.transformByte(plain);
                this.hmac.update(encrypted);
                this.outputStream.write(encrypted);
            }
            catch (EncryptionError encryptionError) {
                throw new IOException("failed to encrypt", encryptionError);
            }
        }
    }

    public class EtaDecryptingStream
    extends InputStream {
        private final InputStream inputStream;
        private final CTRTransformer transformer;
        private final ByteRingBuffer ring;
        private final HMAC hmac;
        private boolean readingFinished = false;

        EtaDecryptingStream(InputStream inputStream) throws IOException, EncryptionError {
            this.inputStream = inputStream;
            byte[] IV = new byte[SymmetricKey.this.getCipher().getBlockSize()];
            inputStream.read(IV);
            this.transformer = new CTRTransformer(SymmetricKey.this.getCipher(), IV);
            this.hmac = new HMAC(SymmetricKey.this.key);
            this.ring = new ByteRingBuffer(this.hmac.getLength() + 8);
            for (int i = 0; i < this.hmac.getLength(); ++i) {
                this.ring.put(inputStream.read());
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (!this.readingFinished) {
                int c;
                int i;
                for (i = 0; i < len && (c = this.read()) != -1; ++i) {
                    b[off + i] = (byte)c;
                }
                return i;
            }
            return -1;
        }

        @Override
        public int read() throws IOException {
            int nextByte = this.inputStream.read();
            if (nextByte < 0) {
                this.readingFinished = true;
                this.end();
                return -1;
            }
            this.ring.put(nextByte);
            try {
                int encrypted = this.ring.get();
                this.hmac.update(encrypted);
                return this.transformer.transformByte(encrypted);
            }
            catch (EncryptionError encryptionError) {
                throw new IOException("failed to decrypt", encryptionError);
            }
        }

        private void end() throws IOException {
            byte[] readHmac = this.ring.readAll();
            if (readHmac.length != this.hmac.getLength()) {
                throw new IOException("stream corrupted: bad hmac record size:" + readHmac.length);
            }
            if (!Arrays.equals(readHmac, this.hmac.digest())) {
                throw new AuthenticationFailed("HMAC authentication failed, data corrupted");
            }
        }
    }

    public class AuthenticationFailed
    extends IOException {
        public AuthenticationFailed() {
        }

        public AuthenticationFailed(String message) {
            super(message);
        }
    }
}

