/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto.digest;

import java.io.IOException;
import java.io.InputStream;
import net.sergeych.utils.Bytes;

public abstract class Digest {
    private byte[] lastDigest = null;

    protected abstract void _update(byte[] var1, int var2, int var3);

    protected abstract byte[] _digest();

    public abstract int getLength();

    protected int getChunkSize() {
        return 64;
    }

    public void update(byte[] data, int offset, int length) {
        if (this.lastDigest != null) {
            throw new IllegalStateException("digest is already calculated");
        }
        this._update(data, offset, length);
    }

    public byte[] digest() {
        if (this.lastDigest == null) {
            this.lastDigest = this._digest();
        }
        return this.lastDigest;
    }

    public Digest update(byte[] data) {
        this.update(data, 0, data.length);
        return this;
    }

    public Digest update(int signleByte) {
        byte[] d = new byte[]{(byte)(signleByte & 0xFF)};
        this.update(d, 0, 1);
        return this;
    }

    public Digest update(String data) {
        return this.update(data.getBytes());
    }

    public byte[] digest(byte[] data) {
        this.update(data);
        return this.digest();
    }

    public String hexDigest() {
        return new Bytes(new byte[][]{this.digest()}).toHex(false);
    }

    public String hexDigest(byte[] data) {
        return new Bytes(new byte[][]{this.digest(data)}).toHex(false);
    }

    public String hexDigest(String data) {
        return new Bytes(new byte[][]{this.digest(data)}).toHex(false);
    }

    public String base64Digest(String data) {
        return new Bytes(new byte[][]{this.digest(data)}).toBase64();
    }

    public String base64Digest(byte[] data) {
        return new Bytes(new byte[][]{this.digest(data)}).toBase64();
    }

    public String base64Digest() {
        return new Bytes(new byte[][]{this.digest()}).toBase64();
    }

    public byte[] digest(String data) {
        this.update(data);
        return this.digest();
    }

    public byte[] digest(InputStream in) throws IOException {
        this.update(in);
        return this.digest();
    }

    private Digest update(InputStream in) throws IOException {
        int size;
        byte[] buffer = new byte[65536];
        while ((size = in.read(buffer)) >= 0) {
            if (size <= 0) continue;
            this.update(buffer, 0, size);
        }
        return this;
    }

    public String base64Digest(InputStream in) throws IOException {
        this.update(in);
        return this.base64Digest();
    }

    public String hexDigest(InputStream in) throws IOException {
        this.update(in);
        return this.hexDigest();
    }
}

