/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto.digest;

import com.icodici.crypto.SymmetricKey;
import com.icodici.crypto.digest.Digest;
import com.icodici.crypto.digest.Sha256;
import java.util.Arrays;

public class HMAC
extends Digest {
    private final Digest hash;
    private final int blockSize;
    private final byte[] oKeyPad;
    private final Class<? extends Digest> hashClass;

    public HMAC(byte[] key) {
        this(key, Sha256.class);
    }

    public HMAC(byte[] key, Class<? extends Digest> hashClass) {
        byte[] keyBlock;
        this.hashClass = hashClass;
        this.hash = this.hashInstance();
        this.blockSize = this.hash.getChunkSize();
        if (key.length > this.blockSize) {
            byte[] kd = new Sha256().digest(key);
            keyBlock = Arrays.copyOf(kd, this.blockSize);
        } else {
            keyBlock = Arrays.copyOf(key, this.blockSize);
        }
        this.oKeyPad = SymmetricKey.xor(keyBlock, 92);
        byte[] iKeyPad = SymmetricKey.xor(keyBlock, 54);
        this.hash.update(iKeyPad);
    }

    @Override
    protected void _update(byte[] data, int offset, int size) {
        this.hash._update(data, offset, size);
    }

    @Override
    protected byte[] _digest() {
        Digest d = this.hashInstance();
        d.update(this.oKeyPad);
        d.update(this.hash.digest());
        return d.digest();
    }

    protected final Digest hashInstance() {
        try {
            return this.hashClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("can't create hash instance");
        }
    }

    @Override
    public int getLength() {
        return this.hash.getLength();
    }
}

