/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto.rsaoaep;

import java.math.BigInteger;
import org.spongycastle.util.BigIntegers;

public class RSAKeyPair {
    public final byte[] n;
    public final byte[] e;
    public final byte[] d;
    public final byte[] p;
    public final byte[] q;
    public final byte[] dP;
    public final byte[] dQ;
    public final byte[] qInv;

    public RSAKeyPair(byte[] n, byte[] e, byte[] d, byte[] p, byte[] q, byte[] dP, byte[] dQ, byte[] qInv) {
        this.n = n;
        this.e = e;
        this.d = d;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
    }

    public static RSAKeyPair fromExponents(byte[] e, byte[] p, byte[] q) {
        BigInteger eInt = BigIntegers.fromUnsignedByteArray(e);
        BigInteger pInt = BigIntegers.fromUnsignedByteArray(p);
        BigInteger qInt = BigIntegers.fromUnsignedByteArray(q);
        BigInteger nInt = pInt.multiply(qInt);
        BigInteger mInt = pInt.subtract(BigInteger.ONE).multiply(qInt.subtract(BigInteger.ONE));
        BigInteger dInt = eInt.modInverse(mInt);
        BigInteger dPInt = dInt.remainder(pInt.subtract(BigInteger.ONE));
        BigInteger dQInt = dInt.remainder(qInt.subtract(BigInteger.ONE));
        BigInteger qInvInt = qInt.modInverse(pInt);
        byte[] n = BigIntegers.asUnsignedByteArray(nInt);
        byte[] d = BigIntegers.asUnsignedByteArray(dInt);
        byte[] dP = BigIntegers.asUnsignedByteArray(dPInt);
        byte[] dQ = BigIntegers.asUnsignedByteArray(dQInt);
        byte[] qInv = BigIntegers.asUnsignedByteArray(qInvInt);
        return new RSAKeyPair(n, e, d, p, q, dP, dQ, qInv);
    }
}

