/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto.rsaoaep;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA224Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA384Digest;
import org.spongycastle.crypto.digests.SHA512Digest;

public class RSAOAEPDigestFactory {
    private static Class[] supportedDigestAlgorithmsClasses = new Class[]{SHA1Digest.class, SHA224Digest.class, SHA256Digest.class, SHA384Digest.class, SHA512Digest.class};
    static Map supportedDigestAlgorithmClassesByName = Collections.unmodifiableMap(new HashMap<String, Class>(){
        {
            for (Class digestClass : supportedDigestAlgorithmsClasses) {
                try {
                    Digest dig = (Digest)digestClass.newInstance();
                    this.put(dig.getAlgorithmName(), digestClass);
                }
                catch (IllegalAccessException | InstantiationException exc) {
                    exc.printStackTrace();
                }
            }
        }
    });

    public static @Nullable Digest getDigestByName(String digestName) {
        Class digestClass = (Class)supportedDigestAlgorithmClassesByName.get(digestName);
        if (digestClass == null) {
            return null;
        }
        try {
            return (Digest)digestClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public static Digest cloneDigest(Digest digest) {
        try {
            return (Digest)digest.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException exc) {
            exc.printStackTrace();
            return digest;
        }
    }
}

