/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto.rsaoaep;

import com.icodici.crypto.AbstractPrivateKey;
import com.icodici.crypto.AbstractPublicKey;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.rsaoaep.RSAEngineFactory;
import com.icodici.crypto.rsaoaep.RSAKeyPair;
import com.icodici.crypto.rsaoaep.RSAOAEPPublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Hashable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.CryptoException;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.encodings.OAEPEncoding;
import org.spongycastle.crypto.generators.RSAKeyPairGenerator;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.crypto.params.RSAKeyGenerationParameters;
import org.spongycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.spongycastle.crypto.signers.PSSSigner;
import org.spongycastle.util.BigIntegers;
import org.spongycastle.util.encoders.Hex;

public class RSAOAEPPrivateKey
extends AbstractPrivateKey {
    public static final HashType DEFAULT_OAEP_HASH = HashType.SHA1;
    public static final HashType DEFAULT_MGF1_HASH = HashType.SHA1;
    private static final byte[] DEFAULT_PUBLIC_EXPONENT = Hex.decode("010001");
    private static final int DEFAULT_RSA_CERTAINTY = 20;
    @Nullable State state;

    public RSAOAEPPrivateKey() {
    }

    @Override
    public String toString() {
        return String.format("RSAOAEPPrivateKey#%s", System.identityHashCode(this));
    }

    RSAOAEPPrivateKey(byte[] e, byte[] p, byte[] q, HashType oaepHashType, HashType mgf1HashType, SecureRandom rng) {
        assert (e != null);
        assert (p != null);
        assert (q != null);
        assert (oaepHashType != null);
        assert (mgf1HashType != null);
        this.init(e, p, q, oaepHashType, mgf1HashType, rng);
    }

    void init(byte[] e, byte[] p, byte[] q, HashType oaepHashType, HashType mgf1HashType, SecureRandom rng) {
        RSAKeyPair keyPair = RSAKeyPair.fromExponents(e, p, q);
        RSAPrivateCrtKeyParameters privParameters = new RSAPrivateCrtKeyParameters(BigIntegers.fromUnsignedByteArray(keyPair.n), BigIntegers.fromUnsignedByteArray(keyPair.e), BigIntegers.fromUnsignedByteArray(keyPair.d), BigIntegers.fromUnsignedByteArray(keyPair.p), BigIntegers.fromUnsignedByteArray(keyPair.q), BigIntegers.fromUnsignedByteArray(keyPair.dP), BigIntegers.fromUnsignedByteArray(keyPair.dQ), BigIntegers.fromUnsignedByteArray(keyPair.qInv));
        AsymmetricBlockCipher decryptor = this.makeDecryptor(mgf1HashType);
        RSAOAEPPublicKey publicKey = new RSAOAEPPublicKey();
        publicKey.init(keyPair.n, keyPair.e, oaepHashType, mgf1HashType, rng);
        this.state = new State(decryptor, privParameters, publicKey, oaepHashType, mgf1HashType, rng);
        this.resetDecryptor();
    }

    private AsymmetricBlockCipher makeDecryptor(HashType mgf1HashType) {
        SHA1Digest dummyDigest = new SHA1Digest();
        return new OAEPEncoding(RSAEngineFactory.make(), dummyDigest, mgf1HashType.makeDigest(), new byte[0]);
    }

    void resetDecryptor() {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        this.state.decryptor.init(false, new ParametersWithRandom(this.state.keyParameters, this.state.rng));
    }

    @Override
    public void generate(int bitStrength, HashType mgf1HashType) {
        this.generate(bitStrength, DEFAULT_PUBLIC_EXPONENT, 20, DEFAULT_OAEP_HASH, mgf1HashType);
    }

    public void generate(int bitStrength, byte[] e, int certainty, HashType oaepHashType, HashType mgf1HashType) {
        RSAKeyPairGenerator keyGen = new RSAKeyPairGenerator();
        keyGen.init(new RSAKeyGenerationParameters(BigIntegers.fromUnsignedByteArray(e), new SecureRandom(), bitStrength, certainty));
        AsymmetricCipherKeyPair keyPair = keyGen.generateKeyPair();
        RSAPrivateCrtKeyParameters privateKey = (RSAPrivateCrtKeyParameters)keyPair.getPrivate();
        if (mgf1HashType == null) {
            mgf1HashType = DEFAULT_MGF1_HASH;
        }
        this.init(e, BigIntegers.asUnsignedByteArray(privateKey.getP()), BigIntegers.asUnsignedByteArray(privateKey.getQ()), oaepHashType, mgf1HashType, new SecureRandom());
    }

    @Override
    public boolean isInitialized() {
        return this.state != null;
    }

    @Override
    public int getBitStrength() throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        return this.state.keyParameters.getModulus().bitLength();
    }

    @Override
    public AbstractPublicKey getPublicKey() throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        return this.state.publicKey;
    }

    @Override
    public boolean canDecrypt() {
        return this.isInitialized();
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws EncryptionError {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        try {
            return this.state.decryptor.processBlock(ciphertext, 0, ciphertext.length);
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionError("decrypt failed", e);
        }
    }

    @Override
    public byte[] sign(InputStream input, HashType hashType, @Nullable byte[] salt) throws IllegalStateException, IOException {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        Digest primaryDigest = hashType.makeDigest();
        PSSSigner signer = salt == null ? new PSSSigner((AsymmetricBlockCipher)RSAEngineFactory.make(), primaryDigest, this.state.mgf1HashType.makeDigest(), RSAOAEPPrivateKey.getMaxSaltLength(this.getBitStrength(), primaryDigest.getDigestSize())) : new PSSSigner((AsymmetricBlockCipher)RSAEngineFactory.make(), primaryDigest, this.state.mgf1HashType.makeDigest(), salt);
        signer.init(true, new ParametersWithRandom(this.state.keyParameters, this.state.rng));
        boolean done = false;
        while (!done) {
            int availableBytes = input.available();
            if (availableBytes <= 0) {
                done = true;
                continue;
            }
            byte[] buffer = new byte[availableBytes];
            int howManyBytesRead = input.read(buffer);
            if (howManyBytesRead <= 0) {
                done = true;
                continue;
            }
            signer.update(buffer, 0, howManyBytesRead);
        }
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new IOException(String.format("Cannot sign data: %s", e.toString()));
        }
    }

    @Override
    public @NonNull Map<String, Object> toHash() throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableMap(new HashMap<String, Object>(){
            {
                this.put("e", BigIntegers.asUnsignedByteArray(RSAOAEPPrivateKey.this.state.keyParameters.getPublicExponent()));
                this.put("p", BigIntegers.asUnsignedByteArray(RSAOAEPPrivateKey.this.state.keyParameters.getP()));
                this.put("q", BigIntegers.asUnsignedByteArray(RSAOAEPPrivateKey.this.state.keyParameters.getQ()));
                if (!RSAOAEPPrivateKey.this.state.mgf1HashType.equals((Object)DEFAULT_MGF1_HASH)) {
                    this.put("mgf1Hash", RSAOAEPPrivateKey.this.state.mgf1HashType.getAlgorithmName());
                }
            }
        });
    }

    @Override
    public void updateFromHash(Map<String, Object> hash) throws Hashable.Error {
        if (hash == null) {
            throw new Hashable.Error("hash is null");
        }
        try {
            byte[] e = (byte[])hash.get("e");
            if (e == null) {
                throw new Hashable.Error("e is not available");
            }
            byte[] p = (byte[])hash.get("p");
            if (p == null) {
                throw new Hashable.Error("p is not available");
            }
            byte[] q = (byte[])hash.get("q");
            if (q == null) {
                throw new Hashable.Error("q is not available");
            }
            String mgf1HashName = (String)hash.getOrDefault("mgf1Hash", DEFAULT_MGF1_HASH.getAlgorithmName());
            HashType mgf1HashType = HashType.getByAlgorithmName(mgf1HashName);
            if (mgf1HashType == null) {
                throw new Hashable.Error(String.format("MGF1 Hash %s is not available", mgf1HashName));
            }
            SecureRandom rng = this.state == null ? new SecureRandom() : this.state.rng;
            this.init(e, p, q, DEFAULT_OAEP_HASH, mgf1HashType, rng);
        }
        catch (Exception e) {
            this.state = null;
            throw new Hashable.Error(String.format("Incorrect data for private key: %s", e.toString()));
        }
    }

    @Override
    public byte[] pack() {
        @NonNull Map<String, Object> params = this.toHash();
        return Boss.dumpToArray(new Object[]{0, params.get("e"), params.get("p"), params.get("q")}, new Object[0]);
    }

    int getMaxBlockSize() {
        int keySize = this.getBitStrength();
        int digestSize = this.state.oaepHashType.makeDigest().getDigestSize();
        int maxBlockSize = keySize / 8 - 2 - 2 * digestSize;
        return maxBlockSize;
    }

    class State {
        final @NonNull AsymmetricBlockCipher decryptor;
        final @NonNull RSAPrivateCrtKeyParameters keyParameters;
        final @NonNull RSAOAEPPublicKey publicKey;
        final @NonNull HashType oaepHashType;
        final @NonNull HashType mgf1HashType;
        final @NonNull SecureRandom rng;

        State(AsymmetricBlockCipher decryptor, RSAPrivateCrtKeyParameters keyParameters, RSAOAEPPublicKey publicKey, HashType oaepHashType, HashType mgf1HashType, SecureRandom rng) {
            this.decryptor = decryptor;
            this.keyParameters = keyParameters;
            this.publicKey = publicKey;
            this.oaepHashType = oaepHashType;
            this.mgf1HashType = mgf1HashType;
            this.rng = rng;
        }
    }
}

