/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto.rsaoaep;

import com.icodici.crypto.AbstractPublicKey;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.rsaoaep.RSAEngineFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sergeych.tools.Hashable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.encodings.OAEPEncoding;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.crypto.params.RSAKeyParameters;
import org.spongycastle.crypto.signers.PSSSigner;
import org.spongycastle.util.BigIntegers;

public class RSAOAEPPublicKey
extends AbstractPublicKey {
    public static final HashType DEFAULT_OAEP_HASH = HashType.SHA1;
    public static final HashType DEFAULT_MGF1_HASH = HashType.SHA1;
    @Nullable State state;

    public RSAOAEPPublicKey() {
    }

    @Override
    public String toString() {
        return String.format("RSAOAEPPublicKey#%s", System.identityHashCode(this));
    }

    RSAOAEPPublicKey(byte[] n, byte[] e, HashType oaepHashType, HashType mgf1HashType, SecureRandom rng) {
        this.init(n, e, oaepHashType, mgf1HashType, rng);
    }

    void init(byte[] n, byte[] e, HashType oaepHashType, HashType mgf1HashType, SecureRandom rng) {
        RSAKeyParameters pubParameters = new RSAKeyParameters(false, BigIntegers.fromUnsignedByteArray(n), BigIntegers.fromUnsignedByteArray(e));
        this.state = new State(this.makeEncryptor(mgf1HashType), pubParameters, oaepHashType, mgf1HashType, rng);
        this.resetEncryptor();
    }

    private AsymmetricBlockCipher makeEncryptor(HashType mgf1HashType) {
        SHA1Digest dummyDigest = new SHA1Digest();
        return new OAEPEncoding(RSAEngineFactory.make(), dummyDigest, mgf1HashType.makeDigest(), new byte[0]);
    }

    void resetEncryptor() {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        this.state.encryptor.init(true, new ParametersWithRandom(this.state.keyParameters, this.state.rng));
    }

    @Override
    public boolean canEncrypt() {
        return this.isInitialized();
    }

    @Override
    public int getBitStrength() throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        return this.state.keyParameters.getModulus().bitLength();
    }

    @Override
    public boolean isInitialized() {
        return this.state != null;
    }

    @Override
    public @NonNull byte[] encrypt(byte[] plaintext) throws EncryptionError, IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        try {
            return this.state.encryptor.processBlock(plaintext, 0, plaintext.length);
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionError(String.format("Cannot encode: %s", e.toString()));
        }
    }

    @Override
    public @NonNull boolean checkSignature(InputStream input, byte[] signature, HashType hashType, int saltLength) throws IllegalStateException, IOException {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        Digest primaryDigest = hashType.makeDigest();
        if (saltLength == MAX_SALT_LENGTH) {
            saltLength = RSAOAEPPublicKey.getMaxSaltLength(this.getBitStrength(), primaryDigest.getDigestSize());
        }
        if (saltLength < 0) {
            throw new RuntimeException(String.format("Incorrect salt length %s", saltLength));
        }
        PSSSigner signatureChecker = new PSSSigner((AsymmetricBlockCipher)RSAEngineFactory.make(), primaryDigest, this.state.mgf1HashType.makeDigest(), saltLength);
        signatureChecker.init(false, new ParametersWithRandom(this.state.keyParameters, this.state.rng));
        boolean done = false;
        while (!done) {
            int availableBytes = input.available();
            if (availableBytes <= 0) {
                done = true;
                continue;
            }
            byte[] buffer = new byte[availableBytes];
            int howManyBytesRead = input.read(buffer);
            if (howManyBytesRead <= 0) {
                done = true;
                continue;
            }
            signatureChecker.update(buffer, 0, howManyBytesRead);
        }
        return signatureChecker.verifySignature(signature);
    }

    @Override
    public @NonNull String algorithmTag() {
        return "r1";
    }

    @Override
    public @NonNull Map<String, Object> toHash() throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableMap(new HashMap<String, Object>(){
            {
                this.put("n", BigIntegers.asUnsignedByteArray(RSAOAEPPublicKey.this.state.keyParameters.getModulus()));
                this.put("e", BigIntegers.asUnsignedByteArray(RSAOAEPPublicKey.this.state.keyParameters.getExponent()));
                if (!RSAOAEPPublicKey.this.state.mgf1HashType.equals((Object)DEFAULT_MGF1_HASH)) {
                    this.put("mgf1Hash", RSAOAEPPublicKey.this.state.mgf1HashType.getAlgorithmName());
                }
            }
        });
    }

    @Override
    public void updateFromHash(Map<String, Object> hash) throws Hashable.Error {
        if (hash == null) {
            throw new Hashable.Error("hash is null");
        }
        try {
            byte[] n = (byte[])hash.get("n");
            if (n == null) {
                throw new Hashable.Error("n is not available");
            }
            byte[] e = (byte[])hash.get("e");
            if (e == null) {
                throw new Hashable.Error("e is not available");
            }
            String mgf1HashName = (String)hash.getOrDefault("mgf1Hash", DEFAULT_MGF1_HASH.getAlgorithmName());
            HashType mgf1HashType = HashType.getByAlgorithmName(mgf1HashName);
            if (mgf1HashType == null) {
                throw new Hashable.Error(String.format("MGF1 Hash %s is not available", mgf1HashName));
            }
            SecureRandom rng = this.state == null ? new SecureRandom() : this.state.rng;
            this.init(n, e, DEFAULT_OAEP_HASH, mgf1HashType, rng);
        }
        catch (Exception e) {
            this.state = null;
            throw new Hashable.Error(String.format("Incorrect data for public key: %s", e.toString()));
        }
    }

    class State {
        final @NonNull AsymmetricBlockCipher encryptor;
        final @NonNull RSAKeyParameters keyParameters;
        final @NonNull HashType oaepHashType;
        final @NonNull HashType mgf1HashType;
        final @NonNull SecureRandom rng;

        State(AsymmetricBlockCipher encryptor, RSAKeyParameters keyParameters, HashType oaepHashType, HashType mgf1HashType, SecureRandom rng) {
            this.encryptor = encryptor;
            this.keyParameters = keyParameters;
            this.oaepHashType = oaepHashType;
            this.mgf1HashType = mgf1HashType;
            this.rng = rng;
        }
    }
}

