/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.crypto.rsaoaep;

import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.rsaoaep.RSAOAEPPrivateKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import net.sergeych.boss.Boss;
import net.sergeych.utils.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UnikeyFactory {
    static @Nullable RSAOAEPPrivateKey rsaOaepPKFromUnikey(@NonNull byte[] bytes) {
        assert (bytes != null);
        try {
            ArrayList unpackedFromBoss = (ArrayList)Boss.load(bytes);
            assert ((Integer)unpackedFromBoss.get(0) == 0);
            byte[] e = ((Bytes)unpackedFromBoss.get(1)).toArray();
            byte[] p = ((Bytes)unpackedFromBoss.get(2)).toArray();
            byte[] q = ((Bytes)unpackedFromBoss.get(3)).toArray();
            return new RSAOAEPPrivateKey(e, p, q, RSAOAEPPrivateKey.DEFAULT_OAEP_HASH, RSAOAEPPrivateKey.DEFAULT_MGF1_HASH, new SecureRandom());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static @Nullable PrivateKey fromUnikey(@NonNull byte[] bytes) {
        assert (bytes != null);
        try {
            return new PrivateKey(bytes);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static @NonNull byte[] toUnikey(@NonNull RSAOAEPPrivateKey privateKey) {
        assert (privateKey != null);
        return privateKey.pack();
    }

    public static @NonNull byte[] toUnikey(@NonNull PrivateKey privateKey) {
        assert (privateKey != null);
        return privateKey.pack();
    }
}

