/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import net.sergeych.utils.LogPrinter;

public class Db
implements Cloneable,
AutoCloseable {
    private boolean walMode = false;
    private boolean sqlite = false;
    protected String connectionString;
    private int currentDbVersion = 0;
    private boolean isInTransaction = false;
    private Connection connection;
    protected Properties properties = null;
    private static LogPrinter log = new LogPrinter("Db");
    private int myVersion = 0;
    private HashMap<String, PreparedStatement> cachedStatements = new HashMap();
    private Object writeLock = new Object();

    public Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String string = this.connectionString;
        synchronized (string) {
            if (this.connection != null) {
                for (PreparedStatement s : this.cachedStatements.values()) {
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                }
                this.cachedStatements.clear();
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    log.e("Error closing: " + e, new Object[0]);
                    e.printStackTrace();
                }
                this.connection = null;
            }
        }
    }

    public boolean isClosed() {
        return this.connection == null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public Integer getIntParam(String name) throws SQLException {
        return (Integer)this.queryOne("SELECT ivalue FROM vars WHERE name=?", name);
    }

    public String getStringParam(String name) throws SQLException {
        return (String)this.queryOne("SELECT svalue FROM vars WHERE name=?", name);
    }

    public int getIntParam(String name, int defaultValue) throws SQLException {
        Integer x = this.getIntParam(name);
        return x == null ? defaultValue : x;
    }

    public void setIntParam(String name, int value) throws SQLException {
        this.update("UPDATE vars SET ivalue=? WHERE name=?", value, name);
        this.update("INSERT OR IGNORE INTO vars (name, ivalue) VALUES (?, ?); ", name, value);
    }

    public String getStringParam(String name, String defaultValue) throws SQLException {
        String result = this.getStringParam(name);
        return result == null ? defaultValue : result;
    }

    public void setStringParam(String name, String value) throws SQLException {
        this.update("UPDATE vars SET svalue=? WHERE name=?", value, name);
        this.update("INSERT OR IGNORE INTO vars (name, svalue) VALUES (?, ?); ", name, value);
    }

    public Db(String connectionString) throws SQLException {
        this(connectionString, null);
    }

    public Db(String connectionString, Properties properties) throws SQLException {
        this(connectionString, properties, null);
    }

    public Db(String connectionString, Properties properties, String migrationsResource) throws SQLException {
        this.connectionString = connectionString;
        this.connection = properties != null ? DriverManager.getConnection(connectionString, properties) : DriverManager.getConnection(connectionString);
        this.properties = properties;
        this.walMode = true;
        this.connection.setAutoCommit(true);
        if (connectionString.contains("sqlite")) {
            this.sqlite = true;
            this.queryOne("PRAGMA journal_mode=WAL", new Object[0]);
            this.update("PRAGMA synchronous=OFF", new Object[0]);
            try {
                this.update("PRAGMA mmap_size=268435456", new Object[0]);
            }
            catch (SQLException e) {
                this.queryOne("PRAGMA mmap_size=268435456", new Object[0]);
            }
        }
        if (migrationsResource != null) {
            this.setupDatabase(migrationsResource);
        }
    }

    public Db clone() {
        try {
            return new Db(this.connectionString, this.properties);
        }
        catch (SQLException e) {
            throw new RuntimeException("failed to clone Db", e);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Db && this.connectionString.equals(((Db)obj).connectionString);
    }

    public int hashCode() {
        return this.connectionString.hashCode();
    }

    public void clearDB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T transaction(Callable<T> worker) throws Exception {
        Connection connection = this.connection;
        synchronized (connection) {
            this.connection.setAutoCommit(false);
            this.isInTransaction = true;
            try {
                T result = worker.call();
                this.connection.commit();
                T t = result;
                return t;
            }
            catch (RollbackException e) {
                e.printStackTrace();
                this.connection.rollback();
            }
            catch (Exception e) {
                log.e("Exception in transaction: %s", e);
                e.printStackTrace();
                this.connection.rollback();
                throw e;
            }
            finally {
                this.connection.setAutoCommit(true);
                this.isInTransaction = false;
            }
            return null;
        }
    }

    private void preMigrate(int version) {
    }

    private void postMigrate(int version) {
    }

    public void createDB(String migrationResource) {
        if (migrationResource == null) {
            return;
        }
        try {
            block8: {
                this.myVersion = 0;
                try {
                    Integer v = (Integer)this.queryOne("SELECT ivalue FROM vars WHERE name = 'version'", new Object[0]);
                    if (v != null) {
                        this.myVersion = v;
                    }
                }
                catch (SQLException e) {
                    if (e.getMessage().indexOf("vars") >= 0) break block8;
                    e.printStackTrace();
                }
            }
            this.currentDbVersion = this.detectMaxMigrationVersion(migrationResource);
            log.d("My db version is %d current is %d", this.myVersion, this.currentDbVersion);
            while (this.myVersion < this.currentDbVersion) {
                this.transaction(() -> {
                    log.d("Migrating to %d", this.myVersion + 1);
                    this.preMigrate(this.myVersion);
                    this.executeFile(migrationResource + this.myVersion + ".sql");
                    this.postMigrate(this.myVersion);
                    ++this.myVersion;
                    this.update("update vars set ivalue=? where name='version'", this.myVersion);
                    return null;
                });
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("migrations failed", e);
        }
        log.d("Db migrated successfully");
    }

    private int detectMaxMigrationVersion(String migrationResource) {
        InputStream is;
        if (migrationResource == null || migrationResource.length() == 0) {
            return 0;
        }
        int i = 0;
        while ((is = this.getClass().getResourceAsStream(migrationResource + i + ".sql")) != null) {
            ++i;
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return i;
    }

    public void setupDatabase(String migrationsResource) {
        this.createDB(migrationsResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement statement(String sqlText, Object ... args) throws SQLException {
        PreparedStatement statement = null;
        Connection connection = this.connection;
        synchronized (connection) {
            statement = this.connection.prepareStatement(sqlText);
        }
        int index = 1;
        for (Object arg : args) {
            statement.setObject(index, arg);
            ++index;
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement statementReturningKeys(String sqlText, Object ... args) throws SQLException {
        PreparedStatement statement = null;
        Connection connection = this.connection;
        synchronized (connection) {
            statement = this.connection.prepareStatement(sqlText, 1);
        }
        int index = 1;
        for (Object arg : args) {
            statement.setObject(index, arg);
            ++index;
        }
        return statement;
    }

    public ResultSet queryRow(String sqlText, Object ... args) throws SQLException {
        PreparedStatement s = this.statement(sqlText, args);
        s.closeOnCompletion();
        ResultSet rs = s.executeQuery();
        if (rs.next()) {
            return rs;
        }
        if (this.sqlite) {
            s.close();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T queryOne(String sqlText, Object ... args) throws SQLException {
        try (PreparedStatement s = this.statement(sqlText, args);
             ResultSet rs = s.executeQuery();){
            if (!rs.next()) return null;
            Object object = rs.getObject(1);
            return (T)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(String sqlText, Object ... args) throws SQLException {
        try (PreparedStatement s = this.statement(sqlText, args);){
            s.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void updateWithStatement(PreparedStatement statement) throws SQLException {
        try {
            statement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void executeFile(String name) {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        try {
            try (Statement statement = this.connection.createStatement();){
                String line;
                InputStream resourceStream = this.getClass().getResourceAsStream(name);
                if (resourceStream == null) {
                    throw new RuntimeException("failed to get migration: " + name);
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(resourceStream));
                boolean inFunction = false;
                while ((line = r.readLine()) != null) {
                    ++counter;
                    line = line.trim();
                    sb.append(line + "\n");
                    if (!inFunction) {
                        if (line.endsWith("$$")) {
                            inFunction = true;
                            continue;
                        }
                        if (!line.endsWith(";")) continue;
                        statement.executeUpdate(sb.toString());
                        sb = new StringBuilder();
                        counter = 0;
                        continue;
                    }
                    if (!line.endsWith("$$")) continue;
                    inFunction = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.e("Eror executing file: " + e + "\nIn line " + counter + " of:\n" + sb.toString(), new Object[0]);
            throw new RuntimeException("Failed to migrate", e);
        }
    }

    public static class RollbackException
    extends Exception {
    }

    public class Error
    extends Exception {
        public Error(String text) {
            super(text);
        }

        public Error(String text, Throwable reason) {
            super(text, reason);
        }
    }
}

