/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.db;

import com.icodici.db.PooledDb;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;

public class DbPool
implements AutoCloseable {
    private final String connectionString;
    private final Properties properties;
    private final int maximumConnections;
    private volatile int total = 0;
    private ThreadLocal<PooledDb> threadDb = new ThreadLocal();
    private LinkedBlockingQueue<PooledDb> pool = new LinkedBlockingQueue();

    @Override
    public void close() throws Exception {
        this.threadDb.set(null);
        while (!this.pool.isEmpty()) {
            this.pool.take().destroy();
        }
    }

    public DbPool(String connectionString, Properties properties, int maxConnections) throws SQLException {
        this.connectionString = connectionString;
        this.properties = properties;
        this.maximumConnections = maxConnections;
    }

    public PooledDb db() throws SQLException {
        try {
            PooledDb pdb;
            PooledDb db = this.threadDb.get();
            if (db != null) {
                return db;
            }
            PooledDb pooledDb = pdb = this.total >= this.maximumConnections ? this.pool.take() : this.pool.poll();
            if (pdb == null) {
                pdb = new PooledDb(this, this.connectionString, this.properties);
                ++this.total;
            }
            this.threadDb.set(pdb);
            return pdb;
        }
        catch (InterruptedException e) {
            throw new SQLException("Pooled operation interrupted");
        }
    }

    void returnToPool(PooledDb db) {
        this.threadDb.set(null);
        this.pool.add(db);
    }

    public <T> T execute(DbConsumer<T> consumer) throws Exception {
        try (PooledDb pdb = this.db();){
            T t = consumer.accept(pdb);
            return t;
        }
    }

    public void execute(VoidDbConsumer consumer) throws Exception {
        try (PooledDb pdb = this.db();){
            consumer.accept(pdb);
        }
    }

    public static interface VoidDbConsumer {
        public void accept(PooledDb var1) throws Exception;
    }

    public static interface DbConsumer<R> {
        public R accept(PooledDb var1) throws Exception;
    }
}

