/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.db;

import com.icodici.db.Db;
import com.icodici.db.DbPool;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Callable;

public class PooledDb
extends Db
implements AutoCloseable {
    private final DbPool dbPool;
    volatile boolean isInTransaction = false;
    private static final boolean assertionsEnabled;

    public PooledDb(DbPool dbPool, String connectionString, Properties properties) throws SQLException {
        super(connectionString, properties);
        this.dbPool = dbPool;
    }

    @Override
    public <T> T transaction(Callable<T> worker) throws Exception {
        try {
            T result;
            if (assertionsEnabled) {
                this.isInTransaction = true;
            }
            T t = result = super.transaction(worker);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (assertionsEnabled) {
                this.isInTransaction = false;
            }
        }
    }

    @Override
    public void close() {
        this.dbPool.returnToPool(this);
    }

    public void destroy() {
        super.close();
    }

    static {
        boolean assertionsEnabledTmp = false;
        if (!$assertionsDisabled) {
            assertionsEnabledTmp = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        assertionsEnabled = assertionsEnabledTmp;
    }
}

