/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class Decimal
extends Number
implements Comparable<Number> {
    public static final int SCALE = 9;
    private static final RoundingMode ROUNDING = RoundingMode.HALF_UP;
    public static final Decimal ZERO = new Decimal(0L);
    public static final Decimal ONE = new Decimal(1L);
    public static final Decimal TWO = new Decimal(2L);
    private final BigDecimal value;

    public Decimal() {
        this.value = BigDecimal.ZERO;
    }

    public Decimal(String stringValue) {
        this.value = new BigDecimal(stringValue);
    }

    public Decimal(long longValue) {
        this.value = new BigDecimal(longValue);
    }

    public Decimal(BigDecimal bigDecimalValue) {
        this.value = bigDecimalValue;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public Decimal divide(BigDecimal divisor) {
        return new Decimal(this.value.divide(divisor, 9, ROUNDING));
    }

    public Decimal divide(Decimal divisor) {
        return new Decimal(this.value.divide(divisor.value, 9, ROUNDING));
    }

    public Decimal getIntegral() {
        return new Decimal(this.value.divideToIntegralValue(BigDecimal.ONE));
    }

    public Decimal getFraction() {
        return new Decimal(this.value.remainder(BigDecimal.ONE));
    }

    public Decimal add(Decimal augend) {
        return new Decimal(this.value.add(augend.value));
    }

    public Decimal subtract(Decimal subtrahend) {
        return new Decimal(this.value.subtract(subtrahend.value));
    }

    public Decimal multiply(Decimal muliplicand) {
        return new Decimal(this.value.multiply(muliplicand.value));
    }

    public Decimal remainder(Decimal divisor) {
        return new Decimal(this.value.remainder(divisor.value));
    }

    public Decimal add(BigDecimal augend) {
        return new Decimal(this.value.add(augend));
    }

    public Decimal subtract(BigDecimal subtrahend) {
        return new Decimal(this.value.subtract(subtrahend));
    }

    public Decimal multiply(BigDecimal muliplicand) {
        return new Decimal(this.value.multiply(muliplicand));
    }

    public Decimal remainder(BigDecimal divisor) {
        return new Decimal(this.value.remainder(divisor));
    }

    public Decimal[] divideAndRemainder(BigDecimal divisor) {
        BigDecimal[] result = this.value.divideAndRemainder(divisor);
        return new Decimal[]{new Decimal(result[0]), new Decimal(result[1])};
    }

    public Decimal[] divideAndRemainder(Decimal divisor) {
        BigDecimal[] result = this.value.divideAndRemainder(divisor.value);
        return new Decimal[]{new Decimal(result[0]), new Decimal(result[1])};
    }

    public Decimal abs() {
        return new Decimal(this.value.abs());
    }

    public Decimal negate() {
        return new Decimal(this.value.negate());
    }

    public int signum() {
        return this.value.signum();
    }

    @Override
    public int compareTo(Number val) {
        if (val instanceof Decimal) {
            return this.value.compareTo(((Decimal)val).value);
        }
        if (val instanceof BigDecimal) {
            return this.value.compareTo((BigDecimal)val);
        }
        return this.value.compareTo(BigDecimal.valueOf(val.doubleValue()));
    }

    public boolean equals(Object x) {
        if (x instanceof BigDecimal) {
            return this.value.compareTo((BigDecimal)x) == 0;
        }
        if (x instanceof Decimal) {
            return this.value.compareTo(((Decimal)x).value) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public String toEngineeringString() {
        return this.value.toEngineeringString();
    }

    public String toPlainString() {
        return this.value.toPlainString();
    }

    public BigInteger toBigInteger() {
        return this.value.toBigInteger();
    }

    public Decimal ulp() {
        return new Decimal(this.value.ulp());
    }
}

