/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa;

import com.icodici.universa.Errors;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;

public class ErrorRecord {
    private String objectName;
    private String message;
    private Errors error;

    public ErrorRecord(Errors error, String objectName, String message) {
        this.objectName = objectName;
        this.message = message;
        this.error = error;
    }

    public ErrorRecord(Binder binder) {
        this(Errors.valueOf(binder.getStringOrThrow("error")), binder.getStringOrThrow("object"), binder.getString("message", ""));
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getMessage() {
        return this.message;
    }

    public Errors getError() {
        return this.error;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.error.name());
        if (this.objectName != null && !this.objectName.isEmpty()) {
            sb.append(" [" + this.objectName + "]");
        }
        if (this.message != null && !this.message.isEmpty()) {
            sb.append(" " + this.message);
        }
        return sb.toString();
    }

    static {
        DefaultBiMapper.registerAdapter(ErrorRecord.class, new BiAdapter(){

            public Binder serialize(Object object, BiSerializer serializer) {
                ErrorRecord er = (ErrorRecord)object;
                return Binder.fromKeysValues("error", er.error.name(), "object", er.objectName, "message", er.message);
            }

            public Object deserialize(Binder binder, BiDeserializer deserializer) {
                return new ErrorRecord(Errors.valueOf(binder.getStringOrThrow("error")), binder.getStringOrThrow("object"), binder.getString("message", ""));
            }

            @Override
            public String typeName() {
                return "error";
            }
        });
    }
}

