/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa;

import com.icodici.crypto.digest.Digest;
import com.icodici.crypto.digest.Gost3411_2012_256;
import com.icodici.crypto.digest.Sha3_256;
import com.icodici.crypto.digest.Sha512_256;
import java.util.Arrays;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.utils.Base64u;

public class HashId
implements Comparable<HashId> {
    protected byte[] digest;

    public HashId(byte[] packedData) {
        this.initWith(packedData);
    }

    private HashId() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof HashId) {
            return Arrays.equals(this.digest, ((HashId)obj).digest);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.digest);
    }

    public void initWith(byte[] packedData) {
        if (this.digest != null) {
            throw new IllegalStateException("HashId is already initialized");
        }
        this.digest = new CompositeDigest().digest(packedData);
    }

    public byte[] getDigest() {
        return this.digest;
    }

    @Override
    public int compareTo(HashId other) {
        if (this.digest.length != other.digest.length) {
            throw new IllegalStateException("different digest size");
        }
        for (int i = 0; i < this.digest.length; ++i) {
            int my = this.digest[i] & 0xFF;
            int his = other.digest[i] & 0xFF;
            if (my < his) {
                return -1;
            }
            if (my <= his) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.digest == null ? "null" : Base64u.encodeCompactString(this.digest).substring(0, 8) + "\u2026";
    }

    public static HashId createRandom() {
        return HashId.withDigest(Do.randomBytes(64));
    }

    public static HashId withDigest(byte[] hash) {
        HashId id = new HashId();
        id.digest = hash;
        return id;
    }

    public String toBase64String() {
        assert (this.digest != null);
        return Base64u.encodeCompactString(this.digest);
    }

    public static HashId of(byte[] data) {
        return new HashId(data);
    }

    public static HashId withDigest(String encodedString) {
        return HashId.withDigest(Base64u.decodeCompactString(encodedString));
    }

    static {
        DefaultBiMapper.registerAdapter(HashId.class, new BiAdapter(){

            public Binder serialize(Object object, BiSerializer serializer) {
                return Binder.fromKeysValues("composite3", ((HashId)object).getDigest());
            }

            public Object deserialize(Binder binder, BiDeserializer deserializer) {
                return HashId.withDigest(binder.getBinaryOrThrow("composite3"));
            }

            @Override
            public String typeName() {
                return "HashId";
            }
        });
    }

    public static class CompositeDigest
    extends Digest {
        private Sha512_256 sha2Digest = new Sha512_256();
        private Sha3_256 sha3Digest = new Sha3_256();
        private Gost3411_2012_256 gostDigest = new Gost3411_2012_256();

        @Override
        protected void _update(byte[] data, int offset, int size) {
            this.sha2Digest.update(data, offset, size);
            this.sha3Digest.update(data, offset, size);
            this.gostDigest.update(data, offset, size);
        }

        @Override
        protected byte[] _digest() {
            int length = this.getLength();
            byte[] data = new byte[this.getLength()];
            int pos = 0;
            byte[] d = this.sha2Digest.digest();
            System.arraycopy(d, 0, data, pos, d.length);
            pos += d.length;
            d = this.sha3Digest.digest();
            System.arraycopy(d, 0, data, pos, d.length);
            pos += d.length;
            d = this.gostDigest.digest();
            System.arraycopy(d, 0, data, pos, d.length);
            return data;
        }

        @Override
        public int getLength() {
            return this.sha2Digest.getLength() + this.sha3Digest.getLength() + this.gostDigest.getLength();
        }
    }
}

