/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.icodici.crypto.KeyAddress;
import com.icodici.crypto.KeyInfo;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.SymmetricKey;
import com.icodici.universa.Approvable;
import com.icodici.universa.Decimal;
import com.icodici.universa.ErrorRecord;
import com.icodici.universa.Errors;
import com.icodici.universa.HashId;
import com.icodici.universa.client.ClientNetwork;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.ContractsService;
import com.icodici.universa.contract.Parcel;
import com.icodici.universa.contract.TransactionPack;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.roles.Role;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node2.Quantiser;
import com.icodici.universa.node2.network.BasicHttpClientSession;
import com.icodici.universa.wallet.Wallet;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.boss.Boss;
import net.sergeych.collections.Multimap;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.tools.Reporter;
import net.sergeych.utils.Base64;
import org.yaml.snakeyaml.Yaml;

public class CLIMain {
    private static final String CLI_VERSION = "3.4.2-private-alpha";
    private static OptionParser parser;
    private static OptionSet options;
    private static boolean testMode;
    private static String testRootPath;
    private static String nodeUrl;
    private static Reporter reporter;
    private static ClientNetwork clientNetwork;
    private static List<String> keyFileNames;
    private static Map<String, PrivateKey> keyFiles;
    public static final String AMOUNT_FIELD_NAME = "amount";
    private static PrivateKey privateKey;
    private static BasicHttpClientSession session;
    private static Preferences prefs;

    public static void main(String[] args) throws IOException {
        reporter.clear();
        keyFiles = null;
        parser = new OptionParser(){
            {
                this.acceptsAll(Arrays.asList("?", "h", "help"), "Show help.").forHelp();
                this.acceptsAll(Arrays.asList("g", "generate"), "Generate new key pair and store in a files starting with a given prefix.").withRequiredArg().ofType(String.class).describedAs("name_prefix");
                this.accepts("s", "With -g, specify key strength.").withRequiredArg().ofType(Integer.class).defaultsTo(2048, (Integer[])new Integer[0]);
                this.acceptsAll(Arrays.asList("c", "create"), "Create smart contract from dsl template.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file.yml");
                this.accepts("wait", "with --register,  wait for network consensus up to specified number of milliseconds.").withOptionalArg().ofType(Integer.class).defaultsTo(5000, (Integer[])new Integer[0]).describedAs("milliseconds");
                this.acceptsAll(Arrays.asList("j", "json"), "Return result in json format.");
                this.acceptsAll(Arrays.asList("v", "verbose"), "Provide more detailed information.");
                this.acceptsAll(Arrays.asList("network"), "Check network status.");
                this.accepts("register", "register a specified contract, must be a sealed binary file").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("contract.unicon");
                this.accepts("tu", "Use with -register. Point to file with your transaction units. Use it to pay for contract's register.").withRequiredArg().ofType(String.class).describedAs("tu.unicon");
                this.accepts(CLIMain.AMOUNT_FIELD_NAME, "Use with -register and -tu. Command is set amount of transaction units will be pay for contract's register.").withRequiredArg().ofType(Integer.class).defaultsTo(1, (Integer[])new Integer[0]).describedAs("tu amount");
                this.accepts("tutest", "Use with -register and -tu. Key is point to use test transaction units.");
                this.accepts("probe", "query the state of the document in the Universa network").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("base64_id");
                this.acceptsAll(Arrays.asList("k", "keys"), "List of comma-separated private key files touse to sign contract with, if appropriated.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",").describedAs("key_file");
                this.acceptsAll(Arrays.asList("fingerprints"), "Print fingerprints of keys specified with -k.");
                this.acceptsAll(Arrays.asList("e", "export"), "Export specified contract. Default export format is JSON. Use '-as' option with values 'json', 'xml' or 'yaml' for export as specified format.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file");
                this.accepts("as", "Use with -e, --export command. Specify format for export contract. Possible values are 'json', 'xml' or 'yaml'.").withRequiredArg().ofType(String.class).describedAs("format");
                this.acceptsAll(Arrays.asList("i", "import"), "Import contract from specified xml, json or yaml file.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file");
                this.acceptsAll(Arrays.asList("name", "o"), "Use with -e, --export or -i, --import commands. Specify name of destination file.").withRequiredArg().ofType(String.class).describedAs("filename");
                this.accepts("extract-key", "Use with -e, --export command. Extracts any public key(s) from specified role into external file.").withRequiredArg().ofType(String.class).describedAs("role");
                this.accepts("base64", "with --extract-key keys to the text base64 format");
                this.accepts("get", "Use with -e, --export command. Extracts any field of the contract into external file.").withRequiredArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("field_name");
                this.accepts("set", "Use with -e, --export command. Specify field of the contract for update. Use -value option to specify value for the field").withRequiredArg().ofType(String.class).describedAs("field_name");
                this.accepts("value", "Use with -e, --export command and after -set argument. Update specified with -set argument field of the contract.").withRequiredArg().ofType(String.class).describedAs("field_value");
                this.acceptsAll(Arrays.asList("f", "find"), "Search all contracts in the specified path including subpaths. Use -r key to check all contracts in the path recursively.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("path");
                this.acceptsAll(Arrays.asList("d", "download"), "Download contract from the specified url.").withRequiredArg().ofType(String.class).describedAs("url");
                this.acceptsAll(Arrays.asList("ch", "check"), "Check contract for validness. Use -r key to check all contracts in the path recursively.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file/path");
                this.accepts("r", "Use with --ch, --check or -f, --find commands. Specify to check contracts in the path and do it recursively.");
                this.accepts("term-width").withRequiredArg().ofType(Integer.class).defaultsTo(80, (Integer[])new Integer[0]);
                this.accepts("pretty", "Use with -as json option. Make json string pretty.");
                this.acceptsAll(Arrays.asList("revoke"), "Revoke specified contract and create a revocation transactional contract. Use -k option to specify private key for revoke contract, key should be same as key you signed contract for revoke with. You cannot revoke contract without pointing private key.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file.unicon");
                this.acceptsAll(Arrays.asList("pack-with"), "Pack contract with counterparts (new, revoking). Use -add-sibling option to add sibling and -add-revoke to add revoke item.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file.unicon");
                this.accepts("add-sibling", "Use with --pack-with command. Option add sibling item for packing contract.").withRequiredArg().ofType(String.class).describedAs("sibling.unicon");
                this.accepts("add-revoke", "Use with --pack-with command. Option add revoke item for packing contract.").withRequiredArg().ofType(String.class).describedAs("file.unicon");
                this.acceptsAll(Arrays.asList("unpack"), "Extracts revoking and new items from contracts and save them.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file.unicon");
                this.acceptsAll(Arrays.asList("cost"), "Print cost of operations for contracts with given files of contracts. Can be used as key with -register command.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file");
                this.accepts("anonymize", "Key erase public key from given contract for role given with -role key and replace it with anonymous id for that public key. If -role key is missed will anonymize all roles. After anonymizing contract will be saved as <file_name>_anonymized.unicon. If you want to save with custom name use -name keys.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("file");
                this.accepts("role", "Use with -anonymize. Set the role name for anonymizing.").withOptionalArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("role_name");
                this.accepts("address", "Generate address from key. Path to key define in parameter -address. For generate short address use parameter -short.").withRequiredArg().ofType(String.class).describedAs("file");
                this.accepts("short", "Generate short addres.");
                this.accepts("address-match", "Matching address with key from file. Address define in parameter -address-match.Path to key define in parameter -keyfile.").withRequiredArg().ofType(String.class).describedAs("file");
                this.accepts("keyfile", "Path to key for matching with address.").withRequiredArg().ofType(String.class).describedAs("file");
                this.accepts("folder-match", "Associates the entered address with the key file in the specified directory. Path to directory define in parameter -folder-match. Address define in parameter -addr.").withRequiredArg().ofType(String.class).describedAs("file");
                this.accepts("addr", "Address for finding key in folder.").withRequiredArg().ofType(String.class).describedAs("address");
            }
        };
        try {
            options = parser.parse(args);
            if (options.has("?")) {
                CLIMain.usage(null);
            }
            if (options.has("v")) {
                CLIMain.setVerboseMode(true);
            } else {
                CLIMain.setVerboseMode(false);
            }
            if (options.has("k")) {
                keyFileNames = options.valuesOf("k");
            } else {
                keyFileNames = new ArrayList<String>();
                keyFiles = null;
            }
            if (options.has("fingerprints")) {
                CLIMain.printFingerprints();
                CLIMain.finish();
            }
            if (options.has("j")) {
                reporter.setQuiet(true);
            } else {
                reporter.setQuiet(false);
            }
            if (options.has("network")) {
                ClientNetwork n = CLIMain.getClientNetwork();
                int total = n.size();
                n.checkNetworkState(reporter);
                CLIMain.finish();
            }
            if (options.has("register")) {
                CLIMain.doRegister();
            }
            if (options.has("probe")) {
                CLIMain.doProbe();
            }
            if (options.has("g")) {
                CLIMain.doGenerateKeyPair();
                return;
            }
            if (options.has("c")) {
                CLIMain.doCreateContract();
            }
            if (options.has("e")) {
                CLIMain.doExport();
            }
            if (options.has("i")) {
                CLIMain.doImport();
            }
            if (options.has("f")) {
                CLIMain.doFindContracts();
            }
            if (options.has("d")) {
                String source = (String)options.valueOf("d");
                CLIMain.downloadContract(source);
                CLIMain.finish();
            }
            if (options.has("ch")) {
                CLIMain.doCheckContracts();
            }
            if (options.has("revoke")) {
                CLIMain.doRevoke();
            }
            if (options.has("pack-with")) {
                CLIMain.doPackWith();
            }
            if (options.has("unpack")) {
                CLIMain.doUnpackWith();
            }
            if (options.has("cost")) {
                CLIMain.doCost();
            }
            if (options.has("anonymize")) {
                CLIMain.doAnonymize();
            }
            if (options.has("address")) {
                CLIMain.doCreateAddress((String)options.valueOf("address"), options.has("short"));
            }
            if (options.has("address-match")) {
                CLIMain.doAddressMatch((String)options.valueOf("address-match"), (String)options.valueOf("keyfile"));
            }
            if (options.has("folder-match")) {
                CLIMain.doSelectKeyInFolder((String)options.valueOf("folder-match"), (String)options.valueOf("addr"));
            }
            CLIMain.usage(null);
        }
        catch (OptionException e) {
            if (options != null) {
                CLIMain.usage("Unrecognized parameter: " + e.getMessage());
            } else {
                CLIMain.usage("No options: " + e.getMessage());
            }
        }
        catch (Finished e) {
            if (reporter.isQuiet()) {
                System.out.println(reporter.reportJson());
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            CLIMain.usage("Error: " + e.getMessage());
            System.exit(100);
        }
    }

    private static String[] unescape(String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = null;
        for (String s : args) {
            System.out.println(s);
            if (sb != null) {
                if (!s.endsWith("\"")) continue;
                sb.append(s.substring(0, s.length() - 1));
                result.add(sb.toString());
                sb = null;
                continue;
            }
            if (s.startsWith("\"")) {
                sb = new StringBuilder(s.substring(1));
                continue;
            }
            result.add(s);
        }
        System.out.println(result);
        return result.toArray(new String[0]);
    }

    private static void doCreateContract() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("c"));
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        List<?> names = options.valuesOf("name");
        List<?> updateFields = options.valuesOf("set");
        List<?> updateValues = options.valuesOf("value");
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            String name = null;
            if (names.size() > s) {
                name = (String)names.get(s);
            }
            HashMap<String, String> updateFieldsHashMap = new HashMap<String, String>();
            Contract contract = Contract.fromDslFile(source);
            try {
                for (int i = 0; i < updateFields.size(); ++i) {
                    updateFieldsHashMap.put((String)updateFields.get(i), (String)updateValues.get(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (updateFieldsHashMap.size() > 0) {
                CLIMain.updateFields(contract, updateFieldsHashMap);
            }
            CLIMain.keysMap().values().forEach(k -> contract.addSignerKey((PrivateKey)k));
            if (name == null) {
                name = source.replaceAll("(?i)\\.(yml|yaml)$", ".unicon");
            }
            contract.seal();
            CLIMain.saveContract(contract, name);
            CLIMain.checkContract(contract);
        }
        CLIMain.finish();
    }

    private static void doExport() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("e"));
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        ArrayList formats = new ArrayList(options.valuesOf("as"));
        List<?> names = options.valuesOf("name");
        List<?> extractKeyRoles = options.valuesOf("extract-key");
        List<String> extractFields = options.valuesOf("get");
        List<?> updateFields = options.valuesOf("set");
        List<?> updateValues = options.valuesOf("value");
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            String name = null;
            String format = "json";
            if (names.size() > s) {
                name = (String)names.get(s);
                String extension = "";
                int i = name.lastIndexOf(46);
                if (i > 0) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                switch (extension) {
                    case "json": 
                    case "xml": 
                    case "yaml": 
                    case "yml": {
                        format = extension;
                    }
                }
            }
            if (formats.size() > s) {
                format = (String)formats.get(s);
            } else if (formats.size() == 1) {
                format = (String)formats.get(0);
            }
            HashMap<String, String> updateFieldsHashMap = new HashMap<String, String>();
            Contract contract = CLIMain.loadContract(source);
            if (contract == null) continue;
            try {
                for (int i = 0; i < updateFields.size(); ++i) {
                    updateFieldsHashMap.put((String)updateFields.get(i), (String)updateValues.get(i));
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            if (updateFieldsHashMap.size() > 0) {
                CLIMain.updateFields(contract, updateFieldsHashMap);
            }
            if (extractKeyRoles != null && extractKeyRoles.size() > 0) {
                for (int i = 0; i < extractKeyRoles.size(); ++i) {
                    String extractKeyRole = (String)extractKeyRoles.get(i);
                    if (name == null) {
                        name = source.replaceAll("(?i)\\.(unicon)$", ".pub");
                    }
                    CLIMain.exportPublicKeys(contract, extractKeyRole, name, options.has("base64"));
                }
                continue;
            }
            if (extractFields != null && extractFields.size() > 0) {
                if (name == null) {
                    name = source.replaceAll("(?i)\\.(unicon)$", "_fields." + format);
                }
                CLIMain.exportFields(contract, extractFields, name, format, options.has("pretty"));
                continue;
            }
            if (name == null) {
                name = source.replaceAll("(?i)\\.(unicon)$", "." + format);
            }
            CLIMain.exportContract(contract, name, format, options.has("pretty"));
        }
        CLIMain.finish();
    }

    private static void doImport() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("i"));
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        List<?> names = options.valuesOf("name");
        List<?> updateFields = options.valuesOf("set");
        List<?> updateValues = options.valuesOf("value");
        for (int s = 0; s < sources.size(); ++s) {
            Contract contract;
            String source = (String)sources.get(s);
            String name = null;
            if (names.size() > s) {
                name = (String)names.get(s);
            }
            if ((contract = CLIMain.importContract(source)) == null) continue;
            HashMap<String, String> updateFieldsHashMap = new HashMap<String, String>();
            try {
                for (int i = 0; i < updateFields.size(); ++i) {
                    updateFieldsHashMap.put((String)updateFields.get(i), (String)updateValues.get(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (updateFieldsHashMap.size() > 0) {
                CLIMain.updateFields(contract, updateFieldsHashMap);
            }
            if (name == null) {
                name = source.replaceAll("(?i)\\.(json|xml|yml|yaml)$", ".unicon");
            }
            contract.seal();
            CLIMain.saveContract(contract, name);
        }
        CLIMain.finish();
    }

    private static void doCheckContracts() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("ch"));
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            List<File> files = CLIMain.findFiles(source, options.has("r"));
            if (files.size() > 0) {
                files.forEach(f -> CLIMain.checkFile(f));
            } else {
                CLIMain.report("No contracts found at the " + source);
            }
            CLIMain.report("");
        }
        CLIMain.finish();
    }

    private static void doFindContracts() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("f"));
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            CLIMain.report("Looking for contracts at the " + source);
            HashMap<String, Contract> allFoundContracts = CLIMain.findContracts(source, options.has("r"));
            List<Wallet> wallets = Wallet.determineWallets(new ArrayList<Contract>(allFoundContracts.values()));
            if (wallets.size() > 0) {
                CLIMain.printWallets(wallets);
            } else {
                CLIMain.report("No wallets found");
            }
            if (allFoundContracts.size() > 0) {
                CLIMain.printContracts(allFoundContracts);
                continue;
            }
            CLIMain.report("No contracts found");
        }
        CLIMain.finish();
    }

    private static void doRegister() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("register"));
        String tuSource = (String)options.valueOf("tu");
        int tuAmount = (Integer)options.valueOf(AMOUNT_FIELD_NAME);
        boolean tutest = options.has("tutest");
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            Contract contract = CLIMain.loadContract(source);
            Contract tu = null;
            if (tuSource != null) {
                tu = CLIMain.loadContract(tuSource, true);
                CLIMain.report("load payment revision: " + tu.getState().getRevision() + " id: " + tu.getId());
            }
            HashSet<PrivateKey> tuKeys = new HashSet<PrivateKey>(CLIMain.keysMap().values());
            if (contract == null) continue;
            if (tu != null && tuKeys != null && tuKeys.size() > 0) {
                CLIMain.report("registering the paid contract " + contract.getId() + " from " + source + " for " + tuAmount + " TU");
                Parcel parcel = CLIMain.registerContract(contract, tu, tuAmount, tuKeys, tutest, (Integer)options.valueOf("wait"));
                if (parcel == null) continue;
                CLIMain.report("save payment revision: " + parcel.getPaymentContract().getState().getRevision() + " id: " + parcel.getPaymentContract().getId());
                CopyOption[] copyOptions = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
                Files.copy(Paths.get(tuSource, new String[0]), Paths.get(tuSource.replaceAll("(?i)\\.(unicon)$", "_rev" + tu.getRevision() + ".unicon"), new String[0]), copyOptions);
                CLIMain.saveContract(parcel.getPaymentContract(), tuSource, true, false);
                continue;
            }
            CLIMain.report("registering the contract " + contract.getId().toBase64String() + " from " + source);
            CLIMain.registerContract(contract, (Integer)options.valueOf("wait"));
        }
        if (options.has("cost")) {
            CLIMain.doCost();
        } else {
            CLIMain.finish();
        }
    }

    private static void doProbe() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("probe"));
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            ItemResult itemResult = CLIMain.getClientNetwork().check(source);
        }
        CLIMain.finish();
    }

    private static void doGenerateKeyPair() throws IOException {
        PrivateKey k = new PrivateKey((Integer)options.valueOf("s"));
        String name = (String)options.valueOf("g");
        new FileOutputStream(name + ".private.unikey").write(k.pack());
        new FileOutputStream(name + ".public.unikey").write(k.getPublicKey().pack());
        if (options.has("base64")) {
            new FileOutputStream(name + ".public.unikey.txt").write(Base64.encodeLines(k.getPublicKey().pack()).getBytes());
        }
        System.out.println("New key pair ready");
    }

    private static void doRevoke() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("revoke"));
        String tuSource = (String)options.valueOf("tu");
        int tuAmount = (Integer)options.valueOf(AMOUNT_FIELD_NAME);
        boolean tutest = options.has("tutest");
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        CLIMain.report("doRevoke");
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            Contract contract = CLIMain.loadContract(source);
            CLIMain.report("doRevoke " + contract);
            Contract tu = null;
            if (tuSource != null) {
                tu = CLIMain.loadContract(tuSource, true);
                CLIMain.report("load payment revision: " + tu.getState().getRevision() + " id: " + tu.getId());
            }
            HashSet<PrivateKey> tuKeys = new HashSet<PrivateKey>(CLIMain.keysMap().values());
            CLIMain.report("tuKeys num: " + tuKeys.size());
            if (contract == null) continue;
            if (tu != null && tuKeys != null && tuKeys.size() > 0) {
                CLIMain.report("registering the paid contract " + contract.getId() + " from " + source + " for " + tuAmount + " TU");
                Parcel parcel = null;
                try {
                    if (contract.check()) {
                        CLIMain.report("revoke contract from " + source);
                        parcel = CLIMain.revokeContract(contract, tu, tuAmount, tuKeys, tutest, CLIMain.keysMap().values().toArray(new PrivateKey[0]));
                    } else {
                        CLIMain.addErrors((List<ErrorRecord>)contract.getErrors());
                    }
                }
                catch (Quantiser.QuantiserException e) {
                    CLIMain.addError("QUANTIZER_COST_LIMIT", contract.toString(), e.getMessage());
                }
                if (parcel == null) continue;
                CLIMain.report("save payment revision: " + parcel.getPaymentContract().getState().getRevision() + " id: " + parcel.getPaymentContract().getId());
                CopyOption[] copyOptions = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
                Files.copy(Paths.get(tuSource, new String[0]), Paths.get(tuSource.replaceAll("(?i)\\.(unicon)$", "_rev" + tu.getRevision() + ".unicon"), new String[0]), copyOptions);
                CLIMain.saveContract(parcel.getPaymentContract(), tuSource, true, false);
                continue;
            }
            try {
                if (contract.check()) {
                    CLIMain.report("revoke contract from " + source);
                    CLIMain.revokeContract(contract, CLIMain.keysMap().values().toArray(new PrivateKey[0]));
                    continue;
                }
                CLIMain.addErrors((List<ErrorRecord>)contract.getErrors());
                continue;
            }
            catch (Quantiser.QuantiserException e) {
                CLIMain.addError("QUANTIZER_COST_LIMIT", contract.toString(), e.getMessage());
            }
        }
        CLIMain.finish();
    }

    private static void doPackWith() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("pack-with"));
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        List<?> siblingItems = options.valuesOf("add-sibling");
        List<?> revokeItems = options.valuesOf("add-revoke");
        List<?> names = options.valuesOf("name");
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            String name = null;
            if (names.size() > s) {
                name = (String)names.get(s);
            }
            Contract contract = CLIMain.loadContract(source, true);
            try {
                if (contract == null) continue;
                if (contract.check()) {
                    CLIMain.report("pack contract from " + source);
                    if (siblingItems != null) {
                        for (Object sibFile : siblingItems) {
                            Contract siblingContract = CLIMain.loadContract((String)sibFile, true);
                            CLIMain.report("add sibling from " + sibFile);
                            contract.addNewItems(siblingContract);
                        }
                    }
                    if (revokeItems != null) {
                        for (Object revokeFile : revokeItems) {
                            Contract revokeContract = CLIMain.loadContract((String)revokeFile, true);
                            CLIMain.report("add revoke from " + revokeFile);
                            contract.addRevokingItems(revokeContract);
                        }
                    }
                    if (name == null) {
                        name = source;
                    }
                    if (siblingItems == null && revokeItems == null) continue;
                    contract.seal();
                    CLIMain.saveContract(contract, name, true, true);
                    continue;
                }
                CLIMain.addErrors((List<ErrorRecord>)contract.getErrors());
                continue;
            }
            catch (Quantiser.QuantiserException e) {
                CLIMain.addError("QUANTIZER_COST_LIMIT", contract.toString(), e.getMessage());
            }
        }
        CLIMain.finish();
    }

    private static void doUnpackWith() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("unpack"));
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            Contract contract = CLIMain.loadContract(source, true);
            if (contract == null) continue;
            try {
                if (contract.check()) {
                    CLIMain.report("unpack contract from " + source);
                    int i = 1;
                    if (contract.getNewItems() != null) {
                        for (Approvable newItem : contract.getNewItems()) {
                            String newItemFileName = source.replaceAll("(?i)\\.(unicon)$", "_new_item_" + i + ".unicon");
                            CLIMain.report("save newItem to " + newItemFileName);
                            CLIMain.saveContract((Contract)newItem, newItemFileName);
                            ++i;
                        }
                    }
                    i = 1;
                    if (contract.getRevokingItems() == null) continue;
                    for (Approvable revokeItem : contract.getRevokingItems()) {
                        String revokeItemFileName = source.replaceAll("(?i)\\.(unicon)$", "_revoke_" + i + ".unicon");
                        CLIMain.report("save revokeItem to " + revokeItemFileName);
                        CLIMain.saveContract((Contract)revokeItem, revokeItemFileName);
                        ++i;
                    }
                    continue;
                }
                CLIMain.addErrors((List<ErrorRecord>)contract.getErrors());
                continue;
            }
            catch (Quantiser.QuantiserException e) {
                CLIMain.addError("QUANTIZER_COST_LIMIT", contract.toString(), e.getMessage());
            }
        }
        CLIMain.finish();
    }

    private static void doCost() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("cost"));
        ArrayList registerSources = new ArrayList(options.valuesOf("register"));
        for (Object opt : registerSources) {
            sources.addAll(Arrays.asList(((String)opt).split(",")));
        }
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            ContractFileTypes fileType = CLIMain.getFileType(source);
            CLIMain.report("");
            CLIMain.report("Calculating cost of " + source + ", type is " + (Object)((Object)fileType) + "...");
            Contract contract = null;
            if (fileType == ContractFileTypes.BINARY) {
                contract = CLIMain.loadContract(source);
            } else {
                CLIMain.addError(Errors.COMMAND_FAILED.name(), source, "Contract should be sealed binary");
            }
            if (contract == null) continue;
            try {
                contract.check();
            }
            catch (Quantiser.QuantiserException e) {
                CLIMain.addError("QUANTIZER_COST_LIMIT", contract.toString(), e.getMessage());
            }
            CLIMain.printProcessingCost(contract);
        }
        CLIMain.finish();
    }

    private static void doAnonymize() throws IOException {
        ArrayList sources = new ArrayList(options.valuesOf("anonymize"));
        ArrayList<Object> roles = new ArrayList(options.valuesOf("role"));
        List<?> names = options.valuesOf("name");
        ArrayList nonOptions = new ArrayList(options.nonOptionArguments());
        for (String opt : nonOptions) {
            sources.addAll(Arrays.asList(opt.split(",")));
        }
        CLIMain.cleanNonOptionalArguments(sources);
        for (int s = 0; s < sources.size(); ++s) {
            String source = (String)sources.get(s);
            Contract contract = CLIMain.loadContract(source);
            if (contract == null) continue;
            if (roles.size() <= 0) {
                roles = new ArrayList<String>(contract.getRoles().keySet());
            }
            for (String roleName : roles) {
                CLIMain.report("Anonymizing role " + roleName + " in " + source + "...");
                contract.anonymizeRole(roleName);
                contract.seal();
            }
            if (names.size() > s) {
                CLIMain.saveContract(contract, (String)names.get(s), true, false);
                continue;
            }
            CLIMain.saveContract(contract, source.replaceAll("(?i)\\.(unicon)$", "_anonymized.unicon"), true, false);
        }
        CLIMain.finish();
    }

    private static void doCreateAddress(String keyFilePath, boolean bShort) throws IOException {
        CLIMain.report("Generate " + (bShort ? "short" : "long") + " address from key: " + keyFilePath);
        PrivateKey key = new PrivateKey(Do.read(keyFilePath));
        KeyAddress address = new KeyAddress(key.getPublicKey(), 0, !bShort);
        CLIMain.report("Address: " + address.toString());
        CLIMain.finish();
    }

    private static void doAddressMatch(String address, String keyFilePath) throws IOException {
        boolean bResult = false;
        try {
            PrivateKey key = new PrivateKey(Do.read(keyFilePath));
            KeyAddress keyAddress = new KeyAddress(address);
            bResult = keyAddress.isMatchingKey(key.getPublicKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
        CLIMain.report("Matching address: " + address + " with key: " + keyFilePath);
        CLIMain.report("Matching result: " + bResult);
        CLIMain.finish();
    }

    private static void doSelectKeyInFolder(String keysPath, String address) throws IOException {
        KeyAddress keyAddress;
        File folder = new File(keysPath);
        if (!keysPath.endsWith("/")) {
            keysPath = keysPath.concat("/");
        }
        try {
            keyAddress = new KeyAddress(address);
        }
        catch (Exception e) {
            CLIMain.report("Invalid address.");
            CLIMain.finish();
            return;
        }
        if (folder.exists()) {
            for (File file : folder.listFiles()) {
                if (file.isDirectory()) continue;
                boolean bResult = false;
                try {
                    PrivateKey key = new PrivateKey(Do.read(keysPath + file.getName()));
                    bResult = keyAddress.isMatchingKey(key.getPublicKey());
                }
                catch (Exception e) {
                    bResult = false;
                }
                if (!bResult) continue;
                CLIMain.report("Filekey: " + file.getName());
                CLIMain.finish();
                return;
            }
            CLIMain.report("File not found.");
        } else {
            CLIMain.report("There is no such directory.");
        }
        CLIMain.finish();
    }

    private static void cleanNonOptionalArguments(List sources) throws IOException {
        List<?> roleValues;
        List<?> updateValues;
        List<?> updateFields;
        List<?> extractFields;
        List<?> extractKeyRoles;
        List<?> names;
        ArrayList formats = new ArrayList(options.valuesOf("as"));
        if (formats != null) {
            sources.removeAll(formats);
            sources.remove("-as");
            sources.remove("--as");
        }
        if (options.has("j")) {
            sources.remove("-j");
            sources.remove("--j");
            sources.remove("-json");
            sources.remove("--json");
        }
        if (options.has("v")) {
            sources.remove("-v");
            sources.remove("--v");
            sources.remove("-verbose");
            sources.remove("--verbose");
        }
        if (options.has("r")) {
            sources.remove("-r");
            sources.remove("--r");
        }
        if (options.has("pretty")) {
            sources.remove("-pretty");
            sources.remove("--pretty");
        }
        if (options.has("tutest")) {
            sources.remove("-tutest");
            sources.remove("--tutest");
        }
        if ((names = options.valuesOf("name")) != null) {
            sources.removeAll(names);
            sources.remove("-name");
            sources.remove("--name");
        }
        if ((extractKeyRoles = options.valuesOf("extract-key")) != null) {
            sources.removeAll(extractKeyRoles);
            sources.remove("-extract-key");
            sources.remove("--extract-key");
        }
        if ((extractFields = options.valuesOf("get")) != null) {
            sources.removeAll(extractFields);
            sources.remove("-get");
            sources.remove("--get");
        }
        if ((updateFields = options.valuesOf("set")) != null) {
            sources.removeAll(updateFields);
            sources.remove("-set");
            sources.remove("--set");
        }
        if ((updateValues = options.valuesOf("value")) != null) {
            sources.removeAll(updateValues);
            sources.remove("-value");
            sources.remove("--value");
        }
        if ((roleValues = options.valuesOf("role")) != null) {
            sources.removeAll(roleValues);
            sources.remove("-role");
            sources.remove("--role");
        }
    }

    private static void addErrors(List<ErrorRecord> errors) {
        errors.forEach(e -> CLIMain.addError(e.getError().name(), e.getObjectName(), e.getMessage()));
    }

    public static PrivateKey getPrivateKey() throws IOException {
        if (privateKey == null) {
            String keyFileName = prefs.get("privateKeyFile", null);
            if (keyFileName != null) {
                reporter.verbose("Loading private key from " + keyFileName);
                try {
                    privateKey = new PrivateKey(Do.read(keyFileName));
                }
                catch (IOException e) {
                    reporter.warning("can't read privte Key file: " + keyFileName);
                }
            }
            if (privateKey == null) {
                reporter.warning("\nUser private key is not set, generating new one.");
                reporter.message("new private key has been generated");
                privateKey = new PrivateKey(2048);
                Path keysDir = Paths.get(System.getProperty("user.home") + "/.universa", new String[0]);
                if (!Files.exists(keysDir, new LinkOption[0])) {
                    reporter.verbose("creating new keys directory: " + keysDir.toString());
                    Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwx------");
                    FileAttribute<Set<PosixFilePermission>> ownerOnly = PosixFilePermissions.asFileAttribute(perms);
                    try {
                        Files.createDirectory(keysDir, ownerOnly);
                    }
                    catch (UnsupportedOperationException e) {
                        Files.createDirectory(keysDir, new FileAttribute[0]);
                        System.out.println("* Warning: can't set permissions on keys directory on windows");
                        System.out.println("*          it is strongly recommended to restrict access to it manually\n");
                    }
                }
                Path keyFile = keysDir.resolve("main.private.unikey");
                try (OutputStream out = Files.newOutputStream(keyFile, new OpenOption[0]);){
                    out.write(privateKey.pack());
                }
                try {
                    Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rw-------");
                    Files.setPosixFilePermissions(keyFile, perms);
                }
                catch (UnsupportedOperationException e) {
                    System.out.println("* Warning: can't set permissions on key file on windows.");
                    System.out.println("*          it is strongly recommended to restrict access to it manually\n");
                }
                prefs.put("privateKeyFile", keyFile.toString());
                CLIMain.report("new private key has just been generated and stored to the " + keysDir);
            }
        }
        return privateKey;
    }

    public static BasicHttpClientSession getSession(int nodeNumber) throws IOException {
        if (session == null) {
            String keyFileName = prefs.get("session_" + nodeNumber, null);
            if (keyFileName != null) {
                reporter.verbose("Loading session from " + keyFileName);
                try {
                    session = BasicHttpClientSession.reconstructSession(Boss.unpack(Do.read(keyFileName)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception e) {
                    reporter.warning("can't read session file: " + keyFileName);
                    e.printStackTrace();
                }
            } else {
                reporter.verbose("No session found at the prefs ");
            }
        }
        return session;
    }

    public static void breakSession(int nodeNumber) throws IOException {
        BasicHttpClientSession s = CLIMain.getSession(nodeNumber);
        s.setSessionId(666L);
        s.setSessionKey(new SymmetricKey());
        Path keysDir = Paths.get(System.getProperty("user.home") + "/.universa", new String[0]);
        if (!Files.exists(keysDir, new LinkOption[0])) {
            reporter.verbose("creating new keys directory: " + keysDir.toString());
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwx------");
            FileAttribute<Set<PosixFilePermission>> ownerOnly = PosixFilePermissions.asFileAttribute(perms);
            Files.createDirectory(keysDir, ownerOnly);
        }
        Path sessionFile = keysDir.resolve("node_" + nodeNumber + ".session");
        try (OutputStream out = Files.newOutputStream(sessionFile, new OpenOption[0]);){
            out.write(Boss.pack(s.asBinder()));
        }
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rw-------");
        Files.setPosixFilePermissions(sessionFile, perms);
        prefs.put("session_" + nodeNumber, sessionFile.toString());
        reporter.verbose("Broken session has been stored to the " + keysDir + "/" + sessionFile);
    }

    public static void clearSession() {
        CLIMain.clearSession(true);
    }

    public static void clearSession(boolean full) {
        session = null;
        if (full) {
            try {
                String[] keys = prefs.keys();
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i].indexOf("session_") != 0) continue;
                    prefs.remove(keys[i]);
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveSession() throws IOException {
        int nodeNumber = CLIMain.getClientNetwork().getNodeNumber();
        reporter.verbose("Session from ClientNetwork is exist: " + (session != null));
        if (session != null) {
            Path keysDir = Paths.get(System.getProperty("user.home") + "/.universa", new String[0]);
            if (!Files.exists(keysDir, new LinkOption[0])) {
                reporter.verbose("creating new keys directory: " + keysDir.toString());
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwx------");
                FileAttribute<Set<PosixFilePermission>> ownerOnly = PosixFilePermissions.asFileAttribute(perms);
                Files.createDirectory(keysDir, ownerOnly);
            }
            Path sessionFile = keysDir.resolve("node_" + nodeNumber + ".session");
            try (OutputStream out = Files.newOutputStream(sessionFile, new OpenOption[0]);){
                out.write(Boss.pack(session.asBinder()));
            }
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rw-------");
            try {
                Files.setPosixFilePermissions(sessionFile, perms);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            prefs.put("session_" + nodeNumber, sessionFile.toString());
            CLIMain.report("Session has been stored to the " + keysDir + "/" + sessionFile);
        }
    }

    public static void setVerboseMode(boolean verboseMode) {
        reporter.setVerboseMode(verboseMode);
    }

    private static void printFingerprints() throws IOException {
        Map<String, PrivateKey> kk = CLIMain.keysMap();
        if (kk.isEmpty()) {
            CLIMain.report("please specify at least one key file with --fingerprints");
        } else {
            kk.forEach((name, key) -> {
                CLIMain.report("Fingerprints:");
                CLIMain.report(name + "\t" + Base64.encodeCompactString(key.fingerprint()));
            });
        }
    }

    private static void anonymousKeyPrints() throws IOException {
        Map<String, PrivateKey> kk = CLIMain.keysMap();
        if (kk.isEmpty()) {
            CLIMain.report("please specify at least one key file with --fingerprints");
        } else {
            kk.forEach((name, key) -> {
                CLIMain.report("Anonymous key prints:");
                CLIMain.report(name + "\t" + Base64.encodeCompactString(key.fingerprint()));
            });
        }
    }

    private static void checkFile(File f) {
        try {
            TransactionPack tp = TransactionPack.unpack(Do.read(f), true);
            if (tp.isReconstructed()) {
                CLIMain.report("file " + f + " is a single contract");
            } else {
                CLIMain.report("file " + f + " is a transaction pack");
            }
            System.out.println();
            CLIMain.checkContract(tp.getContract());
        }
        catch (Quantiser.QuantiserException e) {
            CLIMain.addError("QUANTIZER_COST_LIMIT", f.getPath(), e.toString());
        }
        catch (IOException e) {
            CLIMain.addError("READ_ERROR", f.getPath(), e.toString());
        }
        catch (Exception e) {
            CLIMain.addError("UNKNOWN_ERROR", f.getPath(), e.toString());
        }
    }

    private static void checkContract(Contract contract) {
        Multimap<String, Permission> permissions;
        Collection<Permission> sjs;
        if (!contract.isOk()) {
            reporter.message("The capsule is not sealed properly:");
            contract.getErrors().forEach(e -> reporter.error(e.getError().toString(), e.getObjectName(), e.getMessage()));
        }
        Yaml yaml = new Yaml();
        if (reporter.isVerboseMode()) {
            CLIMain.report("api level:   " + contract.getApiLevel());
            CLIMain.report("contract id: " + contract.getId().toBase64String());
            CLIMain.report("issued:      " + contract.getIssuedAt());
            CLIMain.report("revision:    " + contract.getRevision());
            CLIMain.report("created:     " + contract.getCreatedAt());
            CLIMain.report("expires:     " + contract.getExpiresAt());
            System.out.println();
            Set<PublicKey> keys = contract.getSealedByKeys();
            contract.getRevoking().forEach(r -> {
                try {
                    ClientNetwork n = CLIMain.getClientNetwork();
                    System.out.println();
                    CLIMain.report("revoking item exists: " + r.getId().toBase64String());
                    CLIMain.report("\tstate: " + n.check(r.getId()));
                    HashId origin = r.getOrigin();
                    boolean m = origin.equals(contract.getOrigin());
                    CLIMain.report("\tOrigin: " + origin);
                    CLIMain.report("\t" + (m ? "matches main contract origin" : "does not match main contract origin"));
                    if (r.canBeRevoked(keys)) {
                        CLIMain.report("\trevocation is allowed");
                    } else {
                        reporter.error(Errors.BAD_REVOKE.name(), r.getId().toString(), "revocation not allowed");
                    }
                }
                catch (Exception clientError) {
                    clientError.printStackTrace();
                }
            });
            contract.getNewItems().forEach(n -> {
                System.out.println();
                CLIMain.report("New item exists:      " + n.getId().toBase64String());
                Contract nc = (Contract)n;
                boolean m = nc.getOrigin().equals(contract.getOrigin());
                CLIMain.report("\tOrigin: " + ((Contract)n).getOrigin());
                CLIMain.report("\t" + (m ? "matches main contract origin" : "does not match main contract origin"));
            });
            if (keys.size() > 0) {
                CLIMain.report("\nSignature contains " + keys.size() + " valid key(s):\n");
                keys.forEach(k -> {
                    KeyInfo i = k.info();
                    CLIMain.report("\t\u2714\ufe0e " + (Object)((Object)i.getAlgorythm()) + ":" + i.getKeyLength() * 8 + ":" + i.getBase64Tag());
                });
                CLIMain.report("\nWhich can play roles:\n");
                contract.getRoles().forEach((name, role) -> {
                    String canPlay = role.isAllowedForKeys(keys) ? "\u2714" : "\u2718";
                    CLIMain.report("\t" + canPlay + " " + role.getName());
                });
                CLIMain.report("\nAnd have permissions:\n");
                contract.getPermissions().values().forEach(perm -> {
                    String canPlay = perm.isAllowedForKeys(keys) ? "\u2714" : "\u2718";
                    CLIMain.report("\t" + canPlay + " " + perm.getName());
                    Binder x = (Binder)DefaultBiMapper.serialize(perm.getParams());
                    BufferedReader br = new BufferedReader(new StringReader(yaml.dumpAsMap(x)));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            CLIMain.report("\t    " + line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                reporter.newLine();
            }
        }
        if ((sjs = (permissions = contract.getPermissions()).get("split_join")) != null) {
            sjs.forEach(sj -> CLIMain.checkSj(contract, sj));
        }
        try {
            contract.check();
        }
        catch (Quantiser.QuantiserException e2) {
            CLIMain.addError("QUANTIZER_COST_LIMIT", contract.toString(), e2.getMessage());
        }
        catch (Exception e3) {
            CLIMain.addError(Errors.FAILURE.name(), contract.toString(), e3.getMessage());
        }
        CLIMain.addErrors((List<ErrorRecord>)contract.getErrors());
        if (contract.getErrors().size() == 0) {
            CLIMain.report("Contract is valid");
        }
    }

    private static void checkSj(Contract contract, Permission sj) {
        Binder params = sj.getParams();
        String fieldName = "state.data." + params.getStringOrThrow("field_name");
        reporter.verbose("splitjoins permission fond on field '" + fieldName + "'");
        StringBuilder outcome = new StringBuilder();
        ArrayList values = new ArrayList();
        contract.getRevoking().forEach(c -> {
            if (c.get(fieldName) != null) {
                Decimal x = new Decimal(c.get(fieldName).toString());
                values.add(x);
                if (outcome.length() > 0) {
                    outcome.append(" + ");
                }
                outcome.append(x.toString());
            }
        });
        ArrayList<Contract> news = Do.listOf(contract);
        news.addAll(contract.getNew());
        outcome.append(" -> ");
        news.forEach(c -> {
            if (c.get(fieldName) != null) {
                if (c != contract) {
                    outcome.append(" + ");
                }
                Decimal x = new Decimal(c.get(fieldName).toString());
                outcome.append(x.toString());
                values.add(x.negate());
            }
        });
        reporter.verbose("operation is: " + outcome.toString());
        Decimal saldo = values.stream().reduce(Decimal.ZERO, (a, b) -> a.add((Decimal)b));
        if (saldo.compareTo(Decimal.ZERO) == 0) {
            reporter.verbose("Saldo looks good (zero)");
        } else {
            reporter.warning("Saldo is not zero: " + saldo);
        }
    }

    private static Boolean checkBytesIsValidContract(byte[] data) {
        try {
            Contract contract = new Contract(data);
            if (!contract.isOk()) {
                reporter.message("The capsule is not sealed");
                contract.getErrors().forEach(e -> reporter.error(e.getError().toString(), e.getObjectName(), e.getMessage()));
            }
            CLIMain.checkContract(contract);
        }
        catch (RuntimeException e2) {
            CLIMain.addError(Errors.BAD_VALUE.name(), "byte[] data", e2.getMessage());
            return false;
        }
        catch (Quantiser.QuantiserException e3) {
            CLIMain.addError("QUANTIZER_COST_LIMIT", "", e3.toString());
        }
        catch (IOException e4) {
            CLIMain.addError(Errors.BAD_VALUE.name(), "byte[] data", e4.getMessage());
            return false;
        }
        return true;
    }

    private static Contract importContract(String sourceName) throws IOException {
        ContractFileTypes fileType = CLIMain.getFileType(sourceName);
        Contract contract = null;
        File pathFile = new File(sourceName);
        if (pathFile.exists()) {
            try {
                Binder binder;
                FileReader reader = new FileReader(sourceName);
                if (fileType == ContractFileTypes.YAML) {
                    Yaml yaml = new Yaml();
                    binder = (Binder)Binder.convertAllMapsToBinders(yaml.load(reader));
                } else if (fileType == ContractFileTypes.JSON) {
                    Gson gson = new GsonBuilder().create();
                    binder = (Binder)Binder.convertAllMapsToBinders(gson.fromJson((Reader)reader, Binder.class));
                } else {
                    XStream xstream = new XStream(new DomDriver());
                    xstream.registerConverter(new MapEntryConverter());
                    xstream.alias("contract", Binder.class);
                    binder = (Binder)Binder.convertAllMapsToBinders(xstream.fromXML(reader));
                }
                BiDeserializer bm = DefaultBiMapper.getInstance().newDeserializer();
                contract = new Contract();
                contract.deserialize(binder, bm);
                CLIMain.report(">>> imported contract: " + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(contract.getCreatedAt()));
                CLIMain.report("import from " + fileType.toString().toLowerCase() + " ok");
            }
            catch (Exception e) {
                CLIMain.addError(Errors.FAILURE.name(), sourceName, e.getMessage());
            }
        } else {
            CLIMain.addError(Errors.NOT_FOUND.name(), sourceName, "Path " + sourceName + " does not exist");
        }
        return contract;
    }

    public static Contract loadContract(String fileName, Boolean fromPackedTransaction) throws IOException {
        Contract contract;
        block5: {
            contract = null;
            File pathFile = new File(fileName);
            if (pathFile.exists()) {
                Path path = Paths.get(fileName, new String[0]);
                byte[] data = Files.readAllBytes(path);
                try {
                    if (fromPackedTransaction.booleanValue()) {
                        contract = Contract.fromPackedTransaction(data);
                        break block5;
                    }
                    contract = new Contract(data);
                }
                catch (Quantiser.QuantiserException e) {
                    CLIMain.addError("QUANTIZER_COST_LIMIT", fileName, e.toString());
                }
            } else {
                CLIMain.addError(Errors.NOT_FOUND.name(), fileName, "Path " + fileName + " does not exist");
            }
        }
        return contract;
    }

    public static Contract loadContract(String fileName) throws IOException {
        return CLIMain.loadContract(fileName, true);
    }

    private static void exportContract(Contract contract, String fileName, String format) throws IOException {
        CLIMain.exportContract(contract, fileName, format, false);
    }

    public static void exportContract(Contract contract, String fileName, String format, Boolean jsonPretty) throws IOException {
        byte[] data;
        format = format.toLowerCase();
        CLIMain.report("export format: " + format);
        if (fileName == null) {
            fileName = testMode && testRootPath != null ? testRootPath + "Universa_" + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(contract.getCreatedAt()) : "Universa_" + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(contract.getCreatedAt());
        }
        Binder binder = contract.serialize(DefaultBiMapper.getInstance().newSerializer());
        if ("xml".equals(format)) {
            XStream xstream = new XStream(new DomDriver());
            xstream.registerConverter(new MapEntryConverter());
            xstream.alias("contract", Binder.class);
            data = xstream.toXML(binder).getBytes();
        } else if ("yaml".equals(format) || "yml".equals(format)) {
            Yaml yaml = new Yaml();
            data = yaml.dumpAsMap(binder).getBytes();
        } else {
            Gson gson = jsonPretty != false ? new GsonBuilder().setPrettyPrinting().create() : new GsonBuilder().create();
            String jsonString = gson.toJson(binder);
            data = jsonString.getBytes();
        }
        try (FileOutputStream fs = new FileOutputStream(fileName);){
            fs.write(data);
            fs.close();
        }
        CLIMain.report(fileName + " export as " + format + " ok");
    }

    private static void exportPublicKeys(Contract contract, String roleName, String fileName, boolean base64) throws IOException {
        Role role;
        if (fileName == null) {
            fileName = testMode && testRootPath != null ? testRootPath + "Universa_" + roleName + "_public_key" : "Universa_" + roleName + "_public_key.pub";
        }
        if ((role = contract.getRole(roleName)) != null) {
            Set<PublicKey> keys = role.getKeys();
            int index = 0;
            for (PublicKey key : keys) {
                byte[] data = key.pack();
                String name = fileName.replaceAll("\\.(pub)$", "_key_" + roleName + "_" + ++index + ".public.unikey");
                if (base64) {
                    name = name + ".txt";
                }
                FileOutputStream fs = new FileOutputStream(name);
                Throwable throwable = null;
                try {
                    if (base64) {
                        fs.write(Base64.encodeLines(data).getBytes());
                    } else {
                        fs.write(data);
                    }
                    fs.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fs == null) continue;
                    if (throwable != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fs.close();
                }
            }
            CLIMain.report(roleName + " export public keys ok");
        } else {
            CLIMain.report("export public keys error, role does not exist: " + roleName);
        }
    }

    private static void exportFields(Contract contract, List<String> fieldNames, String fileName, String format) throws IOException {
        CLIMain.exportFields(contract, fieldNames, fileName, format, false);
    }

    private static void exportFields(Contract contract, List<String> fieldNames, String fileName, String format, Boolean jsonPretty) throws IOException {
        format = format.toLowerCase();
        CLIMain.report("export format: " + format);
        if (fileName == null) {
            fileName = testMode && testRootPath != null ? testRootPath + "Universa_fields_" + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(contract.getCreatedAt()) : "Universa_fields_" + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(contract.getCreatedAt());
        }
        Binder hm = new Binder();
        try {
            byte[] data;
            for (String fieldName : fieldNames) {
                CLIMain.report("export field: " + fieldName + " -> " + contract.get(fieldName));
                hm.put(fieldName, contract.get(fieldName));
            }
            Binder binder = (Binder)DefaultBiMapper.getInstance().newSerializer().serialize(hm);
            if ("xml".equals(format)) {
                XStream xstream = new XStream(new DomDriver());
                xstream.registerConverter(new MapEntryConverter());
                xstream.alias("fields", Binder.class);
                data = xstream.toXML(binder).getBytes();
            } else if ("yaml".equals(format) || "yml".equals(format)) {
                Yaml yaml = new Yaml();
                data = yaml.dumpAsMap(binder).getBytes();
            } else {
                Gson gson = jsonPretty != false ? new GsonBuilder().setPrettyPrinting().create() : new GsonBuilder().create();
                String jsonString = gson.toJson(binder);
                data = jsonString.getBytes();
            }
            try (FileOutputStream fs = new FileOutputStream(fileName);){
                fs.write(data);
                fs.close();
            }
            CLIMain.report("export fields as " + format + " ok");
        }
        catch (IllegalArgumentException e) {
            CLIMain.report("export fields error: " + e.getMessage());
        }
    }

    private static void updateFields(Contract contract, HashMap<String, String> fields) throws IOException {
        for (String fieldName : fields.keySet()) {
            CLIMain.report("update field: " + fieldName + " -> " + fields.get(fieldName));
            Binder binder = new Binder();
            Binder data = null;
            try {
                XStream xstream = new XStream(new DomDriver());
                xstream.registerConverter(new MapEntryConverter());
                xstream.alias(fieldName, Binder.class);
                data = (Binder)Binder.convertAllMapsToBinders(xstream.fromXML(fields.get(fieldName)));
            }
            catch (Exception xmlEx) {
                try {
                    Gson gson = new GsonBuilder().create();
                    binder = (Binder)Binder.convertAllMapsToBinders(gson.fromJson(fields.get(fieldName), Binder.class));
                    data = (Binder)data.get(fieldName);
                }
                catch (Exception jsonEx) {
                    try {
                        Yaml yaml = new Yaml();
                        data = (Binder)Binder.convertAllMapsToBinders(yaml.load(fields.get(fieldName)));
                        data = (Binder)data.get(fieldName);
                    }
                    catch (Exception yamlEx) {
                        yamlEx.printStackTrace();
                    }
                }
            }
            if (data != null) {
                BiDeserializer bm = DefaultBiMapper.getInstance().newDeserializer();
                binder.put("data", bm.deserialize(data));
                contract.set(fieldName, binder);
                CLIMain.report("update field " + fieldName + " ok");
                continue;
            }
            CLIMain.report("update field " + fieldName + " error: no valid data");
        }
        CLIMain.report("contract expires at " + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(contract.getExpiresAt()));
    }

    public static void saveContract(Contract contract, String fileName, Boolean fromPackedTransaction, Boolean addSigners) throws IOException {
        if (fileName == null) {
            fileName = "Universa_" + DateTimeFormatter.ofPattern("yyyy-MM-ddTHH:mm:ss").format(contract.getCreatedAt()) + ".unicon";
        }
        if (addSigners.booleanValue()) {
            CLIMain.keysMap().values().forEach(k -> contract.addSignerKey((PrivateKey)k));
            if (CLIMain.keysMap().values().size() > 0) {
                contract.seal();
            }
        }
        byte[] data = fromPackedTransaction != false ? contract.getPackedTransaction() : contract.getLastSealedBinary();
        int count = contract.getKeysToSignWith().size();
        if (count > 0) {
            CLIMain.report("Contract is sealed with " + count + " key(s)");
        }
        CLIMain.report("Contract is saved to: " + fileName);
        CLIMain.report("Sealed contract size: " + data.length);
        try (FileOutputStream fs = new FileOutputStream(fileName);){
            fs.write(data);
            fs.close();
        }
        try {
            if (contract.check()) {
                CLIMain.report("Sealed contract has no errors");
            } else {
                CLIMain.addErrors((List<ErrorRecord>)contract.getErrors());
            }
        }
        catch (Quantiser.QuantiserException e) {
            CLIMain.addError("QUANTIZER_COST_LIMIT", contract.toString(), e.getMessage());
        }
    }

    public static void saveContract(Contract contract, String fileName) throws IOException {
        CLIMain.saveContract(contract, fileName, false, true);
    }

    public static List<Wallet> findWallets(String path) {
        return Wallet.determineWallets(new ArrayList<Contract>(CLIMain.findContracts(path).values()));
    }

    public static HashMap<String, Contract> findContracts(String path) {
        return CLIMain.findContracts(path, true);
    }

    public static HashMap<String, Contract> findContracts(String path, Boolean recursively) {
        HashMap<String, Contract> foundContracts = new HashMap<String, Contract>();
        ArrayList<File> foundContractFiles = new ArrayList<File>();
        File pathFile = new File(path);
        if (pathFile.exists()) {
            CLIMain.fillWithContractsFiles(foundContractFiles, path, recursively);
            for (File file : foundContractFiles) {
                try {
                    Contract contract = CLIMain.loadContract(file.getAbsolutePath());
                    foundContracts.put(file.getAbsolutePath(), contract);
                }
                catch (RuntimeException e) {
                    CLIMain.addError(Errors.FAILURE.name(), file.getAbsolutePath(), e.getMessage());
                }
                catch (IOException e) {
                    CLIMain.addError(Errors.FAILURE.name(), file.getAbsolutePath(), e.getMessage());
                }
            }
        } else {
            CLIMain.addError(Errors.NOT_FOUND.name(), path, "Path " + path + " does not exist");
        }
        return foundContracts;
    }

    public static List<File> findFiles(String path, Boolean recursively) {
        ArrayList<File> foundContractFiles = new ArrayList<File>();
        File pathFile = new File(path);
        if (pathFile.exists()) {
            CLIMain.fillWithContractsFiles(foundContractFiles, path, recursively);
        } else {
            CLIMain.addError(Errors.NOT_FOUND.name(), path, "Path " + path + " does not exist");
        }
        return foundContractFiles;
    }

    public static Contract downloadContract(String url) {
        CLIMain.report("downloading from " + url);
        return null;
    }

    public static Parcel revokeContract(Contract contract, Contract tu, int amount, Set<PrivateKey> tuKeys, boolean withTestPayment, PrivateKey ... key) throws IOException {
        CLIMain.report("keys num: " + key.length);
        Contract tc = ContractsService.createRevocation(contract, key);
        Parcel parcel = CLIMain.registerContract(tc, tu, amount, tuKeys, withTestPayment, 0);
        return parcel;
    }

    @Deprecated
    public static Contract revokeContract(Contract contract, PrivateKey ... key) throws IOException {
        CLIMain.report("keys num: " + key.length);
        Contract tc = ContractsService.createRevocation(contract, key);
        CLIMain.registerContract(tc, 0, true);
        return tc;
    }

    @Deprecated
    public static void registerContract(Contract contract, int waitTime, Boolean fromPackedTransaction) throws IOException {
        Collection errors = contract.getErrors();
        if (errors.size() > 0) {
            CLIMain.report("contract has errors and can't be submitted for registration");
            CLIMain.report("contract id: " + contract.getId().toBase64String());
            CLIMain.addErrors((List<ErrorRecord>)errors);
        } else {
            ItemResult r = fromPackedTransaction != false ? CLIMain.getClientNetwork().register(contract.getPackedTransaction(), waitTime) : CLIMain.getClientNetwork().register(contract.getLastSealedBinary(), waitTime);
            CLIMain.report("submitted with result:");
            CLIMain.report(r.toString());
        }
    }

    public static Parcel registerContract(Contract contract, Contract tu, int amount, Set<PrivateKey> tuKeys, boolean withTestPayment, int waitTime) throws IOException {
        Collection errors = contract.getErrors();
        if (errors.size() <= 0) {
            Parcel parcel = ContractsService.createParcel(contract, tu, amount, tuKeys, withTestPayment);
            CLIMain.getClientNetwork().registerParcel(parcel.pack(), waitTime);
            ItemResult r = CLIMain.getClientNetwork().check(contract.getId());
            CLIMain.report("paid contract " + contract.getId() + " submitted with result: " + r.toString());
            CLIMain.report("payment was " + tu.getId());
            CLIMain.report("payment became " + parcel.getPaymentContract().getId());
            CLIMain.report("payment rev " + parcel.getPaymentContract().getRevoking().get(0).getId());
            return parcel;
        }
        CLIMain.report("contract has errors and can't be submitted for registration");
        CLIMain.report("contract id: " + contract.getId().toBase64String());
        CLIMain.addErrors((List<ErrorRecord>)errors);
        return null;
    }

    public static void registerContract(Contract contract) throws IOException {
        CLIMain.registerContract(contract, 0, true);
    }

    public static void registerContract(Contract contract, int waitTime) throws IOException {
        CLIMain.registerContract(contract, waitTime, true);
    }

    private static void fillWithContractsFiles(List<File> foundContractFiles, String path, Boolean recursively) {
        File pathFile = new File(path);
        if (pathFile.exists()) {
            ContractFilesFilter filter = new ContractFilesFilter();
            DirsFilter dirsFilter = new DirsFilter();
            if (pathFile.isDirectory()) {
                File[] foundFiles = pathFile.listFiles(filter);
                foundContractFiles.addAll(Arrays.asList(foundFiles));
                if (recursively.booleanValue()) {
                    File[] foundDirs;
                    for (File file : foundDirs = pathFile.listFiles(dirsFilter)) {
                        CLIMain.fillWithContractsFiles(foundContractFiles, file.getPath(), true);
                    }
                }
            } else {
                foundContractFiles.add(pathFile);
            }
        }
    }

    private static void printWallets(List<Wallet> wallets) {
        reporter.message("");
        ArrayList<Contract> foundContracts = new ArrayList<Contract>();
        for (Wallet wallet : wallets) {
            foundContracts.addAll(wallet.getContracts());
            reporter.message("found wallet: " + wallet.toString());
            reporter.verbose("");
            HashMap<String, Integer> balance = new HashMap<String, Integer>();
            for (Contract contract : wallet.getContracts()) {
                try {
                    Integer numcoins = contract.getStateData().getIntOrThrow(AMOUNT_FIELD_NAME);
                    String currency = (String)contract.getDefinition().getData().getOrThrow("currency_code");
                    if (balance.containsKey(currency)) {
                        balance.replace(currency, (Integer)balance.get(currency) + numcoins);
                    } else {
                        balance.put(currency, numcoins);
                    }
                    reporter.verbose("found coins: " + contract.getDefinition().getData().getOrThrow("name") + " -> " + numcoins + " (" + currency + ") ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            reporter.verbose("");
            reporter.message("total in the wallet: ");
            for (String c : balance.keySet()) {
                reporter.message(balance.get(c) + " (" + c + ") ");
            }
        }
    }

    private static void printContracts(HashMap<String, Contract> contracts) {
        reporter.verbose("");
        reporter.verbose("found contracts list: ");
        reporter.verbose("");
        for (String key : contracts.keySet()) {
            try {
                reporter.verbose(key + ": contract created at " + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(contracts.get(key).getCreatedAt()) + ": " + contracts.get(key).getDefinition().getData().getString("description"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printProcessingCost(Contract contract) {
        CLIMain.report("Contract processing cost is " + contract.getProcessedCostTU() + " TU");
    }

    private static void finish() {
        try {
            CLIMain.saveSession();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new Finished();
    }

    private static ContractFileTypes getFileType(String source) {
        String extension = "";
        int i = source.lastIndexOf(46);
        if (i > 0) {
            extension = source.substring(i + 1);
        }
        if ("unicon".equals(extension = extension.toLowerCase())) {
            return ContractFileTypes.BINARY;
        }
        if ("yaml".equals(extension) || "yml".equals(extension)) {
            return ContractFileTypes.YAML;
        }
        if ("json".equals(extension)) {
            return ContractFileTypes.JSON;
        }
        if ("xml".equals(extension)) {
            return ContractFileTypes.XML;
        }
        return ContractFileTypes.UNKNOWN;
    }

    private static void report(String message) {
        reporter.message(message);
    }

    private static void addError(String code, String object, String message) {
        reporter.error(code, object, message);
    }

    private static void usage(String text) {
        boolean error = false;
        PrintStream out = System.out;
        if (text != null) {
            out = System.err;
            error = true;
        }
        out.println("\nUniversa client tool, v. 3.4.2-private-alpha\n");
        if (options == null) {
            System.err.println("error while parsing command line");
        } else {
            Integer columns = (Integer)options.valueOf("term-width");
            if (columns == null) {
                columns = 120;
            }
            if (text != null) {
                out.println("ERROR: " + text + "\n");
            }
            try {
                parser.formatHelpWith(new BuiltinHelpFormatter(columns, 2));
                parser.printHelpOn(out);
                out.println("\nOnline docs: https://lnd.im/UniClientUserManual\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.exit(100);
    }

    public static void setTestMode() {
        testMode = true;
    }

    public static void setTestRootPath(String rootPath) {
        testRootPath = rootPath;
    }

    public static void setNodeUrl(String url) {
        nodeUrl = url;
        clientNetwork = null;
    }

    public static Reporter getReporter() {
        return reporter;
    }

    public static synchronized ClientNetwork getClientNetwork() throws IOException {
        if (clientNetwork == null) {
            reporter.verbose("ClientNetwork not exist, create one");
            BasicHttpClientSession s = null;
            reporter.verbose("ClientNetwork nodeUrl: " + nodeUrl);
            clientNetwork = nodeUrl != null ? new ClientNetwork(nodeUrl, null, true) : new ClientNetwork(null, true);
            if (CLIMain.clientNetwork.client == null) {
                throw new IOException("failed to connect to to the universa network");
            }
            s = CLIMain.getSession(clientNetwork.getNodeNumber());
            reporter.verbose("Session for " + clientNetwork.getNodeNumber() + " is exist: " + (s != null));
            if (s != null) {
                reporter.verbose("Session id is " + s.getSessionId());
            }
            clientNetwork.start(s);
        }
        if (clientNetwork != null) {
            session = clientNetwork.getSession();
        }
        return clientNetwork;
    }

    public static synchronized Map<String, PrivateKey> keysMap() throws IOException {
        if (keyFiles == null) {
            keyFiles = new HashMap<String, PrivateKey>();
            for (String fileName : keyFileNames) {
                try {
                    PrivateKey pk = PrivateKey.fromPath(Paths.get(fileName, new String[0]));
                    keyFiles.put(fileName, pk);
                }
                catch (IOException e) {
                    CLIMain.addError(Errors.NOT_FOUND.name(), fileName.toString(), "failed to load key file: " + e.getMessage());
                }
            }
        }
        return keyFiles;
    }

    static {
        reporter = new Reporter();
        keyFileNames = new ArrayList<String>();
        prefs = Preferences.userRoot();
    }

    public static enum ContractFileTypes {
        JSON,
        XML,
        YAML,
        BINARY,
        UNKNOWN;

    }

    public static class MapEntryConverterKnownTypes {
        public static final String UNIXTIME = "unixtime";
        public static final String SIMPLE_ROLE = "SimpleRole";
        public static final String KEY_RECORD = "KeyRecord";
        public static final String RSA_PUBLIC_KEY = "RSAPublicKey";
        public static final String REFERENCE = "com.icodici.universa.contract.Reference";
        public static final String ROLE_LINK = "RoleLink";
        public static final String CHANGE_OWNER_PERMISSION = "ChangeOwnerPermission";
        public static final String REVOKE_PERMISSION = "RevokePermission";
        public static final String BINARY = "binary";
    }

    public static class MapEntryConverter
    implements Converter {
        @Override
        public boolean canConvert(Class c) {
            return AbstractMap.class.isAssignableFrom(c);
        }

        @Override
        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            AbstractMap map = (AbstractMap)value;
            String hasType = "";
            for (String key : map.keySet()) {
                if (!"__type".equals(key)) continue;
                hasType = (String)map.get(key);
                break;
            }
            switch (hasType) {
                case "unixtime": {
                    writer.startNode(hasType);
                    ZonedDateTime date = ZonedDateTime.ofInstant(Instant.ofEpochSecond((Long)map.get("seconds")), ZoneOffset.systemDefault());
                    writer.setValue(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss [XXX]").format(date));
                    writer.endNode();
                    break;
                }
                default: {
                    if (this.checkForKnownTypes(hasType).booleanValue()) {
                        writer.startNode(hasType);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        String checkingKey = (String)entry.getKey();
                        Object checkingValue = entry.getValue();
                        if ("__type".equals(checkingKey) && this.checkForKnownTypes(hasType).booleanValue()) continue;
                        if (!Character.isDigit(checkingKey.charAt(0))) {
                            writer.startNode(checkingKey);
                        } else {
                            writer.startNode("__digit_" + checkingKey);
                        }
                        if (checkingValue != null) {
                            if (checkingValue instanceof Integer) {
                                writer.setValue(String.valueOf(checkingValue));
                            } else if (checkingValue instanceof AbstractMap) {
                                context.convertAnother(checkingValue);
                            } else if (checkingValue instanceof List) {
                                writer.addAttribute("isArray", "true");
                                for (Object o : (List)checkingValue) {
                                    writer.startNode("item");
                                    context.convertAnother(o);
                                    writer.endNode();
                                }
                            } else {
                                writer.setValue(checkingValue.toString());
                            }
                        }
                        writer.endNode();
                    }
                    if (!this.checkForKnownTypes(hasType).booleanValue()) break;
                    writer.endNode();
                }
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String checkingKey = reader.getNodeName();
                String checkingValue = reader.getValue();
                String isArray = reader.getAttribute("isArray");
                try {
                    String hasType = checkingKey;
                    if (this.checkForKnownTypes(hasType).booleanValue()) {
                        switch (hasType) {
                            case "unixtime": {
                                map.put("__type", checkingKey);
                                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss [XXX]");
                                ZonedDateTime date = ZonedDateTime.parse(checkingValue, formatter);
                                map.put("seconds", date.toEpochSecond());
                                break;
                            }
                            default: {
                                map.put("__type", checkingKey);
                                map.putAll((AbstractMap)context.convertAnother(checkingValue, AbstractMap.class));
                                break;
                            }
                        }
                    } else {
                        if (checkingKey.length() > 8 && "__digit_".equals(checkingKey.substring(0, 8))) {
                            checkingKey = checkingKey.substring(8, checkingKey.length());
                        }
                        if ("true".equals(isArray)) {
                            ArrayList<Object> list = new ArrayList<Object>();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                list.add(context.convertAnother(reader.getValue(), AbstractMap.class));
                                reader.moveUp();
                            }
                            map.put(checkingKey, list);
                        } else if (reader.hasMoreChildren()) {
                            map.put(checkingKey, context.convertAnother(checkingValue, AbstractMap.class));
                        } else if ("".equals(checkingValue)) {
                            map.put(checkingKey, null);
                        } else {
                            map.put(checkingKey, checkingValue);
                        }
                    }
                }
                catch (Exception e) {
                    map.put(checkingKey, null);
                    e.printStackTrace();
                }
                reader.moveUp();
            }
            return map;
        }

        private Boolean checkForKnownTypes(String type) {
            switch (type) {
                case "unixtime": 
                case "SimpleRole": 
                case "KeyRecord": 
                case "RSAPublicKey": 
                case "com.icodici.universa.contract.Reference": 
                case "RoleLink": 
                case "ChangeOwnerPermission": 
                case "RevokePermission": 
                case "binary": {
                    return true;
                }
            }
            return false;
        }
    }

    static class DirsFilter
    implements FileFilter {
        DirsFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    static class ContractFilesFilter
    implements FileFilter {
        List<String> extensions = Arrays.asList("unicon");

        ContractFilesFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String extension = this.getExtension(pathname);
            for (String unc : this.extensions) {
                if (!unc.equals(extension)) continue;
                return true;
            }
            return false;
        }

        private String getExtension(File pathname) {
            String filename = pathname.getPath();
            int i = filename.lastIndexOf(46);
            if (i > 0 && i < filename.length() - 1) {
                return filename.substring(i + 1).toLowerCase();
            }
            return "";
        }
    }

    public static class Finished
    extends RuntimeException {
    }
}

