/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.client;

import com.icodici.crypto.PrivateKey;
import com.icodici.universa.Errors;
import com.icodici.universa.HashId;
import com.icodici.universa.client.CLIMain;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node2.Node;
import com.icodici.universa.node2.network.BasicHttpClientSession;
import com.icodici.universa.node2.network.Client;
import com.icodici.universa.node2.network.ClientError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.sergeych.tools.Do;
import net.sergeych.tools.Reporter;

public class ClientNetwork {
    static Reporter reporter = CLIMain.getReporter();
    Client client;

    public ClientNetwork(BasicHttpClientSession session) throws IOException {
        this(session, false);
    }

    public ClientNetwork(BasicHttpClientSession session, boolean delayedStart) throws IOException {
        for (int i = 1; i < 10; ++i) {
            try {
                this.client = new Client("http://node-" + Do.randomIntInRange(1, 10) + "-com.universa.io:8080", CLIMain.getPrivateKey(), session, delayedStart);
                break;
            }
            catch (IOException e) {
                reporter.warning("failed to read network from node " + i);
                continue;
            }
        }
        if (this.client == null) {
            throw new IOException("failed to connect to to the universa network");
        }
        reporter.verbose("Read Universa network configuration: " + this.client.size() + " nodes");
        reporter.message("Network version: " + this.client.getVersion());
    }

    public ClientNetwork(String nodeUrl, BasicHttpClientSession session) throws IOException {
        this(nodeUrl, session, false);
    }

    public ClientNetwork(String nodeUrl, BasicHttpClientSession session, boolean delayedStart) throws IOException {
        this.client = new Client(nodeUrl, CLIMain.getPrivateKey(), session, delayedStart);
        if (this.client == null) {
            throw new IOException("failed to connect to to the universa network");
        }
        reporter.verbose("Read Universa network configuration: " + this.client.size() + " nodes");
        reporter.message("Network version: " + this.client.getVersion());
    }

    public ClientNetwork(String nodeUrl, PrivateKey privateKey, BasicHttpClientSession session) throws IOException {
        this.client = new Client(nodeUrl, privateKey, session);
        if (this.client == null) {
            throw new IOException("failed to connect to to the universa network");
        }
        reporter.verbose("Read Universa network configuration: " + this.client.size() + " nodes");
        reporter.message("Network version: " + this.client.getVersion());
    }

    public void start(BasicHttpClientSession session) throws IOException {
        this.client.start(session);
    }

    public ItemResult register(byte[] packedContract) throws ClientError {
        return this.client.register(packedContract, 0L);
    }

    public boolean ping() throws IOException {
        return this.client.ping();
    }

    public ItemResult register(byte[] packedContract, long millisToWait) throws ClientError {
        return this.client.register(packedContract, millisToWait);
    }

    public boolean registerParcel(byte[] packedParcel, long millisToWait) throws ClientError {
        return this.client.registerParcel(packedParcel, millisToWait);
    }

    public ItemResult check(String base64Id) throws ClientError {
        return this.client.getState(HashId.withDigest(base64Id), reporter);
    }

    public ItemResult check(HashId id) throws ClientError {
        return this.client.getState(id, reporter);
    }

    public Node.ParcelProcessingState getParcelProcessingState(HashId id) throws ClientError {
        return this.client.getParcelProcessingState(id);
    }

    public int size() {
        return this.client.size();
    }

    public BasicHttpClientSession getSession() throws IllegalStateException {
        return this.client.getSession();
    }

    public int getNodeNumber() {
        return this.client.getNodeNumber();
    }

    public int checkNetworkState(Reporter reporter) {
        ExecutorService es = Executors.newCachedThreadPool();
        ArrayList<Future> futures = new ArrayList<Future>();
        AtomicInteger okNodes = new AtomicInteger(0);
        List<Client.NodeRecord> nodes = this.client.getNodes();
        int nn = 0;
        while (nn < this.client.size()) {
            int nodeNumber = nn++;
            futures.add(es.submit(() -> {
                String url = ((Client.NodeRecord)nodes.get((int)nodeNumber)).url;
                reporter.verbose("Checking node " + url);
                for (int i = 0; i < 5; ++i) {
                    try {
                        if (this.client.ping(nodeNumber)) {
                            okNodes.getAndIncrement();
                            reporter.verbose("Got an answer from " + url);
                            return;
                        }
                        reporter.message("retry #" + (i + 1) + " on connection failure: " + url);
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                reporter.error(Errors.NOT_READY.name(), url, "failed to connect");
            }));
        }
        futures.forEach(f -> {
            try {
                f.get(4L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                reporter.verbose("node test is timed out");
                f.cancel(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        es.shutdown();
        int n = okNodes.get();
        if ((double)n >= (double)this.client.size() * 0.12) {
            reporter.message("Universa network is active, " + n + " node(s) are reachable");
        } else {
            reporter.error("NOT_READY", "network", "Universa network is temporarily inaccessible, reachable nodes: " + n);
        }
        return n;
    }
}

