/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.KeyAddress;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.Approvable;
import com.icodici.universa.Decimal;
import com.icodici.universa.ErrorRecord;
import com.icodici.universa.Errors;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.AnonymousId;
import com.icodici.universa.contract.ContractDelta;
import com.icodici.universa.contract.ContractsService;
import com.icodici.universa.contract.ExtendedSignature;
import com.icodici.universa.contract.KeyRecord;
import com.icodici.universa.contract.Reference;
import com.icodici.universa.contract.TransactionPack;
import com.icodici.universa.contract.permissions.ChangeNumberPermission;
import com.icodici.universa.contract.permissions.ChangeOwnerPermission;
import com.icodici.universa.contract.permissions.ModifyDataPermission;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.permissions.RevokePermission;
import com.icodici.universa.contract.permissions.SplitJoinPermission;
import com.icodici.universa.contract.roles.ListRole;
import com.icodici.universa.contract.roles.Role;
import com.icodici.universa.contract.roles.RoleLink;
import com.icodici.universa.contract.roles.SimpleRole;
import com.icodici.universa.node.ItemResult;
import com.icodici.universa.node2.Config;
import com.icodici.universa.node2.Quantiser;
import java.io.FileReader;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.BossBiMapper;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.boss.Boss;
import net.sergeych.collections.Multimap;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import net.sergeych.utils.Bytes;
import net.sergeych.utils.Ut;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.yaml.snakeyaml.Yaml;

@BiType(name="UniversaContract")
public class Contract
implements Approvable,
BiSerializable,
Cloneable {
    private static final int MAX_API_LEVEL = 3;
    private final Set<Contract> revokingItems = new HashSet<Contract>();
    private final Set<Contract> newItems = new HashSet<Contract>();
    private final Map<String, Role> roles = new HashMap<String, Role>();
    private Definition definition;
    private State state;
    private Transactional transactional;
    private byte[] sealedBinary;
    private int apiLevel = 3;
    private Context context = null;
    private boolean shouldBeTU = false;
    private boolean limitedForTestnet = false;
    private boolean isSuitableForTestnet = false;
    private boolean isSealed = false;
    private final Map<PublicKey, ExtendedSignature> sealedByKeys = new HashMap<PublicKey, ExtendedSignature>();
    private Set<PrivateKey> keysToSignWith = new HashSet<PrivateKey>();
    private HashMap<String, Reference> references = new HashMap();
    private HashId id;
    private TransactionPack transactionPack;
    private Quantiser quantiser = new Quantiser();
    private static int testQuantaLimit = -1;
    private final List<ErrorRecord> errors = new ArrayList<ErrorRecord>();
    private Set<String> permissionIds;
    private Multimap<String, Permission> permissions = new Multimap();
    private static Pattern relativeTimePattern = Pattern.compile("(\\d+) (hour|min|day)\\w*$", 2);

    public Quantiser getQuantiser() {
        return this.quantiser;
    }

    public static int getTestQuantaLimit() {
        return testQuantaLimit;
    }

    public static void setTestQuantaLimit(int testQuantaLimit) {
        Contract.testQuantaLimit = testQuantaLimit;
    }

    public Contract(byte[] sealed, @NonNull TransactionPack pack) throws IOException {
        this.quantiser.reset(testQuantaLimit);
        this.sealedBinary = sealed;
        this.transactionPack = pack;
        Binder data = Boss.unpack(sealed);
        if (!data.getStringOrThrow("type").equals("unicapsule")) {
            throw new IllegalArgumentException("wrong object type, unicapsule required");
        }
        this.apiLevel = data.getIntOrThrow("version");
        byte[] contractBytes = data.getBinaryOrThrow("data");
        Binder payload = (Binder)Boss.load(contractBytes, null);
        BiDeserializer bm = BossBiMapper.newDeserializer();
        this.deserialize(payload.getBinderOrThrow("contract"), bm);
        if (this.apiLevel < 3) {
            Contract c;
            for (Object packed : payload.getList("revoking", Collections.EMPTY_LIST)) {
                c = new Contract(((Bytes)packed).toArray(), pack);
                this.revokingItems.add(c);
                pack.addSubItem(c);
            }
            for (Object packed : payload.getList("new", Collections.EMPTY_LIST)) {
                c = new Contract(((Bytes)packed).toArray(), pack);
                this.newItems.add(c);
                pack.addSubItem(c);
            }
        } else {
            Object hid;
            for (Binder b : payload.getList("revoking", Collections.EMPTY_LIST)) {
                hid = HashId.withDigest(b.getBinaryOrThrow("composite3"));
                Contract r = pack.getSubItem((HashId)hid);
                if (r != null) {
                    this.revokingItems.add(r);
                    continue;
                }
                this.addError(Errors.BAD_REVOKE, "Revoking item was not found in the transaction pack");
            }
            for (Binder b : payload.getList("new", Collections.EMPTY_LIST)) {
                hid = HashId.withDigest(b.getBinaryOrThrow("composite3"));
                Contract n = pack.getSubItem((HashId)hid);
                if (n != null) {
                    this.newItems.add(n);
                    continue;
                }
                this.addError(Errors.BAD_NEW_ITEM, "New item was not found in the transaction pack");
            }
        }
        this.getContext();
        if (this.getSiblings().size() > 1) {
            this.newItems.forEach(i -> {
                i.context = this.context;
            });
        }
        if (this.transactional != null && this.transactional.references != null) {
            for (Reference ref : this.transactional.references) {
                ref.setContract(this);
                this.references.put(ref.name, ref);
            }
        }
        if (this.definition != null && this.definition.references != null) {
            for (Reference ref : this.definition.references) {
                ref.setContract(this);
                this.references.put(ref.name, ref);
            }
        }
        if (this.state != null && this.state.references != null) {
            for (Reference ref : this.state.references) {
                ref.setContract(this);
                this.references.put(ref.name, ref);
            }
        }
        for (Reference ref : this.getReferences().values()) {
            for (Contract c : pack.getReferencedItems().values()) {
                if (!ref.isMatchingWith(c, pack.getReferencedItems().values())) continue;
                ref.addMatchingItem(c);
            }
        }
        HashMap keys = new HashMap();
        this.roles.values().forEach(role -> {
            role.getKeys().forEach(key -> keys.put(ExtendedSignature.keyId(key), key));
            role.getAnonymousIds().forEach(anonId -> this.transactionPack.getKeysForPack().forEach(key -> {
                try {
                    if (key.matchAnonymousId(anonId.getBytes())) {
                        keys.put(ExtendedSignature.keyId(key), key);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
            role.getKeyAddresses().forEach(keyAddr -> this.transactionPack.getKeysForPack().forEach(key -> {
                try {
                    if (key.isMatchingKeyAddress((KeyAddress)keyAddr)) {
                        keys.put(ExtendedSignature.keyId(key), key);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
        });
        for (Object signature : (List)data.getOrThrow("signatures")) {
            byte[] s = ((Bytes)signature).toArray();
            Bytes keyId = ExtendedSignature.extractKeyId(s);
            PublicKey key = (PublicKey)keys.get(keyId);
            if (key == null) continue;
            this.verifySignatureQuantized(key);
            ExtendedSignature es = ExtendedSignature.verify(key, s, contractBytes);
            if (es != null) {
                this.sealedByKeys.put(key, es);
                continue;
            }
            this.addError(Errors.BAD_SIGNATURE, "keytag:" + key.info().getBase64Tag(), "the signature is broken");
        }
    }

    public Contract(byte[] data) throws IOException {
        this(data, new TransactionPack());
    }

    public Contract(byte[] sealed, Binder data, TransactionPack pack) throws IOException {
        Object c;
        this.quantiser.reset(testQuantaLimit);
        this.sealedBinary = sealed;
        if (!data.getStringOrThrow("type").equals("unicapsule")) {
            throw new IllegalArgumentException("wrong object type, unicapsule required");
        }
        int v = data.getIntOrThrow("version");
        if (v > 2) {
            throw new IllegalArgumentException("This constructor requires version 2, got version " + v);
        }
        byte[] contractBytes = data.getBinaryOrThrow("data");
        Binder payload = (Binder)Boss.load(contractBytes, null);
        BiDeserializer bm = BossBiMapper.newDeserializer();
        this.deserialize(payload.getBinderOrThrow("contract"), bm);
        for (Object r : payload.getList("revoking", Collections.EMPTY_LIST)) {
            c = new Contract(((Bytes)r).toArray(), pack);
            this.revokingItems.add((Contract)c);
            pack.addSubItem((Contract)c);
        }
        for (Object r : payload.getList("new", Collections.EMPTY_LIST)) {
            c = new Contract(((Bytes)r).toArray(), pack);
            this.newItems.add((Contract)c);
            pack.addSubItem((Contract)c);
        }
        this.getContext();
        if (this.getSiblings().size() > 1) {
            this.newItems.forEach(i -> {
                i.context = this.context;
            });
        }
        if (this.transactional != null && this.transactional.references != null) {
            for (Reference ref : this.transactional.references) {
                ref.setContract(this);
                this.references.put(ref.name, ref);
            }
        }
        if (this.definition != null && this.definition.references != null) {
            for (Reference ref : this.definition.references) {
                ref.setContract(this);
                this.references.put(ref.name, ref);
            }
        }
        if (this.state != null && this.state.references != null) {
            for (Reference ref : this.state.references) {
                ref.setContract(this);
                this.references.put(ref.name, ref);
            }
        }
        for (Reference ref : this.getReferences().values()) {
            for (Contract c2 : pack.getReferencedItems().values()) {
                if (!ref.isMatchingWith(c2, pack.getReferencedItems().values())) continue;
                ref.addMatchingItem(c2);
            }
        }
        HashMap keys = new HashMap();
        this.roles.values().forEach(role -> {
            role.getKeys().forEach(key -> keys.put(ExtendedSignature.keyId(key), key));
            role.getAnonymousIds().forEach(anonId -> this.transactionPack.getKeysForPack().forEach(key -> {
                try {
                    if (key.matchAnonymousId(anonId.getBytes())) {
                        keys.put(ExtendedSignature.keyId(key), key);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
            role.getKeyAddresses().forEach(keyAddr -> this.transactionPack.getKeysForPack().forEach(key -> {
                try {
                    if (key.isMatchingKeyAddress((KeyAddress)keyAddr)) {
                        keys.put(ExtendedSignature.keyId(key), key);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
        });
        for (Object signature : (List)data.getOrThrow("signatures")) {
            byte[] s = ((Bytes)signature).toArray();
            Bytes keyId = ExtendedSignature.extractKeyId(s);
            PublicKey key = (PublicKey)keys.get(keyId);
            if (key == null) continue;
            this.verifySignatureQuantized(key);
            ExtendedSignature es = ExtendedSignature.verify(key, s, contractBytes);
            if (es != null) {
                this.sealedByKeys.put(key, es);
                continue;
            }
            this.addError(Errors.BAD_SIGNATURE, "keytag:" + key.info().getBase64Tag(), "the signature is broken");
        }
    }

    public Contract() {
        this.quantiser.reset(testQuantaLimit);
        this.definition = new Definition();
        this.state = new State();
    }

    public Contract(PrivateKey key) {
        this();
        this.setExpiresAt(ZonedDateTime.now().plusDays(90L));
        Role r = this.setIssuerKeys(key.getPublicKey());
        this.registerRole(new RoleLink("owner", "issuer"));
        this.registerRole(new RoleLink("creator", "issuer"));
        this.addPermission(new ChangeOwnerPermission(r));
        this.addSignerKey(key);
    }

    public List<ErrorRecord> getErrors() {
        return this.errors;
    }

    private Contract initializeWithDsl(Binder root) throws EncryptionError {
        this.apiLevel = root.getIntOrThrow("api_level");
        this.definition = new Definition().initializeWithDsl(root.getBinder("definition"));
        this.state = new State().initializeWithDsl(root.getBinder("state"));
        this.definition.scanDslPermissions();
        return this;
    }

    public static Contract fromDslFile(String fileName) throws IOException {
        Yaml yaml = new Yaml();
        try (FileReader r = new FileReader(fileName);){
            Binder binder = Binder.from(DefaultBiMapper.deserialize((Map)yaml.load(r)));
            Contract contract = new Contract().initializeWithDsl(binder);
            return contract;
        }
    }

    public State getState() {
        return this.state;
    }

    public Transactional getTransactional() {
        return this.transactional;
    }

    public int getApiLevel() {
        return this.apiLevel;
    }

    public void setApiLevel(int apiLevel) {
        this.apiLevel = apiLevel;
    }

    @Override
    public HashMap<String, Reference> getReferences() {
        return this.references;
    }

    @Override
    public Set<Approvable> getReferencedItems() {
        HashSet<Approvable> referencedItems = new HashSet<Approvable>();
        if (this.definition != null && this.definition.getReferences() != null) {
            for (Reference r : this.definition.getReferences()) {
                referencedItems.addAll(r.matchingItems);
            }
        }
        if (this.state != null && this.state.getReferences() != null) {
            for (Reference r : this.state.getReferences()) {
                referencedItems.addAll(r.matchingItems);
            }
        }
        return referencedItems;
    }

    @Override
    public Set<Approvable> getRevokingItems() {
        return this.revokingItems;
    }

    @Override
    public Set<Approvable> getNewItems() {
        return this.newItems;
    }

    public List<Contract> getAllContractInTree() {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        contracts.add(this);
        for (Contract contract : this.getNew()) {
            contracts.addAll(contract.getAllContractInTree());
        }
        for (Contract contract : this.getRevoking()) {
            contracts.addAll(contract.getAllContractInTree());
        }
        return contracts;
    }

    @Override
    public boolean check(String prefix) throws Quantiser.QuantiserException {
        return this.check(prefix, null);
    }

    private boolean check(String prefix, List<Contract> contractsTree) throws Quantiser.QuantiserException {
        if (contractsTree == null) {
            contractsTree = this.getAllContractInTree();
        }
        this.quantiser.reset(this.quantiser.getQuantaLimit());
        for (PublicKey key : this.sealedByKeys.keySet()) {
            if (key == null) continue;
            this.verifySignatureQuantized(key);
        }
        this.quantiser.addWorkCost(Quantiser.QuantiserProcesses.PRICE_REGISTER_VERSION);
        for (Contract r : this.revokingItems) {
            for (PublicKey key : r.sealedByKeys.keySet()) {
                if (key == null) continue;
                this.verifySignatureQuantized(key);
            }
            this.quantiser.addWorkCost(Quantiser.QuantiserProcesses.PRICE_REVOKE_VERSION);
        }
        for (int i = 0; i < this.getReferences().size(); ++i) {
            this.quantiser.addWorkCost(Quantiser.QuantiserProcesses.PRICE_CHECK_REFERENCED_VERSION);
        }
        try {
            this.basicCheck();
            if (this.state.origin == null) {
                this.checkRootContract();
            } else {
                this.checkChangedContract();
            }
        }
        catch (Quantiser.QuantiserException e2) {
            throw e2;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            this.addError(Errors.FAILED_CHECK, prefix, e3.toString());
        }
        int index = 0;
        for (Contract c : this.newItems) {
            String p = prefix + "new[" + index + "].";
            this.checkSubItemQuantized(c, p, contractsTree);
            if (!c.isOk()) {
                c.errors.forEach(e -> {
                    String name = e.getObjectName();
                    name = name == null ? p : p + name;
                    this.addError(e.getError(), name, e.getMessage());
                });
            }
            ++index;
        }
        this.checkDupesCreation();
        this.checkReferencedItems(contractsTree);
        for (Contract r : this.revokingItems) {
            r.errors.clear();
            r.checkReferencedItems(contractsTree);
            if (r.isOk()) continue;
            r.errors.forEach(e -> {
                String name = e.getObjectName();
                this.addError(e.getError(), name, e.getMessage());
            });
        }
        this.checkTestPaymentLimitations();
        return this.errors.size() == 0;
    }

    private boolean checkReferencedItems(List<Contract> neighbourContracts) throws Quantiser.QuantiserException {
        if (this.getReferences().size() == 0) {
            return true;
        }
        boolean allRefs_check = true;
        for (Reference rm : this.getReferences().values()) {
            boolean rm_check = false;
            if (rm.type == 1) {
                for (int j = 0; j < neighbourContracts.size(); ++j) {
                    Contract neighbour = neighbourContracts.get(j);
                    if ((rm.transactional_id == null || neighbour.transactional == null || !rm.transactional_id.equals(neighbour.transactional.id)) && (rm.contract_id == null || !rm.contract_id.equals(neighbour.id)) || !this.checkOneReference(rm, neighbour)) continue;
                    rm_check = true;
                }
            } else if (rm.type == 2) {
                rm_check = rm.isValid();
            }
            if (rm_check) continue;
            allRefs_check = false;
            this.addError(Errors.FAILED_CHECK, "checkReferencedItems for contract (hashId=" + this.getId().toString() + "): false");
        }
        return allRefs_check;
    }

    private boolean checkOneReference(Reference rm, Contract refContract) throws Quantiser.QuantiserException {
        boolean res = true;
        if (rm.type != 2 && rm.type == 1) {
            if (rm.transactional_id == null || refContract.transactional == null || refContract.transactional.getId() == null || "".equals(rm.transactional_id) || "".equals(refContract.transactional.id)) {
                res = false;
                this.addError(Errors.BAD_REF, "transactional is missing");
            } else if (rm.transactional_id != null && refContract.transactional == null) {
                res = false;
                this.addError(Errors.BAD_REF, "transactional not found");
            } else if (!rm.transactional_id.equals(refContract.transactional.id)) {
                res = false;
                this.addError(Errors.BAD_REF, "transactional_id mismatch");
            }
        }
        if (rm.contract_id != null && !rm.contract_id.equals(refContract.id)) {
            res = false;
            this.addError(Errors.BAD_REF, "contract_id mismatch");
        }
        if (rm.origin != null && !rm.origin.equals(refContract.getOrigin())) {
            res = false;
            this.addError(Errors.BAD_REF, "origin mismatch");
        }
        for (Role refRole : rm.signed_by) {
            if (refContract.isSignedBy(refRole)) continue;
            res = false;
            this.addError(Errors.BAD_SIGNATURE, "fingerprint mismatch");
        }
        return res;
    }

    private boolean checkTestPaymentLimitations() {
        boolean res = true;
        if (!this.shouldBeTU()) {
            this.isSuitableForTestnet = true;
            for (PublicKey key : this.sealedByKeys.keySet()) {
                if (key == null || key.getBitStrength() == 2048) continue;
                this.isSuitableForTestnet = false;
                if (!this.isLimitedForTestnet()) continue;
                res = false;
                this.addError(Errors.FORBIDDEN, "Only 2048 keys is allowed in the test payment mode.");
            }
            ZonedDateTime expirationLimit = ZonedDateTime.now().plusMonths(Config.maxExpirationMonthsInTestMode);
            if (this.getExpiresAt().isAfter(expirationLimit)) {
                this.isSuitableForTestnet = false;
                if (this.isLimitedForTestnet()) {
                    res = false;
                    this.addError(Errors.FORBIDDEN, "Contracts with expiration date father then " + Config.maxExpirationMonthsInTestMode + " months from now is not allowed in the test payment mode.");
                }
            }
            for (Approvable ni : this.getNewItems()) {
                if (!ni.getExpiresAt().isAfter(expirationLimit)) continue;
                this.isSuitableForTestnet = false;
                if (!this.isLimitedForTestnet()) continue;
                res = false;
                this.addError(Errors.FORBIDDEN, "New items with expiration date father then " + Config.maxExpirationMonthsInTestMode + " months from now is not allowed in the test payment mode.");
            }
            for (Approvable ri : this.getRevokingItems()) {
                if (!ri.getExpiresAt().isAfter(expirationLimit)) continue;
                this.isSuitableForTestnet = false;
                if (!this.isLimitedForTestnet()) continue;
                res = false;
                this.addError(Errors.FORBIDDEN, "Revoking items with expiration date father then " + Config.maxExpirationMonthsInTestMode + " months from now is not allowed in the test payment mode.");
            }
            if (this.getProcessedCostTU() > Config.maxCostTUInTestMode) {
                this.isSuitableForTestnet = false;
                if (this.isLimitedForTestnet()) {
                    res = false;
                    this.addError(Errors.FORBIDDEN, "Contract can cost not more then " + Config.maxCostTUInTestMode + " TU in the test payment mode.");
                }
            }
        }
        return res;
    }

    @Override
    public boolean paymentCheck(PublicKey issuerKey) throws Quantiser.QuantiserException {
        Object o;
        boolean res = true;
        boolean hasTestTU = this.getStateData().get("test_transaction_units") != null;
        int transaction_units = this.getStateData().getInt("transaction_units", -1);
        int test_transaction_units = this.getStateData().getInt("test_transaction_units", -1);
        if (transaction_units < 0) {
            res = false;
            this.addError(Errors.BAD_VALUE, "transaction_units < 0");
        }
        if ((o = this.getStateData().get("transaction_units")) == null || o.getClass() != Integer.class) {
            res = false;
            this.addError(Errors.BAD_VALUE, "transaction_units name/type mismatch");
        }
        if (hasTestTU) {
            o = this.getStateData().get("test_transaction_units");
            if (o == null || o.getClass() != Integer.class) {
                res = false;
                this.addError(Errors.BAD_VALUE, "test_transaction_units name/type mismatch");
            }
            if (test_transaction_units < 0) {
                res = false;
                this.addError(Errors.BAD_VALUE, "test_transaction_units < 0");
            }
            if (this.state.origin != null) {
                this.getContext();
                Contract parent = this.getSiblings().size() > 1 ? this.getContext().base : this.getRevokingItem(this.getParent());
                int was_transaction_units = parent.getStateData().getInt("transaction_units", -1);
                int was_test_transaction_units = parent.getStateData().getInt("test_transaction_units", -1);
                if (transaction_units != was_transaction_units && test_transaction_units != was_test_transaction_units) {
                    res = false;
                    this.addError(Errors.BAD_VALUE, "transaction_units and test_transaction_units can not be spent both");
                }
            } else if (this.isLimitedForTestnet()) {
                res = false;
                this.addError(Errors.BAD_VALUE, "Payment contract has not origin but it is not allowed for parcel. Use standalone register for payment contract.");
            }
        } else if (this.isLimitedForTestnet()) {
            res = false;
            this.addError(Errors.BAD_VALUE, "Payment contract that marked as for testnet has not test_transaction_units.");
        }
        if (!this.isPermitted("decrement_permission", this.getOwner())) {
            res = false;
            this.addError(Errors.BAD_VALUE, "decrement_permission is missing");
        }
        if (!this.getIssuer().getKeys().equals(new HashSet<PublicKey>(Arrays.asList(issuerKey)))) {
            res = false;
            this.addError(Errors.BAD_VALUE, "issuerKeys is not valid");
        }
        if (!res) {
            return res;
        }
        if (this.newItems.size() > 0) {
            res = false;
            this.addError(Errors.BAD_NEW_ITEM, "payment contract can not have any new items");
        }
        if (!res) {
            return res;
        }
        if (this.getRevision() != 1 || this.getParent() != null) {
            if (this.getOrigin().equals(this.getId())) {
                res = false;
                this.addError(Errors.BAD_VALUE, "can't origin itself");
            }
            if (this.getRevision() <= 1) {
                res = false;
                this.addError(Errors.BAD_VALUE, "revision must be greater than 1");
            }
            if (this.revokingItems.size() != 1) {
                res = false;
                this.addError(Errors.BAD_REVOKE, "revokingItems.size != 1");
            } else {
                Contract revoking = this.revokingItems.iterator().next();
                if (!revoking.getOrigin().equals(this.getOrigin())) {
                    res = false;
                    this.addError(Errors.BAD_REVOKE, "origin mismatch");
                }
            }
        }
        if (!res) {
            return res;
        }
        res = this.check("");
        return res;
    }

    public int getProcessedCost() {
        return this.quantiser.getQuantaSum();
    }

    public int getProcessedCostTU() {
        return (int)Math.floor(this.quantiser.getQuantaSum() / Quantiser.quantaPerUTN) + 1;
    }

    private void checkDupesCreation() {
        if (this.newItems.isEmpty()) {
            return;
        }
        HashSet<String> revisionIds = new HashSet<String>();
        revisionIds.add(this.getRevisionId());
        int count = 0;
        for (Contract c : this.newItems) {
            String i = c.getRevisionId();
            if (revisionIds.contains(i)) {
                this.addError(Errors.BAD_VALUE, "new[" + count + "]", "duplicated revision id: " + i);
            } else {
                revisionIds.add(i);
            }
            ++count;
        }
    }

    public String getRevisionId() {
        String parentId = this.getParent() == null ? "" : this.getParent().toBase64String() + "/";
        StringBuilder sb = new StringBuilder(this.getOrigin().toBase64String() + "/" + parentId + this.state.revision);
        if (this.state.branchId != null) {
            sb.append("/" + this.state.branchId.toString());
        }
        return sb.toString();
    }

    private void checkRootContract() throws Quantiser.QuantiserException {
        Role issuer = this.getRole("issuer");
        if (issuer == null || !issuer.isValid()) {
            this.addError(Errors.BAD_VALUE, "definition.issuer", "missing issuer");
            return;
        }
        Role createdBy = this.getRole("creator");
        if (createdBy == null || !createdBy.isValid()) {
            this.addError(Errors.BAD_VALUE, "state.created_by", "invalid creator");
            return;
        }
        if (issuer != null && !issuer.equalKeys(createdBy)) {
            this.addError(Errors.ISSUER_MUST_CREATE, "state.created_by");
        }
        if (this.state.revision != 1) {
            this.addError(Errors.BAD_VALUE, "state.revision", "must be 1 in a root contract");
        }
        if (this.state.createdAt == null) {
            this.state.createdAt = this.definition.createdAt;
        } else if (!this.state.createdAt.equals(this.definition.createdAt)) {
            this.addError(Errors.BAD_VALUE, "state.created_at", "invalid");
        }
        if (this.state.origin != null) {
            this.addError(Errors.BAD_VALUE, "state.origin", "must be empty in a root contract");
        }
        this.checkRootDependencies();
    }

    private void checkRootDependencies() throws Quantiser.QuantiserException {
        for (Approvable approvable : this.revokingItems) {
            Contract rc;
            if (!(approvable instanceof Contract)) {
                this.addError(Errors.BAD_REF, "revokingItem", "revoking item is not a Contract");
            }
            if ((rc = (Contract)approvable).isPermitted("revoke", this.getIssuer())) continue;
            this.addError(Errors.FORBIDDEN, "revokingItem", "revocation not permitted for item " + rc.getId());
        }
    }

    @Override
    public void addError(Errors code, String field2, String text) {
        Errors code1 = code;
        String field1 = field2;
        String text1 = text;
        this.errors.add(new ErrorRecord(code1, field1, text1));
    }

    private void checkChangedContract() throws Quantiser.QuantiserException {
        this.getContext();
        Contract parent = this.getSiblings().size() > 1 ? this.getContext().base : this.getRevokingItem(this.getParent());
        if (parent == null) {
            this.addError(Errors.BAD_REF, "parent", "parent contract must be included");
        } else {
            HashId rootId = parent.getRootId();
            if (!rootId.equals(this.getRawOrigin())) {
                this.addError(Errors.BAD_VALUE, "state.origin", "wrong origin, should be root");
            }
            if (!this.getParent().equals(parent.getId())) {
                this.addError(Errors.BAD_VALUE, "state.parent", "illegal parent references");
            }
            ContractDelta delta = new ContractDelta(parent, this);
            delta.check();
        }
    }

    protected HashId getRootId() {
        HashId origin = this.getRawOrigin();
        return origin == null ? this.getId() : origin;
    }

    private Contract getRevokingItem(HashId id) {
        for (Approvable approvable : this.revokingItems) {
            if (!approvable.getId().equals(id) || !(approvable instanceof Contract)) continue;
            return (Contract)approvable;
        }
        return null;
    }

    public void addRevokingItems(Contract ... toRevoke) {
        for (Contract c : toRevoke) {
            this.revokingItems.add(c);
        }
    }

    private void basicCheck() throws Quantiser.QuantiserException {
        Role createdBy;
        Role issuer;
        Role owner;
        boolean definitionExpiredAt;
        if (this.definition.createdAt == null) {
            this.addError(Errors.BAD_VALUE, "definition.created_at", "invalid");
        }
        if (this.state.origin == null && (this.definition.createdAt.isAfter(ZonedDateTime.now()) || this.definition.createdAt.isBefore(this.getEarliestCreationTime()))) {
            this.addError(Errors.BAD_VALUE, "definition.created_at", "invalid");
        }
        boolean stateExpiredAt = this.state.expiresAt == null || this.state.expiresAt.isBefore(ZonedDateTime.now());
        boolean bl = definitionExpiredAt = this.definition.expiresAt == null || this.definition.expiresAt.isBefore(ZonedDateTime.now());
        if (stateExpiredAt && definitionExpiredAt) {
            this.addError(Errors.EXPIRED, "state.expires_at");
        }
        if (this.state.createdAt == null || this.state.createdAt.isAfter(ZonedDateTime.now()) || this.state.createdAt.isBefore(this.getEarliestCreationTime())) {
            this.addError(Errors.BAD_VALUE, "state.created_at");
        }
        if (this.apiLevel < 1) {
            this.addError(Errors.BAD_VALUE, "api_level");
        }
        if ((owner = this.getRole("owner")) == null || !owner.isValid()) {
            this.addError(Errors.MISSING_OWNER, "state.owner");
        }
        if ((issuer = this.getRole("issuer")) == null || !issuer.isValid()) {
            this.addError(Errors.MISSING_ISSUER, "state.issuer");
        }
        if (this.state.revision < 1) {
            this.addError(Errors.BAD_VALUE, "state.revision");
        }
        if ((createdBy = this.getRole("creator")) == null || !createdBy.isValid()) {
            this.addError(Errors.BAD_VALUE, "state.created_by");
        }
        if (!this.isSignedBy(createdBy)) {
            this.addError(Errors.NOT_SIGNED, "", "missing creator signature(s)");
        }
    }

    private boolean isSignedBy(Role role) throws Quantiser.QuantiserException {
        if (role == null) {
            return false;
        }
        if ((role = role.resolve()) == null) {
            return false;
        }
        if (!this.sealedByKeys.isEmpty()) {
            return role.isAllowedForKeys(this.getSealedByKeys());
        }
        return role.isAllowedForKeys(this.getKeysToSignWith().stream().map(k -> k.getPublicKey()).collect(Collectors.toSet()));
    }

    protected @NonNull Role createRole(String roleName, Object roleObject) {
        if (roleObject instanceof CharSequence) {
            return this.registerRole(new RoleLink(roleName, roleObject.toString()));
        }
        if (roleObject instanceof Role) {
            if (((Role)roleObject).getName() != null && ((Role)roleObject).getName().equals(roleName)) {
                return this.registerRole((Role)roleObject);
            }
            return this.registerRole(((Role)roleObject).linkAs(roleName));
        }
        if (roleObject instanceof Map) {
            Role r = Role.fromDslBinder(roleName, Binder.from(roleObject));
            return this.registerRole(r);
        }
        throw new IllegalArgumentException("cant make role from " + roleObject);
    }

    public Role getRole(String roleName) {
        return this.roles.get(roleName);
    }

    public HashId getId(boolean sealAsNeed) {
        if (this.id != null) {
            return this.id;
        }
        if (this.getLastSealedBinary() == null && sealAsNeed) {
            this.seal();
        }
        return this.getId();
    }

    @Override
    public HashId getId() {
        if (this.id == null) {
            if (this.sealedBinary != null) {
                this.id = new HashId(this.sealedBinary);
            } else {
                throw new IllegalStateException("the contract has no binary attached, no Id could be calculated");
            }
        }
        return this.id;
    }

    public Role getIssuer() {
        return this.getRole("issuer");
    }

    @Override
    public ZonedDateTime getCreatedAt() {
        if (this.state.origin != null) {
            return this.state.createdAt;
        }
        return this.definition.createdAt;
    }

    @Override
    public ZonedDateTime getExpiresAt() {
        return this.state.expiresAt != null ? this.state.expiresAt : this.definition.expiresAt;
    }

    public Map<String, Role> getRoles() {
        return this.roles;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public KeyRecord testGetOwner() {
        return this.getRole("owner").getKeyRecords().iterator().next();
    }

    public Role registerRole(Role role) {
        String name = role.getName();
        this.roles.put(name, role);
        role.setContract(this);
        return role;
    }

    public void anonymizeRole(String roleName) {
        Role role = this.roles.get(roleName);
        if (role != null) {
            role.anonymize();
        }
    }

    public boolean isPermitted(String permissionName, KeyRecord keyRecord) throws Quantiser.QuantiserException {
        return this.isPermitted(permissionName, keyRecord.getPublicKey());
    }

    public void addPermission(Permission perm) {
        if (perm.getId() == null) {
            String id;
            if (this.permissionIds == null) {
                this.permissionIds = this.getPermissions().values().stream().map(x -> x.getId()).collect(Collectors.toSet());
            }
            while (this.permissionIds.contains(id = Ut.randomString(6))) {
            }
            this.permissionIds.add(id);
            perm.setId(id);
        }
        this.permissions.put(perm.getName(), perm);
    }

    public boolean isPermitted(String permissionName, PublicKey key) throws Quantiser.QuantiserException {
        Collection<Permission> cp = this.permissions.get(permissionName);
        if (cp != null) {
            for (Permission p : cp) {
                if (!p.isAllowedForKeys(key)) continue;
                this.checkApplicablePermissionQuantized(p);
                return true;
            }
        }
        return false;
    }

    public boolean isPermitted(String permissionName, Collection<PublicKey> keys) throws Quantiser.QuantiserException {
        Collection<Permission> cp = this.permissions.get(permissionName);
        if (cp != null) {
            for (Permission p : cp) {
                if (!p.isAllowedFor(keys, this.getReferences().keySet())) continue;
                this.checkApplicablePermissionQuantized(p);
                return true;
            }
        }
        return false;
    }

    public boolean isPermitted(String permissionName, Role role) throws Quantiser.QuantiserException {
        return this.isPermitted(permissionName, role.getKeys());
    }

    protected void addError(Errors code, String field2) {
        Errors code1 = code;
        String field1 = field2;
        this.errors.add(new ErrorRecord(code1, field1, ""));
    }

    public ChronoZonedDateTime<?> getEarliestCreationTime() {
        return ZonedDateTime.now().minusDays(10L);
    }

    public Set<PublicKey> getSealedByKeys() {
        return this.sealedByKeys.keySet();
    }

    public Set<PrivateKey> getKeysToSignWith() {
        return this.keysToSignWith;
    }

    public void setKeysToSignWith(Set<PrivateKey> keysToSignWith) {
        this.keysToSignWith = keysToSignWith;
    }

    public void addSignerKeyFromFile(String fileName) throws IOException {
        this.addSignerKey(new PrivateKey(Do.read(fileName)));
    }

    public void addSignerKey(PrivateKey privateKey) {
        this.keysToSignWith.add(privateKey);
    }

    public void addSignerKeys(Collection<PrivateKey> keys) {
        keys.forEach(k -> this.keysToSignWith.add((PrivateKey)k));
    }

    public void addReference(Reference reference) {
        if (reference.type == 1) {
            this.transactional.addReference(reference);
        } else if (reference.type == 2) {
            this.definition.addReference(reference);
        }
        this.references.put(reference.name, reference);
    }

    public void addReferenceToState(Reference reference) {
        if (reference.type == 1) {
            this.transactional.addReference(reference);
        } else if (reference.type == 2) {
            this.state.addReference(reference);
        }
        this.references.put(reference.name, reference);
    }

    public boolean isOk() {
        return this.errors.isEmpty();
    }

    public byte[] sealAsV2() {
        byte[] theContract = Boss.pack(BossBiMapper.serialize(Binder.of("contract", this, new Object[]{"revoking", this.revokingItems.stream().map(i -> i.getLastSealedBinary()).collect(Collectors.toList()), "new", this.newItems.stream().map(i -> i.seal()).collect(Collectors.toList())})));
        Binder result = Binder.of("type", "unicapsule", new Object[]{"version", 2, "data", theContract});
        ArrayList signatures = new ArrayList();
        this.keysToSignWith.forEach(key -> signatures.add(ExtendedSignature.sign(key, theContract)));
        result.put("data", theContract);
        result.put("signatures", signatures);
        this.setOwnBinary(result);
        return this.sealedBinary;
    }

    public byte[] seal() {
        Object forPack = BossBiMapper.serialize(Binder.of("contract", this, new Object[]{"revoking", this.revokingItems.stream().map(i -> i.getId()).collect(Collectors.toList()), "new", this.newItems.stream().map(i -> i.getId(true)).collect(Collectors.toList())}));
        byte[] theContract = Boss.pack(forPack);
        Binder result = Binder.of("type", "unicapsule", new Object[]{"version", 3, "data", theContract});
        ArrayList signatures = new ArrayList();
        result.put("data", theContract);
        result.put("signatures", signatures);
        this.setOwnBinary(result);
        this.addSignatureToSeal(this.keysToSignWith);
        return this.sealedBinary;
    }

    public void addSignatureToSeal(PrivateKey privateKey) {
        HashSet<PrivateKey> keys = new HashSet<PrivateKey>();
        keys.add(privateKey);
        this.addSignatureToSeal(keys);
    }

    public void addSignatureToSeal(Set<PrivateKey> privateKeys) {
        if (this.sealedBinary == null) {
            throw new IllegalStateException("failed to add signature: sealed binary does not exist");
        }
        Binder data = Boss.unpack(this.sealedBinary);
        byte[] contractBytes = data.getBinaryOrThrow("data");
        List signatures = data.getListOrThrow("signatures");
        for (PrivateKey key : privateKeys) {
            byte[] signature = ExtendedSignature.sign(key, contractBytes);
            signatures.add(signature);
            data.put("signatures", signatures);
            ExtendedSignature es = ExtendedSignature.verify(key.getPublicKey(), signature, contractBytes);
            if (es == null) continue;
            this.sealedByKeys.put(key.getPublicKey(), es);
        }
        this.setOwnBinary(data);
    }

    public void removeAllSignatures() {
        if (this.sealedBinary == null) {
            throw new IllegalStateException("failed to add signature: sealed binary does not exist");
        }
        Binder data = Boss.unpack(this.sealedBinary);
        ArrayList signatures = new ArrayList();
        data.put("signatures", signatures);
        this.sealedByKeys.clear();
        this.setOwnBinary(data);
    }

    public boolean findSignatureInSeal(PublicKey publicKey) throws Quantiser.QuantiserException {
        if (this.sealedBinary == null) {
            throw new IllegalStateException("failed to create revision");
        }
        Binder data = Boss.unpack(this.sealedBinary);
        byte[] contractBytes = data.getBinaryOrThrow("data");
        List signatures = data.getListOrThrow("signatures");
        for (Bytes s : signatures) {
            this.verifySignatureQuantized(publicKey);
            if (ExtendedSignature.verify(publicKey, s.getData(), contractBytes) == null) continue;
            return true;
        }
        return false;
    }

    public byte[] extractTheContract() {
        if (this.sealedBinary == null) {
            throw new IllegalStateException("failed to create revision");
        }
        Binder data = Boss.unpack(this.sealedBinary);
        byte[] contractBytes = data.getBinaryOrThrow("data");
        return contractBytes;
    }

    public byte[] getLastSealedBinary() {
        return this.sealedBinary;
    }

    private void setOwnBinary(Binder result) {
        this.sealedBinary = Boss.pack(result);
        this.transactionPack = null;
        this.id = HashId.of(this.sealedBinary);
    }

    public Contract createRevision() {
        return this.createRevision((Transactional)null);
    }

    public synchronized Contract createRevision(Transactional transactional) {
        try {
            Contract newRevision = this.copy();
            newRevision.state.revision = this.state.revision + 1;
            newRevision.state.createdAt = ZonedDateTime.ofInstant(Instant.ofEpochSecond(ZonedDateTime.now().toEpochSecond()), ZoneId.systemDefault());
            newRevision.state.parent = this.getId();
            newRevision.state.origin = this.state.revision == 1 ? this.getId() : this.state.origin;
            newRevision.revokingItems.add(this);
            newRevision.transactional = transactional;
            if (newRevision.definition != null && newRevision.definition.references != null) {
                for (Reference ref : newRevision.definition.references) {
                    ref.setContract(newRevision);
                    newRevision.references.put(ref.name, ref);
                }
            }
            if (newRevision.state != null && newRevision.state.references != null) {
                for (Reference ref : newRevision.state.references) {
                    ref.setContract(newRevision);
                    newRevision.references.put(ref.name, ref);
                }
            }
            return newRevision;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create revision", e);
        }
    }

    public int getRevision() {
        return this.state.revision;
    }

    public HashId getParent() {
        return this.state.parent;
    }

    public HashId getRawOrigin() {
        return this.state.origin;
    }

    public HashId getOrigin() {
        HashId o = this.state.origin;
        return o == null ? this.getId() : o;
    }

    public Contract createRevision(PrivateKey ... keys) {
        return this.createRevision((Transactional)null, keys);
    }

    public Contract createRevision(Transactional transactional, PrivateKey ... keys) {
        return this.createRevision(Do.list(keys), transactional);
    }

    public synchronized Contract createRevision(Collection<PrivateKey> keys) {
        return this.createRevision(keys, null);
    }

    public synchronized Contract createRevision(Collection<PrivateKey> keys, Transactional transactional) {
        Contract newRevision = this.createRevision(transactional);
        HashSet<KeyRecord> krs = new HashSet<KeyRecord>();
        keys.forEach(k -> {
            krs.add(new KeyRecord(k.getPublicKey()));
            newRevision.addSignerKey((PrivateKey)k);
        });
        newRevision.setCreator(krs);
        return newRevision;
    }

    public synchronized Contract createRevisionAnonymously(Collection<?> keys) {
        return this.createRevisionAnonymously(keys, null);
    }

    public synchronized Contract createRevisionAnonymously(Collection<?> keys, Transactional transactional) {
        Contract newRevision = this.createRevision(transactional);
        HashSet aids = new HashSet();
        AtomicBoolean returnNull = new AtomicBoolean(false);
        keys.forEach(k -> {
            if (k instanceof AbstractKey) {
                aids.add(AnonymousId.fromBytes(((AbstractKey)k).createAnonymousId()));
            } else if (k instanceof AnonymousId) {
                aids.add((AnonymousId)k);
            } else {
                returnNull.set(true);
            }
        });
        newRevision.setCreatorKeys(aids);
        if (returnNull.get()) {
            return null;
        }
        return newRevision;
    }

    public synchronized Contract createRevisionWithAddress(Collection<?> keys) {
        return this.createRevisionWithAddress(keys, null);
    }

    public synchronized Contract createRevisionWithAddress(Collection<?> keys, Transactional transactional) {
        Contract newRevision = this.createRevision(transactional);
        HashSet aids = new HashSet();
        AtomicBoolean returnNull = new AtomicBoolean(false);
        keys.forEach(k -> {
            if (k instanceof AbstractKey) {
                aids.add(((AbstractKey)k).getPublicKey().getShortAddress());
            } else if (k instanceof KeyAddress) {
                aids.add((KeyAddress)k);
            } else {
                returnNull.set(true);
            }
        });
        newRevision.setCreatorKeys(aids);
        if (returnNull.get()) {
            return null;
        }
        return newRevision;
    }

    public Role setCreator(Collection<KeyRecord> records) {
        return this.setRole("creator", records);
    }

    public Role setCreator(Role role) {
        return this.registerRole(role);
    }

    public @NonNull Role setCreatorKeys(Object ... keys) {
        return this.setRole("creator", Arrays.asList(keys));
    }

    public @NonNull Role setCreatorKeys(Collection<?> keys) {
        return this.setRole("creator", keys);
    }

    public Role getOwner() {
        return this.getRole("owner");
    }

    public @NonNull Role setOwnerKey(Object keyOrRecord) {
        return this.setRole("owner", Do.listOf(keyOrRecord));
    }

    public @NonNull Role setOwnerKeys(Collection<?> keys) {
        return this.setRole("owner", keys);
    }

    public @NonNull Role setOwnerKeys(Object ... keys) {
        return this.setOwnerKeys(Arrays.asList(keys));
    }

    private @NonNull Role setRole(String name, Collection keys) {
        return this.registerRole(new SimpleRole(name, keys));
    }

    public Role getCreator() {
        return this.getRole("creator");
    }

    public Multimap<String, Permission> getPermissions() {
        return this.permissions;
    }

    public Binder getStateData() {
        return this.state.getData();
    }

    public Role setIssuerKeys(Object ... keys) {
        return this.setRole("issuer", Arrays.asList(keys));
    }

    public void setExpiresAt(ZonedDateTime dateTime) {
        this.state.setExpiresAt(dateTime);
    }

    public void getExpiresAt(ZonedDateTime dateTime) {
        this.state.setExpiresAt(dateTime);
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        int l = data.getIntOrThrow("api_level");
        if (l > 3) {
            throw new RuntimeException("contract api level conflict: found " + l + " my level " + this.apiLevel);
        }
        deserializer.withContext(this, () -> {
            if (this.definition == null) {
                this.definition = new Definition();
            }
            this.definition.deserializeWith(data.getBinderOrThrow("definition"), deserializer);
            if (this.state == null) {
                this.state = new State();
            }
            this.state.deserealizeWith(data.getBinderOrThrow("state"), deserializer);
            if (this.transactional == null) {
                this.transactional = new Transactional();
            }
            this.transactional.deserializeWith(data.getBinder("transactional", null), deserializer);
        });
    }

    @Override
    public Binder serialize(BiSerializer s) {
        Binder binder = Binder.of("api_level", (Object)this.apiLevel, new Object[]{"definition", this.definition.serializeWith(s), "state", this.state.serializeWith(s)});
        if (this.transactional != null) {
            binder.set("transactional", this.transactional.serializeWith(s));
        }
        return binder;
    }

    public Contract[] split(int count) {
        if (this.state.getBranchRevision() == this.state.revision) {
            throw new IllegalArgumentException("this revision is already split");
        }
        if (count < 1) {
            throw new IllegalArgumentException("split: count should be > 0");
        }
        this.getContext();
        this.state.setBranchNumber(0);
        Contract[] results = new Contract[count];
        for (int i = 0; i < count; ++i) {
            Contract c = this.copy();
            c.setKeysToSignWith(this.getKeysToSignWith());
            c.getState().setBranchNumber(i + 1);
            c.context = this.context;
            this.context.siblings.add(c);
            this.newItems.add(c);
            results[i] = c;
        }
        return results;
    }

    public Contract splitValue(String fieldName, Decimal valueToExtract) {
        Contract sibling = this.split(1)[0];
        Binder stateData = this.getStateData();
        Decimal value = new Decimal(stateData.getStringOrThrow(fieldName));
        stateData.set(fieldName, value.subtract(valueToExtract));
        sibling.getStateData().put(fieldName, valueToExtract.toString());
        return sibling;
    }

    public Set<Contract> getSiblings() {
        return this.context.siblings;
    }

    public void addNewItems(Contract ... newContracts) {
        for (Contract c : newContracts) {
            this.newItems.add(c);
        }
    }

    public <T> T get(String name) {
        String originalName = name;
        if (name.startsWith("definition.")) {
            switch (name = name.substring(11)) {
                case "expires_at": {
                    return (T)this.state.expiresAt;
                }
                case "created_at": {
                    return (T)this.definition.createdAt;
                }
                case "issuer": {
                    return (T)this.getRole("issuer");
                }
                case "origin": {
                    return (T)this.getOrigin();
                }
            }
            if (name.startsWith("data.")) {
                return this.definition.data.getOrNull(name.substring(5));
            }
            if (name.startsWith("references.")) {
                return (T)this.findReferenceByName(name.substring(11), "definition");
            }
        } else if (name.startsWith("state.")) {
            switch (name = name.substring(6)) {
                case "origin": {
                    return (T)this.getOrigin();
                }
                case "created_at": {
                    return (T)this.state.createdAt;
                }
            }
            if (name.startsWith("data.")) {
                return this.state.data.getOrNull(name.substring(5));
            }
            if (name.startsWith("references.")) {
                return (T)this.findReferenceByName(name.substring(11), "state");
            }
        } else {
            switch (name) {
                case "id": {
                    return (T)this.getId();
                }
                case "origin": {
                    return (T)this.getOrigin();
                }
                case "issuer": {
                    return (T)this.getRole("issuer");
                }
                case "owner": {
                    return (T)this.getRole("owner");
                }
                case "creator": {
                    return (T)this.getRole("creator");
                }
            }
        }
        throw new IllegalArgumentException("bad root: " + originalName);
    }

    public void set(String name, Binder value) {
        if (name.startsWith("definition.")) {
            switch (name = name.substring(11)) {
                case "expires_at": {
                    this.state.expiresAt = value.getZonedDateTimeOrThrow("data");
                    return;
                }
                case "created_at": {
                    this.definition.createdAt = value.getZonedDateTimeOrThrow("data");
                    return;
                }
                case "issuer": {
                    this.setRole("issuer", ((SimpleRole)value.get("data")).getKeys());
                    return;
                }
            }
            if (name.startsWith("data.")) {
                this.definition.data.set(name.substring(5), value.getOrThrow("data"));
            }
            return;
        }
        if (name.startsWith("state.")) {
            switch (name = name.substring(6)) {
                case "created_at": {
                    this.state.createdAt = value.getZonedDateTimeOrThrow("data");
                    return;
                }
            }
            if (name.startsWith("data.")) {
                this.state.data.set(name.substring(5), value.getOrThrow("data"));
            }
            return;
        }
        name.getClass();
        throw new IllegalArgumentException("bad root: " + name);
    }

    public static Contract fromSealedFile(String contractFileName) throws IOException {
        return new Contract(Do.read(contractFileName), new TransactionPack());
    }

    public ZonedDateTime getIssuedAt() {
        return this.definition.createdAt;
    }

    public byte[] getLastSealedBinary(boolean sealAsNeed) {
        if (this.sealedBinary == null && sealAsNeed) {
            this.seal();
        }
        return this.sealedBinary;
    }

    public byte[] getPackedTransaction() {
        return this.getTransactionPack().pack();
    }

    public static Contract fromPackedTransaction(@NonNull byte[] packedItem) throws IOException {
        TransactionPack tp = TransactionPack.unpack(packedItem);
        return tp.getContract();
    }

    public void setTransactionPack(TransactionPack transactionPack) {
        this.transactionPack = transactionPack;
    }

    public synchronized TransactionPack getTransactionPack() {
        if (this.transactionPack == null) {
            this.transactionPack = new TransactionPack(this);
        }
        return this.transactionPack;
    }

    public Contract createRevocation(PrivateKey ... keys) {
        return ContractsService.createRevocation(this, keys);
    }

    public List<Contract> getRevoking() {
        return new ArrayList<Approvable>(this.getRevokingItems());
    }

    public List<? extends Contract> getNew() {
        return new ArrayList<Approvable>(this.getNewItems());
    }

    public List<? extends Contract> getReferenced() {
        return new ArrayList<Approvable>(this.getReferencedItems());
    }

    public boolean canBeRevoked(Set<PublicKey> keys) throws Quantiser.QuantiserException {
        for (Permission perm : this.permissions.getList("revoke")) {
            if (!perm.isAllowedForKeys(keys)) continue;
            this.checkApplicablePermissionQuantized(perm);
            return true;
        }
        return false;
    }

    public Transactional createTransactionalSection() {
        this.transactional = new Transactional();
        return this.transactional;
    }

    protected void verifySignatureQuantized(PublicKey key) throws Quantiser.QuantiserException {
        if (key.getBitStrength() == 2048) {
            this.quantiser.addWorkCost(Quantiser.QuantiserProcesses.PRICE_CHECK_2048_SIG);
        } else {
            this.quantiser.addWorkCost(Quantiser.QuantiserProcesses.PRICE_CHECK_4096_SIG);
        }
    }

    public void checkApplicablePermissionQuantized(Permission permission) throws Quantiser.QuantiserException {
        this.quantiser.addWorkCost(Quantiser.QuantiserProcesses.PRICE_APPLICABLE_PERM);
        if (permission instanceof SplitJoinPermission) {
            this.quantiser.addWorkCost(Quantiser.QuantiserProcesses.PRICE_SPLITJOIN_PERM);
        }
    }

    protected void checkSubItemQuantized(Contract contract) throws Quantiser.QuantiserException {
        this.checkSubItemQuantized(contract, "");
    }

    protected void checkSubItemQuantized(Contract contract, String prefix) throws Quantiser.QuantiserException {
        this.checkSubItemQuantized(contract, prefix, null);
    }

    protected void checkSubItemQuantized(Contract contract, String prefix, List<Contract> neighbourContracts) throws Quantiser.QuantiserException {
        contract.quantiser.reset(this.quantiser.getQuantaLimit() - this.quantiser.getQuantaSum());
        contract.check(prefix, neighbourContracts);
        this.quantiser.addWorkCostFrom(contract.quantiser);
    }

    public Reference findReferenceByName(String name) {
        if (this.getReferences() == null) {
            return null;
        }
        return this.getReferences().get(name);
    }

    public Reference findReferenceByName(String name, String section) {
        if (section.equals("definition")) {
            if (this.definition.getReferences() == null) {
                return null;
            }
            List<Reference> listRefs = this.definition.getReferences();
            for (Reference ref : listRefs) {
                if (!ref.getName().equals(name)) continue;
                return ref;
            }
            return null;
        }
        if (section.equals("state")) {
            if (this.state.getReferences() == null) {
                return null;
            }
            List<Reference> listRefs = this.state.getReferences();
            for (Reference ref : listRefs) {
                if (!ref.getName().equals(name)) continue;
                return ref;
            }
            return null;
        }
        if (section.equals("transactional")) {
            if (this.transactional.getReferences() == null) {
                return null;
            }
            List<Reference> listRefs = this.transactional.getReferences();
            for (Reference ref : listRefs) {
                if (!ref.getName().equals(name)) continue;
                return ref;
            }
            return null;
        }
        return null;
    }

    public Contract getContract() {
        return this;
    }

    public void traceErrors() {
        this.errors.forEach(e -> System.out.println("Error: " + e));
    }

    public String getErrorsString() {
        return this.errors.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public synchronized Contract copy() {
        return (Contract)Boss.load(Boss.dump(this, new Object[0]));
    }

    protected Context getContext() {
        if (this.context == null) {
            this.context = new Context(this.getRevokingItem(this.getParent()));
            this.context.siblings.add(this);
            this.newItems.forEach(i -> {
                if (i.getParent() != null && i.getParent().equals(this.getParent())) {
                    this.context.siblings.add(i);
                }
            });
        }
        return this.context;
    }

    @Override
    public boolean isTU(PublicKey issuerKey, String issuerName) {
        if (!this.getIssuer().getKeys().equals(new HashSet<PublicKey>(Arrays.asList(issuerKey)))) {
            return false;
        }
        return issuerName.equals(this.getDefinition().getData().get("issuerName"));
    }

    @Override
    public boolean shouldBeTU() {
        return this.shouldBeTU;
    }

    public void setShouldBeTU(boolean shouldBeTU) {
        this.shouldBeTU = shouldBeTU;
    }

    public void setLimitedForTestnet(boolean limitedForTestnet) {
        this.limitedForTestnet = limitedForTestnet;
    }

    public boolean isLimitedForTestnet() {
        return this.limitedForTestnet;
    }

    public boolean isSuitableForTestnet() {
        return this.isSuitableForTestnet;
    }

    @Override
    public boolean isInWhiteList(List<PublicKey> whiteList) {
        return this.sealedByKeys.keySet().stream().anyMatch(k -> whiteList.contains(k));
    }

    public static ZonedDateTime decodeDslTime(Object t) {
        if (t instanceof ZonedDateTime) {
            return (ZonedDateTime)t;
        }
        if (t instanceof CharSequence) {
            if (t.equals("now()")) {
                return ZonedDateTime.now();
            }
            Matcher m = relativeTimePattern.matcher((CharSequence)t);
            System.out.println("MATCH: " + m);
            if (m.find()) {
                String unit;
                ZonedDateTime now = ZonedDateTime.now();
                int amount = Integer.valueOf(m.group(1));
                switch (unit = m.group(2)) {
                    case "min": {
                        return now.plusMinutes(amount);
                    }
                    case "hour": {
                        return now.plusHours(amount);
                    }
                    case "day": {
                        return now.plusDays(amount);
                    }
                }
                throw new IllegalArgumentException("unknown time unit: " + unit);
            }
        }
        throw new IllegalArgumentException("can't convert to datetime: " + t);
    }

    static {
        Config.forceInit(ItemResult.class);
        Config.forceInit(HashId.class);
        Config.forceInit(Contract.class);
        Config.forceInit(Permission.class);
        Config.forceInit(Contract.class);
        Config.forceInit(ChangeNumberPermission.class);
        Config.forceInit(ChangeOwnerPermission.class);
        Config.forceInit(SplitJoinPermission.class);
        Config.forceInit(PublicKey.class);
        Config.forceInit(PrivateKey.class);
        Config.forceInit(KeyRecord.class);
        Config.forceInit(KeyAddress.class);
        Config.forceInit(AnonymousId.class);
        DefaultBiMapper.registerClass(Contract.class);
        DefaultBiMapper.registerClass(ChangeNumberPermission.class);
        DefaultBiMapper.registerClass(ChangeOwnerPermission.class);
        DefaultBiMapper.registerClass(ModifyDataPermission.class);
        DefaultBiMapper.registerClass(RevokePermission.class);
        DefaultBiMapper.registerClass(SplitJoinPermission.class);
        DefaultBiMapper.registerClass(ListRole.class);
        DefaultBiMapper.registerClass(Role.class);
        DefaultBiMapper.registerClass(RoleLink.class);
        DefaultBiMapper.registerClass(SimpleRole.class);
        DefaultBiMapper.registerClass(KeyRecord.class);
        DefaultBiMapper.registerAdapter(PublicKey.class, PublicKey.PUBLIC_KEY_BI_ADAPTER);
        DefaultBiMapper.registerClass(Reference.class);
        DefaultBiMapper.registerClass(Permission.class);
    }

    public final class ContractDev {
        private Contract c;

        public ContractDev(Contract c) throws Exception {
            this.c = c;
        }

        public void setOrigin(HashId origin) {
            this.c.getState().origin = origin;
        }

        public void setParent(HashId parent) {
            this.c.getState().parent = parent;
        }

        public Contract getContract() {
            return this.c;
        }
    }

    protected class Context {
        private final Set<Contract> siblings = new HashSet<Contract>();
        private final Contract base;

        public Context(Contract base) {
            this.base = base;
        }
    }

    public class Transactional {
        private String id;
        private List<Reference> references;

        private Transactional() {
        }

        public Binder serializeWith(BiSerializer serializer) {
            Binder b = Binder.of("id", this.id, new Object[0]);
            if (this.references != null) {
                b.set("references", serializer.serialize(this.references));
            }
            return (Binder)serializer.serialize(b);
        }

        public void deserializeWith(Binder data, BiDeserializer d) {
            if (data != null) {
                this.id = data.getString("id", null);
                List refs = data.getList("references", null);
                if (refs != null) {
                    this.references = d.deserializeCollection(refs);
                }
            }
        }

        public void addReference(Reference reference) {
            if (this.references == null) {
                this.references = new ArrayList<Reference>();
            }
            this.references.add(reference);
        }

        public List<Reference> getReferences() {
            return this.references;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public class Definition {
        private ZonedDateTime createdAt;
        private ZonedDateTime expiresAt;
        private Binder definition;
        private Binder data;
        private List<Reference> references = new ArrayList<Reference>();

        public void setExpiresAt(ZonedDateTime expiresAt) {
            this.expiresAt = expiresAt;
        }

        public void setData(Binder data) {
            this.data = data;
        }

        private Definition() {
            this.createdAt = ZonedDateTime.now();
        }

        private Definition initializeWithDsl(Binder definition) {
            this.definition = definition;
            Role issuer = Contract.this.createRole("issuer", definition.getOrThrow("issuer"));
            this.createdAt = definition.getZonedDateTimeOrThrow("created_at");
            Object t = definition.getOrDefault("expires_at", null);
            if (t != null) {
                this.expiresAt = Contract.decodeDslTime(t);
            }
            Contract.this.registerRole(issuer);
            this.data = definition.getBinder("data");
            List refList = definition.getList("references", null);
            if (refList != null) {
                for (LinkedHashMap refItem : refList) {
                    Binder item = new Binder((Map)refItem);
                    Binder ref = item.getBinder("reference");
                    if (ref != null) {
                        Binder where;
                        String name;
                        block8: {
                            name = ref.getString("name");
                            where = null;
                            try {
                                where = ref.getBinderOrThrow("where");
                            }
                            catch (Exception e) {
                                List simpleConditions = ref.getList("where", null);
                                if (simpleConditions == null) break block8;
                                where = new Binder(Reference.conditionsModeType.all_of.name(), simpleConditions);
                            }
                        }
                        Reference reference = new Reference(Contract.this.getContract());
                        if (name == null) {
                            throw new IllegalArgumentException("Expected reference name");
                        }
                        reference.setName(name);
                        if (where != null) {
                            reference.setConditions(where);
                        }
                        this.references.add(reference);
                        continue;
                    }
                    throw new IllegalArgumentException("Expected reference section");
                }
            }
            return this;
        }

        public void addReference(Reference reference) {
            if (this.references == null) {
                this.references = new ArrayList<Reference>();
            }
            this.references.add(reference);
        }

        public List<Reference> getReferences() {
            return this.references;
        }

        private void scanDslPermissions() {
            this.definition.getBinderOrThrow("permissions").forEach((name, params) -> {
                if (params instanceof Object[]) {
                    for (Object x : (Object[])params) {
                        this.loadDslPermission((String)name, x);
                    }
                } else if (params instanceof List) {
                    for (Object x : (List)params) {
                        this.loadDslPermission((String)name, x);
                    }
                } else if (params instanceof Permission) {
                    Contract.this.addPermission((Permission)params);
                } else {
                    this.loadDslPermission((String)name, params);
                }
            });
        }

        private void loadDslPermission(String name, Object params) {
            String roleName = null;
            Role role = null;
            Binder binderParams = null;
            if (params instanceof CharSequence) {
                roleName = params.toString();
            } else {
                binderParams = Binder.from(params);
                Object x = binderParams.getOrThrow("role");
                if (x instanceof Role) {
                    role = Contract.this.registerRole((Role)x);
                } else if (x instanceof Map) {
                    role = Contract.this.createRole("@" + name, (Map)x);
                } else {
                    roleName = x.toString();
                }
            }
            if (role == null && roleName != null) {
                role = Contract.this.createRole("@" + name, roleName);
            }
            if (role == null) {
                throw new IllegalArgumentException("permission " + name + " refers to missing role: " + roleName);
            }
            Contract.this.addPermission(Permission.forName(name, role, params instanceof String ? null : binderParams));
        }

        public Binder getData() {
            if (this.data == null) {
                this.data = new Binder();
            }
            return this.data;
        }

        public Binder serializeWith(BiSerializer serializer) {
            List pp = Contract.this.permissions.values();
            Binder pb = new Binder();
            boolean lastId = false;
            Contract.this.permissions.values().forEach(perm -> {
                String pid = perm.getId();
                if (pid == null) {
                    throw new IllegalStateException("permission without id: " + perm);
                }
                if (pb.containsKey(pid)) {
                    throw new IllegalStateException("permission: duplicate permission id found: " + perm);
                }
                pb.put(pid, perm);
            });
            Collections.sort(pp);
            Binder of = Binder.of("issuer", Contract.this.getIssuer(), new Object[]{"created_at", this.createdAt, "data", this.data, "permissions", pb});
            if (this.expiresAt != null) {
                of.set("expires_at", this.expiresAt);
            }
            if (this.references != null) {
                of.set("references", this.references);
            }
            return (Binder)serializer.serialize(of);
        }

        public void deserializeWith(Binder data, BiDeserializer d) {
            Contract.this.registerRole((Role)d.deserialize(data.getBinderOrThrow("issuer")));
            this.createdAt = data.getZonedDateTimeOrThrow("created_at");
            this.expiresAt = data.getZonedDateTime("expires_at", null);
            this.data = (Binder)d.deserialize(data.getBinder("data", Binder.EMPTY));
            this.references = (List)d.deserialize(data.getList("references", null));
            Map perms = (Map)d.deserialize(data.getOrThrow("permissions"));
            perms.forEach((id, perm) -> {
                perm.setId((String)id);
                Contract.this.addPermission((Permission)perm);
            });
        }
    }

    public class State {
        private int revision;
        private Binder state;
        private ZonedDateTime createdAt;
        private ZonedDateTime expiresAt;
        private HashId origin;
        private HashId parent;
        private Binder data = new Binder();
        private String branchId;
        private List<Reference> references = new ArrayList<Reference>();
        private Integer branchRevision = null;

        private State() {
            this.createdAt = Contract.this.definition.createdAt;
            this.revision = 1;
        }

        public void setExpiresAt(ZonedDateTime expiresAt) {
            this.expiresAt = expiresAt;
        }

        private State initializeWithDsl(Binder state) {
            this.state = state;
            this.createdAt = state.getZonedDateTime("created_at", null);
            this.expiresAt = state.getZonedDateTime("expires_at", null);
            this.revision = state.getIntOrThrow("revision");
            this.data = state.getOrCreateBinder("data");
            if (this.createdAt == null) {
                if (this.revision != 1) {
                    throw new IllegalArgumentException("state.created_at must be set for revisions > 1");
                }
                this.createdAt = Contract.this.definition.createdAt;
            }
            Contract.this.createRole("owner", state.get("owner"));
            Contract.this.createRole("creator", state.getOrThrow("created_by"));
            return this;
        }

        public int getRevision() {
            return this.revision;
        }

        public ZonedDateTime getCreatedAt() {
            return this.createdAt;
        }

        public Binder serializeWith(BiSerializer serializer) {
            Binder of = Binder.of("created_at", this.createdAt, new Object[]{"revision", this.revision, "owner", Contract.this.getRole("owner"), "created_by", Contract.this.getRole("creator"), "branch_id", this.branchId, "origin", serializer.serialize(this.origin), "parent", serializer.serialize(this.parent), "data", this.data});
            if (this.expiresAt != null) {
                of.set("expires_at", this.expiresAt);
            }
            if (this.references != null) {
                of.set("references", this.references);
            }
            return (Binder)serializer.serialize(of);
        }

        public Binder getData() {
            if (this.data == null) {
                this.data = new Binder();
            }
            return this.data;
        }

        public void deserealizeWith(Binder data, BiDeserializer d) {
            this.createdAt = data.getZonedDateTimeOrThrow("created_at");
            this.expiresAt = data.getZonedDateTime("expires_at", null);
            this.revision = data.getIntOrThrow("revision");
            this.references = (List)d.deserialize(data.getList("references", null));
            if (this.revision <= 0) {
                throw new IllegalArgumentException("illegal revision number: " + this.revision);
            }
            Role r = Contract.this.registerRole((Role)d.deserialize(data.getBinderOrThrow("owner")));
            if (!r.getName().equals("owner")) {
                throw new IllegalArgumentException("bad owner role name");
            }
            r = Contract.this.registerRole((Role)d.deserialize(data.getBinderOrThrow("created_by")));
            if (!r.getName().equals("creator")) {
                throw new IllegalArgumentException("bad creator role name");
            }
            this.data = data.getBinder("data", Binder.EMPTY);
            this.branchId = data.getString("branch_id", null);
            this.parent = (HashId)d.deserialize(data.get("parent"));
            this.origin = (HashId)d.deserialize(data.get("origin"));
        }

        public Integer getBranchRevision() {
            if (this.branchRevision == null) {
                this.branchRevision = this.branchId == null ? Integer.valueOf(0) : Integer.valueOf(this.branchId.split(":")[0]);
            }
            return this.branchRevision;
        }

        public String getBranchId() {
            return this.branchId;
        }

        public void setBranchNumber(int number) {
            this.branchId = this.revision + ":" + number;
            this.branchRevision = number;
        }

        public void addReference(Reference reference) {
            if (this.references == null) {
                this.references = new ArrayList<Reference>();
            }
            this.references.add(reference);
        }

        public List<Reference> getReferences() {
            return this.references;
        }
    }
}

