/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.crypto.PublicKey;
import com.icodici.universa.Errors;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.roles.Role;
import com.icodici.universa.node2.Quantiser;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sergeych.biserializer.BiMapper;
import net.sergeych.biserializer.BossBiMapper;
import net.sergeych.diff.ChangedItem;
import net.sergeych.diff.Delta;
import net.sergeych.diff.MapDelta;

public class ContractDelta {
    private final Contract existing;
    private final Contract changed;
    private MapDelta stateDelta;
    private Map<String, Delta> stateChanges;
    private static final Set<String> insignificantKeys = new HashSet<String>(Arrays.asList("created_at", "created_by", "revision", "branch_id", "parent", "origin"));

    public ContractDelta(Contract existing, Contract changed) {
        this.existing = existing;
        this.changed = changed;
    }

    public synchronized void check() throws Quantiser.QuantiserException {
        try {
            Delta transactionalDelta;
            BiMapper mapper = BossBiMapper.getInstance();
            MapDelta rootDelta = (MapDelta)Delta.between(mapper.serialize(this.existing), mapper.serialize(this.changed));
            MapDelta definitionDelta = (MapDelta)rootDelta.getChange("definition");
            this.stateDelta = (MapDelta)rootDelta.getChange("state");
            if (definitionDelta != null) {
                this.addError(Errors.ILLEGAL_CHANGE, "definition", "definition must not be changed");
            }
            int allowedRootChanges = 1;
            Delta ch = rootDelta.getChange("api_level");
            if (ch != null) {
                ++allowedRootChanges;
            }
            if ((transactionalDelta = rootDelta.getChange("transactional")) != null) {
                ++allowedRootChanges;
            }
            if (rootDelta.getChanges().size() > allowedRootChanges) {
                this.addError(Errors.ILLEGAL_CHANGE, "root", "root level changes are forbidden except the state");
            }
            this.checkStateChange();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            this.addError(Errors.FAILED_CHECK, "", "failed to compare, structure is broken or not supported");
        }
    }

    private void checkStateChange() throws Quantiser.QuantiserException {
        Role creator;
        this.stateChanges = this.stateDelta.getChanges();
        this.stateChanges.remove("created_by");
        this.stateChanges.remove("branch_id");
        this.stateChanges.remove("parent");
        this.stateChanges.remove("origin");
        if (insignificantKeys.containsAll(this.stateChanges.keySet())) {
            this.addError(Errors.BADSTATE, "", "new state is identical");
        }
        if ((creator = this.changed.getRole("creator")) == null) {
            this.addError(Errors.MISSING_CREATOR, "state.created_by", "");
            return;
        }
        ChangedItem revision = (ChangedItem)this.stateChanges.get("revision");
        if (revision == null) {
            this.addError(Errors.BAD_VALUE, "state.revision", "is not incremented");
        } else {
            this.stateChanges.remove("revision");
            if ((Integer)revision.oldValue() + 1 != (Integer)revision.newValue()) {
                this.addError(Errors.BAD_VALUE, "state.revision", "wrong revision number");
            }
        }
        Delta creationTimeChange = this.stateChanges.get("created_at");
        if (creationTimeChange != null) {
            this.stateChanges.remove("created_at");
            ChangedItem ci = (ChangedItem)creationTimeChange;
            if (!((ZonedDateTime)ci.newValue()).isAfter((ChronoZonedDateTime)ci.oldValue())) {
                this.addError(Errors.BAD_VALUE, "state.created_at", "new creation datetime is before old one");
            }
        }
        this.excludePermittedChanges();
        this.stateChanges.forEach((field2, delta) -> {
            if (!delta.isEmpty()) {
                String reason = "";
                if (delta instanceof MapDelta) {
                    reason = " in " + ((MapDelta)delta).getChanges().keySet();
                }
                this.addError(Errors.FORBIDDEN, "state." + field2, "not permitted changes" + reason + ": " + delta.oldValue() + " -> " + delta.newValue());
            }
        });
    }

    private void excludePermittedChanges() throws Quantiser.QuantiserException {
        Set<PublicKey> checkingKeys = this.changed.getSealedByKeys();
        Set<String> checkingReferences = this.changed.getReferences().keySet();
        for (String key : this.existing.getPermissions().keySet()) {
            Collection<Permission> permissions = this.existing.getPermissions().get(key);
            boolean permissionQuantized = false;
            for (Permission permission : permissions) {
                if (!permission.isAllowedFor(checkingKeys, checkingReferences)) continue;
                if (!permissionQuantized) {
                    this.changed.checkApplicablePermissionQuantized(permission);
                    permissionQuantized = true;
                }
                permission.checkChanges(this.existing, this.changed, this.stateChanges);
            }
        }
    }

    private void checkOwnerChanged() throws Quantiser.QuantiserException {
        ChangedItem oc = (ChangedItem)this.stateChanges.get("owner");
        if (oc != null) {
            this.stateChanges.remove("owner");
            Role creator = this.changed.getRole("creator");
            if (!this.existing.isPermitted("change_owner", creator)) {
                this.addError(Errors.FORBIDDEN, "state.owner", "creator has no right to change");
            }
        }
    }

    private void addError(Errors code, String field2, String text) {
        this.changed.addError(code, field2, text);
    }
}

