/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.Decimal;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.InnerContractsService;
import com.icodici.universa.contract.KeyRecord;
import com.icodici.universa.contract.Parcel;
import com.icodici.universa.contract.Reference;
import com.icodici.universa.contract.TransactionPack;
import com.icodici.universa.contract.permissions.ChangeOwnerPermission;
import com.icodici.universa.contract.permissions.RevokePermission;
import com.icodici.universa.contract.permissions.SplitJoinPermission;
import com.icodici.universa.contract.roles.Role;
import com.icodici.universa.contract.roles.SimpleRole;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sergeych.tools.Binder;

public class ContractsService {
    public static synchronized Contract createRevocation(Contract c, PrivateKey ... keys) {
        Contract tc = new Contract();
        Contract.Definition cd = tc.getDefinition();
        cd.setExpiresAt(tc.getCreatedAt().plusDays(30L));
        SimpleRole issuerRole = new SimpleRole("issuer");
        for (PrivateKey k : keys) {
            KeyRecord kr = new KeyRecord(k.getPublicKey());
            issuerRole.addKeyRecord(kr);
            tc.addSignerKey(k);
        }
        tc.registerRole(issuerRole);
        tc.createRole("owner", issuerRole);
        tc.createRole("creator", issuerRole);
        if (!tc.getRevokingItems().contains(c)) {
            Binder data = tc.getDefinition().getData();
            List actions = data.getOrCreateList("actions");
            tc.getRevokingItems().add(c);
            actions.add(Binder.fromKeysValues("action", "remove", "id", c.getId()));
        }
        tc.seal();
        return tc;
    }

    public static synchronized Contract createSplit(Contract c, long amount, String fieldName, Set<PrivateKey> keys) {
        return ContractsService.createSplit(c, amount, fieldName, keys, false);
    }

    public static synchronized Contract createSplit(Contract c, long amount, String fieldName, Set<PrivateKey> keys, boolean andSetCreator) {
        Contract splitFrom = c.createRevision();
        Contract splitTo = splitFrom.splitValue(fieldName, new Decimal(amount));
        for (PrivateKey key : keys) {
            splitTo.addSignerKey(key);
        }
        if (andSetCreator) {
            splitTo.createRole("creator", splitTo.getRole("owner"));
            splitFrom.createRole("creator", splitFrom.getRole("owner"));
        }
        splitTo.seal();
        splitFrom.seal();
        return splitFrom;
    }

    public static synchronized Contract createJoin(Contract contract1, Contract contract2, String fieldName, Set<PrivateKey> keys) {
        Contract joinTo = contract1.createRevision();
        joinTo.getStateData().set(fieldName, InnerContractsService.getDecimalField(contract1, fieldName).add(InnerContractsService.getDecimalField(contract2, fieldName)));
        for (PrivateKey key : keys) {
            joinTo.addSignerKey(key);
        }
        joinTo.addRevokingItems(contract2);
        joinTo.seal();
        return joinTo;
    }

    public static synchronized Contract startSwap(Contract contract1, Contract contract2, Set<PrivateKey> fromKeys, Set<PublicKey> toKeys) {
        return ContractsService.startSwap(contract1, contract2, fromKeys, toKeys, true);
    }

    public static synchronized Contract startSwap(List<Contract> contracts1, List<Contract> contracts2, Set<PrivateKey> fromKeys, Set<PublicKey> toKeys) {
        return ContractsService.startSwap(contracts1, contracts2, fromKeys, toKeys, true);
    }

    public static synchronized Contract startSwap(Contract contract1, Contract contract2, Set<PrivateKey> fromKeys, Set<PublicKey> toKeys, boolean createNewRevision) {
        ArrayList<Contract> contracts1 = new ArrayList<Contract>();
        contracts1.add(contract1);
        ArrayList<Contract> contracts2 = new ArrayList<Contract>();
        contracts2.add(contract2);
        return ContractsService.startSwap(contracts1, contracts2, fromKeys, toKeys, createNewRevision);
    }

    public static synchronized Contract startSwap(List<Contract> contracts1, List<Contract> contracts2, Set<PrivateKey> fromKeys, Set<PublicKey> toKeys, boolean createNewRevision) {
        Reference reference;
        HashSet<PublicKey> fromPublicKeys = new HashSet<PublicKey>();
        for (PrivateKey pk : fromKeys) {
            fromPublicKeys.add(pk.getPublicKey());
        }
        Contract swapContract = new Contract();
        Contract.Definition cd = swapContract.getDefinition();
        cd.setExpiresAt(swapContract.getCreatedAt().plusDays(30L));
        SimpleRole issuerRole = new SimpleRole("issuer");
        for (PrivateKey privateKey : fromKeys) {
            KeyRecord keyRecord = new KeyRecord(privateKey.getPublicKey());
            issuerRole.addKeyRecord(keyRecord);
        }
        swapContract.registerRole(issuerRole);
        swapContract.createRole("owner", issuerRole);
        swapContract.createRole("creator", issuerRole);
        ArrayList<Contract> newContracts1 = new ArrayList<Contract>();
        for (Contract contract : contracts1) {
            Contract nc = createNewRevision ? contract.createRevision(fromKeys) : contract;
            nc.createTransactionalSection();
            nc.getTransactional().setId(HashId.createRandom().toBase64String());
            newContracts1.add(nc);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Contract c : contracts2) {
            Contract nc = createNewRevision ? c.createRevision() : c;
            nc.createTransactionalSection();
            nc.getTransactional().setId(HashId.createRandom().toBase64String());
            arrayList.add(nc);
        }
        SimpleRole simpleRole = new SimpleRole("owner");
        SimpleRole creatorFrom = new SimpleRole("creator");
        for (PrivateKey k : fromKeys) {
            KeyRecord kr = new KeyRecord(k.getPublicKey());
            simpleRole.addKeyRecord(kr);
            creatorFrom.addKeyRecord(kr);
        }
        SimpleRole ownerTo = new SimpleRole("owner");
        SimpleRole creatorTo = new SimpleRole("creator");
        for (PublicKey publicKey : toKeys) {
            KeyRecord kr = new KeyRecord(publicKey);
            ownerTo.addKeyRecord(kr);
            creatorTo.addKeyRecord(kr);
        }
        for (Contract contract : newContracts1) {
            for (Contract contract2 : arrayList) {
                reference = new Reference(contract);
                reference.transactional_id = contract2.getTransactional().getId();
                reference.type = 1;
                reference.required = true;
                reference.signed_by = new ArrayList<Role>();
                reference.signed_by.add(simpleRole);
                reference.signed_by.add(creatorTo);
                contract.getTransactional().addReference(reference);
            }
        }
        for (Contract contract : arrayList) {
            for (Contract contract3 : newContracts1) {
                reference = new Reference(contract);
                reference.transactional_id = contract3.getTransactional().getId();
                reference.type = 1;
                reference.required = true;
                reference.signed_by = new ArrayList<Role>();
                reference.signed_by.add(ownerTo);
                reference.signed_by.add(creatorFrom);
                contract.getTransactional().addReference(reference);
            }
        }
        for (Contract contract : newContracts1) {
            contract.setOwnerKeys(toKeys);
            contract.seal();
        }
        for (Contract contract : arrayList) {
            contract.setOwnerKeys(fromPublicKeys);
            contract.seal();
        }
        for (Contract contract : newContracts1) {
            swapContract.addNewItems(contract);
        }
        for (Contract contract : arrayList) {
            swapContract.addNewItems(contract);
        }
        swapContract.seal();
        return swapContract;
    }

    public static synchronized Contract signPresentedSwap(Contract swapContract, Set<PrivateKey> keys) {
        HashSet<PublicKey> publicKeys = new HashSet<PublicKey>();
        for (PrivateKey pk : keys) {
            publicKeys.add(pk.getPublicKey());
        }
        List<? extends Contract> swappingContracts = swapContract.getNew();
        HashMap<String, HashId> contractHashId = new HashMap<String, HashId>();
        for (Contract contract : swappingContracts) {
            boolean willBeMine = contract.getOwner().isAllowedForKeys(publicKeys);
            if (!willBeMine) continue;
            contract.addSignatureToSeal(keys);
            contractHashId.put(contract.getTransactional().getId(), contract.getId());
        }
        for (Contract contract : swappingContracts) {
            boolean willBeNotMine = !contract.getOwner().isAllowedForKeys(publicKeys);
            if (!willBeNotMine) continue;
            HashSet<KeyRecord> krs = new HashSet<KeyRecord>();
            for (PublicKey k : publicKeys) {
                krs.add(new KeyRecord(k));
            }
            contract.setCreator(krs);
            if (contract.getTransactional() != null && contract.getTransactional().getReferences() != null) {
                for (Reference rm : contract.getTransactional().getReferences()) {
                    rm.contract_id = (HashId)contractHashId.get(rm.transactional_id);
                }
            } else {
                return swapContract;
            }
            contract.seal();
            contract.addSignatureToSeal(keys);
        }
        swapContract.seal();
        return swapContract;
    }

    public static synchronized Contract finishSwap(Contract swapContract, Set<PrivateKey> keys) {
        List<? extends Contract> swappingContracts = swapContract.getNew();
        for (Contract contract : swappingContracts) {
            boolean willBeMine = contract.getOwner().isAllowedForKeys(keys);
            if (!willBeMine) continue;
            contract.addSignatureToSeal(keys);
        }
        swapContract.seal();
        swapContract.addSignatureToSeal(keys);
        return swapContract;
    }

    public static synchronized Contract createTwoSignedContract(Contract BaseContract, Set<PrivateKey> fromKeys, Set<PublicKey> toKeys, boolean createNewRevision) {
        Contract twoSignContract = BaseContract;
        if (createNewRevision) {
            twoSignContract = BaseContract.createRevision(fromKeys);
            twoSignContract.getKeysToSignWith().clear();
        }
        SimpleRole creatorFrom = new SimpleRole("creator");
        for (PrivateKey privateKey : fromKeys) {
            KeyRecord kr = new KeyRecord(privateKey.getPublicKey());
            creatorFrom.addKeyRecord(kr);
        }
        SimpleRole ownerTo = new SimpleRole("owner");
        for (PublicKey k : toKeys) {
            KeyRecord kr = new KeyRecord(k);
            ownerTo.addKeyRecord(kr);
        }
        twoSignContract.createTransactionalSection();
        twoSignContract.getTransactional().setId(HashId.createRandom().toBase64String());
        Reference reference = new Reference(twoSignContract);
        reference.transactional_id = twoSignContract.getTransactional().getId();
        reference.type = 1;
        reference.required = true;
        reference.signed_by = new ArrayList<Role>();
        reference.signed_by.add(creatorFrom);
        reference.signed_by.add(ownerTo);
        twoSignContract.getTransactional().addReference(reference);
        twoSignContract.setOwnerKeys(toKeys);
        twoSignContract.seal();
        return twoSignContract;
    }

    public static synchronized Contract createTokenContract(Set<PrivateKey> issuerKeys, Set<PublicKey> ownerKeys, String amount) {
        Contract tokenContract = new Contract();
        tokenContract.setApiLevel(3);
        Contract.Definition cd = tokenContract.getDefinition();
        cd.setExpiresAt(ZonedDateTime.now().plusMonths(60L));
        Binder data = new Binder();
        data.set("name", "Default token name");
        data.set("currency_code", "DT");
        data.set("currency_name", "Default token name");
        data.set("description", "Default token description.");
        cd.setData(data);
        SimpleRole issuerRole = new SimpleRole("issuer");
        for (PrivateKey privateKey : issuerKeys) {
            KeyRecord kr = new KeyRecord(privateKey.getPublicKey());
            issuerRole.addKeyRecord(kr);
        }
        SimpleRole ownerRole = new SimpleRole("owner");
        for (PublicKey k : ownerKeys) {
            KeyRecord kr = new KeyRecord(k);
            ownerRole.addKeyRecord(kr);
        }
        tokenContract.registerRole(issuerRole);
        tokenContract.createRole("issuer", issuerRole);
        tokenContract.createRole("creator", issuerRole);
        tokenContract.registerRole(ownerRole);
        tokenContract.createRole("owner", ownerRole);
        tokenContract.getStateData().set("amount", amount);
        ChangeOwnerPermission changeOwnerPermission = new ChangeOwnerPermission(ownerRole);
        tokenContract.addPermission(changeOwnerPermission);
        Binder params = new Binder();
        params.set("min_value", 0.01);
        params.set("min_unit", 0.01);
        params.set("field_name", "amount");
        ArrayList<String> listFields = new ArrayList<String>();
        listFields.add("state.origin");
        params.set("join_match_fields", listFields);
        SplitJoinPermission splitJoinPerm = new SplitJoinPermission(ownerRole, params);
        tokenContract.addPermission(splitJoinPerm);
        RevokePermission revokePerm1 = new RevokePermission(ownerRole);
        tokenContract.addPermission(revokePerm1);
        RevokePermission revokePerm2 = new RevokePermission(issuerRole);
        tokenContract.addPermission(revokePerm2);
        tokenContract.seal();
        tokenContract.addSignatureToSeal(issuerKeys);
        return tokenContract;
    }

    public static synchronized Contract createShareContract(Set<PrivateKey> issuerKeys, Set<PublicKey> ownerKeys, String amount) {
        Contract shareContract = new Contract();
        shareContract.setApiLevel(3);
        Contract.Definition cd = shareContract.getDefinition();
        cd.setExpiresAt(ZonedDateTime.now().plusMonths(60L));
        Binder data = new Binder();
        data.set("name", "Default share name");
        data.set("currency_code", "DSH");
        data.set("currency_name", "Default share name");
        data.set("description", "Default share description.");
        cd.setData(data);
        SimpleRole issuerRole = new SimpleRole("issuer");
        for (PrivateKey privateKey : issuerKeys) {
            KeyRecord kr = new KeyRecord(privateKey.getPublicKey());
            issuerRole.addKeyRecord(kr);
        }
        SimpleRole ownerRole = new SimpleRole("owner");
        for (PublicKey k : ownerKeys) {
            KeyRecord kr = new KeyRecord(k);
            ownerRole.addKeyRecord(kr);
        }
        shareContract.registerRole(issuerRole);
        shareContract.createRole("issuer", issuerRole);
        shareContract.createRole("creator", issuerRole);
        shareContract.registerRole(ownerRole);
        shareContract.createRole("owner", ownerRole);
        shareContract.getStateData().set("amount", amount);
        ChangeOwnerPermission changeOwnerPermission = new ChangeOwnerPermission(ownerRole);
        shareContract.addPermission(changeOwnerPermission);
        Binder params = new Binder();
        params.set("min_value", 1);
        params.set("min_unit", 1);
        params.set("field_name", "amount");
        ArrayList<String> listFields = new ArrayList<String>();
        listFields.add("state.origin");
        params.set("join_match_fields", listFields);
        SplitJoinPermission splitJoinPerm = new SplitJoinPermission(ownerRole, params);
        shareContract.addPermission(splitJoinPerm);
        RevokePermission revokePerm1 = new RevokePermission(ownerRole);
        shareContract.addPermission(revokePerm1);
        RevokePermission revokePerm2 = new RevokePermission(issuerRole);
        shareContract.addPermission(revokePerm2);
        shareContract.seal();
        shareContract.addSignatureToSeal(issuerKeys);
        return shareContract;
    }

    public static synchronized Contract createNotaryContract(Set<PrivateKey> issuerKeys, Set<PublicKey> ownerKeys) {
        Contract notaryContract = new Contract();
        notaryContract.setApiLevel(3);
        Contract.Definition cd = notaryContract.getDefinition();
        cd.setExpiresAt(ZonedDateTime.now().plusMonths(60L));
        Binder data = new Binder();
        data.set("name", "Default notary");
        data.set("description", "Default notary description.");
        cd.setData(data);
        SimpleRole issuerRole = new SimpleRole("issuer");
        for (PrivateKey privateKey : issuerKeys) {
            KeyRecord kr = new KeyRecord(privateKey.getPublicKey());
            issuerRole.addKeyRecord(kr);
        }
        SimpleRole ownerRole = new SimpleRole("owner");
        for (PublicKey k : ownerKeys) {
            KeyRecord kr = new KeyRecord(k);
            ownerRole.addKeyRecord(kr);
        }
        notaryContract.registerRole(issuerRole);
        notaryContract.createRole("issuer", issuerRole);
        notaryContract.createRole("creator", issuerRole);
        notaryContract.registerRole(ownerRole);
        notaryContract.createRole("owner", ownerRole);
        ChangeOwnerPermission changeOwnerPermission = new ChangeOwnerPermission(ownerRole);
        notaryContract.addPermission(changeOwnerPermission);
        RevokePermission revokePerm1 = new RevokePermission(ownerRole);
        notaryContract.addPermission(revokePerm1);
        RevokePermission revokePerm2 = new RevokePermission(issuerRole);
        notaryContract.addPermission(revokePerm2);
        notaryContract.seal();
        notaryContract.addSignatureToSeal(issuerKeys);
        return notaryContract;
    }

    public static synchronized Parcel createParcel(Contract payload, Contract payment, int amount, Set<PrivateKey> keys) {
        return ContractsService.createParcel(payload, payment, amount, keys, false);
    }

    public static synchronized Parcel createParcel(Contract payload, Contract payment, int amount, Set<PrivateKey> keys, boolean withTestPayment) {
        Contract paymentDecreased = payment.createRevision(keys);
        if (withTestPayment) {
            paymentDecreased.getStateData().set("test_transaction_units", payment.getStateData().getIntOrThrow("test_transaction_units") - amount);
        } else {
            paymentDecreased.getStateData().set("transaction_units", payment.getStateData().getIntOrThrow("transaction_units") - amount);
        }
        paymentDecreased.seal();
        Parcel parcel = new Parcel(payload.getTransactionPack(), paymentDecreased.getTransactionPack());
        return parcel;
    }

    public static synchronized Parcel createParcel(TransactionPack payload, Contract payment, int amount, Set<PrivateKey> keys) {
        return ContractsService.createParcel(payload, payment, amount, keys, false);
    }

    public static synchronized Parcel createParcel(TransactionPack payload, Contract payment, int amount, Set<PrivateKey> keys, boolean withTestPayment) {
        Contract paymentDecreased = payment.createRevision(keys);
        if (withTestPayment) {
            paymentDecreased.getStateData().set("test_transaction_units", payment.getStateData().getIntOrThrow("test_transaction_units") - amount);
        } else {
            paymentDecreased.getStateData().set("transaction_units", payment.getStateData().getIntOrThrow("transaction_units") - amount);
        }
        paymentDecreased.seal();
        Parcel parcel = new Parcel(payload, paymentDecreased.getTransactionPack());
        return parcel;
    }
}

