/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.HashType;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.crypto.digest.Sha3_384;
import com.icodici.crypto.digest.Sha512;
import java.time.ZonedDateTime;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Bytes;

public class ExtendedSignature {
    private Bytes keyId;
    private ZonedDateTime createdAt;
    private PublicKey publicKey = null;
    private byte[] signature;

    public Bytes getKeyId() {
        return this.keyId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public static byte[] sign(PrivateKey key, byte[] data) {
        return ExtendedSignature.sign(key, data, false);
    }

    public static byte[] sign(PrivateKey key, byte[] data, boolean savePublicKey) {
        try {
            Binder targetSignatureBinder = Binder.fromKeysValues("key", ExtendedSignature.keyId(key), "sha512", new Sha512().digest(data), "sha3_384", new Sha3_384().digest(data), "created_at", ZonedDateTime.now());
            if (savePublicKey) {
                targetSignatureBinder.put("pub_key", key.getPublicKey().pack());
            }
            byte[] targetSignature = Boss.pack(targetSignatureBinder);
            Binder result = Binder.fromKeysValues("exts", targetSignature, "sign", key.sign(targetSignature, HashType.SHA512), "sign2", key.sign(targetSignature, HashType.SHA3_384));
            return Boss.pack(result);
        }
        catch (EncryptionError e) {
            throw new RuntimeException("signature failed", e);
        }
    }

    public static Bytes keyId(AbstractKey key) {
        if (key instanceof PrivateKey) {
            return new Bytes(new byte[][]{key.getPublicKey().fingerprint()});
        }
        return new Bytes(new byte[][]{key.fingerprint()});
    }

    public static Bytes extractKeyId(byte[] signature) {
        Binder src = Boss.unpack(signature);
        return Boss.unpack(src.getBinaryOrThrow("exts")).getBytesOrThrow("key");
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public static ExtendedSignature verify(PublicKey key, byte[] signature, byte[] data) {
        block11: {
            try {
                Binder src = Boss.unpack(signature);
                ExtendedSignature es = new ExtendedSignature();
                byte[] exts = src.getBinaryOrThrow("exts");
                boolean isSignValid = key.verify(exts, src.getBinaryOrThrow("sign"), HashType.SHA512);
                boolean isSign2Valid = true;
                byte[] sign2bin = null;
                try {
                    sign2bin = src.getBinaryOrThrow("sign2");
                }
                catch (IllegalArgumentException e) {
                    sign2bin = null;
                }
                if (sign2bin != null) {
                    isSign2Valid = key.verify(exts, sign2bin, HashType.SHA3_384);
                }
                if (!isSignValid || !isSign2Valid) break block11;
                Binder b = Boss.unpack(exts);
                es.keyId = b.getBytesOrThrow("key");
                es.createdAt = b.getZonedDateTimeOrThrow("created_at");
                es.signature = signature;
                es.publicKey = null;
                try {
                    byte[] publicKeyBytes = b.getBinaryOrThrow("pub_key");
                    es.publicKey = new PublicKey(publicKeyBytes);
                }
                catch (IllegalArgumentException e) {
                    es.publicKey = null;
                }
                Bytes hash = b.getBytesOrThrow("sha512");
                Bytes dataHash = new Bytes(new byte[][]{new Sha512().digest(data)});
                boolean isHashValid = hash.equals(dataHash);
                Bytes hash2 = null;
                boolean isHash2Valid = true;
                try {
                    hash2 = b.getBytesOrThrow("sha3_384");
                }
                catch (IllegalArgumentException e) {
                    hash2 = null;
                }
                if (hash2 != null) {
                    Bytes dataHash2 = new Bytes(new byte[][]{new Sha3_384().digest(data)});
                    isHash2Valid = hash2.equals(dataHash2);
                }
                if (isHashValid && isHash2Valid) {
                    return es;
                }
            }
            catch (EncryptionError encryptionError) {
                encryptionError.printStackTrace();
            }
        }
        return null;
    }
}

