/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.Decimal;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.KeyRecord;
import com.icodici.universa.contract.roles.SimpleRole;
import com.icodici.universa.node2.Config;
import java.io.IOException;
import java.util.Set;
import net.sergeych.tools.Do;

public class InnerContractsService {
    public static synchronized Contract createFreshTU(int amount, Set<PublicKey> ownerKeys) throws IOException {
        return InnerContractsService.createFreshTU(amount, ownerKeys, false);
    }

    public static synchronized Contract createFreshTU(int amount, Set<PublicKey> ownerKeys, boolean withTestTU) throws IOException {
        PrivateKey manufacturePrivateKey = new PrivateKey(Do.read(Config.tuKeyPath));
        Contract tu = withTestTU ? Contract.fromDslFile(Config.testTUTemplatePath) : Contract.fromDslFile(Config.tuTemplatePath);
        SimpleRole ownerRole = new SimpleRole("owner");
        for (PublicKey k : ownerKeys) {
            KeyRecord kr = new KeyRecord(k);
            ownerRole.addKeyRecord(kr);
        }
        tu.registerRole(ownerRole);
        tu.createRole("owner", ownerRole);
        tu.getStateData().set("transaction_units", amount);
        if (withTestTU) {
            tu.getStateData().set("test_transaction_units", amount * 100);
        }
        tu.addSignerKey(manufacturePrivateKey);
        tu.seal();
        return tu;
    }

    public static Decimal getDecimalField(Contract contract, String fieldName) {
        Object valueObject = contract.getStateData().get(fieldName);
        if (valueObject instanceof String) {
            return new Decimal(Integer.valueOf((String)valueObject).intValue());
        }
        if (valueObject instanceof Decimal) {
            return (Decimal)valueObject;
        }
        return null;
    }
}

