/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.crypto.EncryptionError;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.contract.AnonymousId;
import java.util.Map;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Base64u;
import net.sergeych.utils.Bytes;

@BiType(name="KeyRecord")
public class KeyRecord
extends Binder
implements BiSerializable {
    private PublicKey publicKey;
    private AnonymousId anonymousId = null;

    private KeyRecord() {
    }

    public KeyRecord(Binder binder) {
        super((Map)binder);
        this.setupKey();
    }

    private void setupKey() {
        try {
            Object x = this.getOrThrow("key");
            this.remove("key");
            if (x instanceof PublicKey) {
                this.publicKey = (PublicKey)x;
            } else if (x instanceof PrivateKey) {
                this.publicKey = ((PrivateKey)x).getPublicKey();
            } else if (x instanceof String) {
                this.publicKey = new PublicKey(Base64u.decodeCompactString((String)x));
            } else {
                if (x instanceof Bytes) {
                    x = ((Bytes)x).toArray();
                }
                if (x instanceof byte[]) {
                    this.publicKey = new PublicKey((byte[])x);
                } else {
                    throw new IllegalArgumentException("unsupported key object: " + x.getClass().getName());
                }
            }
            this.put("key", this.publicKey);
        }
        catch (EncryptionError e) {
            throw new IllegalArgumentException("unsupported key, failed to construct", e);
        }
    }

    public KeyRecord(PublicKey key) {
        this.publicKey = key;
        this.put("key", key);
    }

    public KeyRecord(AnonymousId anonId) {
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.put("key", publicKey);
        this.publicKey = publicKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof KeyRecord) {
            return ((KeyRecord)o).publicKey.equals(this.publicKey);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.publicKey.hashCode();
    }

    public Binder serializeToBinder() {
        Binder data = new Binder();
        data.putAll(this);
        data.put("key", this.publicKey.pack());
        return data;
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        this.clear();
        this.putAll(data);
        deserializer.deserializeInPlace(this);
        this.setupKey();
    }

    @Override
    public Binder serialize(BiSerializer s) {
        Binder result = new Binder();
        result.putAll(this);
        result.put("key", s.serialize(this.publicKey));
        return result;
    }

    static {
        DefaultBiMapper.registerClass(KeyRecord.class);
    }
}

