/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.universa.HashId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.TransactionPack;
import com.icodici.universa.node2.Quantiser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;

@BiType(name="Parcel")
public class Parcel
implements BiSerializable {
    private byte[] packedBinary;
    private TransactionPack payload = null;
    private TransactionPack payment = null;
    private HashId hashId;
    private int quantasLimit = 0;
    private boolean isTestPayment = false;

    public int getQuantasLimit() {
        return this.quantasLimit;
    }

    public Parcel() {
    }

    public Parcel(TransactionPack payload, TransactionPack payment) {
        this.payload = payload;
        this.payment = payment;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write((byte[])payment.getContract().getId().getDigest().clone());
            outputStream.write((byte[])payload.getContract().getId().getDigest().clone());
            byte[] bytes = outputStream.toByteArray();
            this.hashId = HashId.of(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.prepareForNode();
    }

    public Parcel(Binder data) throws IOException {
        BiDeserializer biD = new BiDeserializer();
        this.deserialize(data, biD);
    }

    public TransactionPack getPayload() {
        return this.payload;
    }

    public TransactionPack getPayment() {
        return this.payment;
    }

    public void prepareForNode() {
        Contract parent = null;
        for (Contract c : this.payment.getContract().getRevoking()) {
            if (!c.getId().equals(this.payment.getContract().getParent())) continue;
            parent = c;
            break;
        }
        if (parent != null) {
            boolean hasTestTU;
            boolean bl = hasTestTU = this.payment.getContract().getStateData().get("test_transaction_units") != null;
            if (hasTestTU) {
                this.isTestPayment = true;
                this.quantasLimit = Quantiser.quantaPerUTN * (parent.getStateData().getIntOrThrow("test_transaction_units") - this.payment.getContract().getStateData().getIntOrThrow("test_transaction_units"));
                if (this.quantasLimit <= 0) {
                    this.isTestPayment = false;
                    this.quantasLimit = Quantiser.quantaPerUTN * (parent.getStateData().getIntOrThrow("transaction_units") - this.payment.getContract().getStateData().getIntOrThrow("transaction_units"));
                }
            } else {
                this.isTestPayment = false;
                this.quantasLimit = Quantiser.quantaPerUTN * (parent.getStateData().getIntOrThrow("transaction_units") - this.payment.getContract().getStateData().getIntOrThrow("transaction_units"));
            }
        }
        this.payment.getContract().setShouldBeTU(true);
        this.payment.getContract().setLimitedForTestnet(this.isTestPayment);
        this.payload.getContract().setLimitedForTestnet(this.isTestPayment);
    }

    public Contract getPayloadContract() {
        if (this.payload != null) {
            return this.payload.getContract();
        }
        return null;
    }

    public Contract getPaymentContract() {
        if (this.payment != null) {
            return this.payment.getContract();
        }
        return null;
    }

    public HashId getId() {
        return this.hashId;
    }

    @Override
    public synchronized Binder serialize(BiSerializer s) {
        return Binder.of("payload", this.payload.pack(), new Object[]{"payment", this.payment.pack(), "hashId", s.serialize(this.hashId)});
    }

    @Override
    public synchronized void deserialize(Binder data, BiDeserializer ds) throws IOException {
        this.payload = TransactionPack.unpack(data.getBinary("payload"));
        this.payment = TransactionPack.unpack(data.getBinary("payment"));
        this.hashId = (HashId)ds.deserialize(data.get("hashId"));
        this.prepareForNode();
    }

    public static synchronized Parcel unpack(byte[] packOrContractBytes) throws IOException {
        Object x = Boss.load(packOrContractBytes);
        if (x instanceof Parcel) {
            ((Parcel)x).packedBinary = packOrContractBytes;
            return (Parcel)x;
        }
        return null;
    }

    public synchronized byte[] pack() {
        if (this.packedBinary == null) {
            this.packedBinary = Boss.pack(this);
        }
        return this.packedBinary;
    }

    static {
        DefaultBiMapper.registerClass(Parcel.class);
    }
}

