/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.crypto.KeyAddress;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.Approvable;
import com.icodici.universa.HashId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.roles.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Base64u;
import net.sergeych.utils.Bytes;

public class Reference
implements BiSerializable {
    public String name = "";
    public int type = 2;
    public String transactional_id = "";
    public HashId contract_id = null;
    public boolean required = true;
    public HashId origin = null;
    public List<Role> signed_by = new ArrayList<Role>();
    public List<String> fields = new ArrayList<String>();
    public List<String> roles = new ArrayList<String>();
    public List<Approvable> matchingItems = new ArrayList<Approvable>();
    private Binder conditions = new Binder();
    private Contract baseContract;
    public static final int TYPE_TRANSACTIONAL = 1;
    public static final int TYPE_EXISTING = 2;
    final String[] operators = new String[]{" defined", " undefined", "<=", ">=", "<", ">", "!=", "==", " matches ", " is_inherit ", "inherit "};
    final int DEFINED = 0;
    final int UNDEFINED = 1;
    final int LESS_OR_EQUAL = 2;
    final int MORE_OR_EQUAL = 3;
    final int LESS = 4;
    final int MORE = 5;
    final int NOT_EQUAL = 6;
    final int EQUAL = 7;
    final int MATCHES = 8;
    final int IS_INHERIT = 9;
    final int INHERIT = 10;

    public Reference() {
    }

    public Reference(Contract contract) {
        this.baseContract = contract;
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        List<String> fields;
        this.name = data.getString("name", null);
        this.type = data.getInt("type", null);
        this.transactional_id = data.getString("transactional_id", "");
        this.contract_id = (HashId)deserializer.deserialize(data.get("contract_id"));
        this.origin = (HashId)deserializer.deserialize(data.get("origin"));
        this.signed_by = deserializer.deserializeCollection(data.getList("signed_by", new ArrayList()));
        List<String> roles = data.getList("roles", null);
        if (roles != null) {
            this.roles.clear();
            roles.forEach(this::addRole);
        }
        if ((fields = data.getList("fields", null)) != null) {
            this.fields.clear();
            fields.forEach(this::addField);
        }
        this.conditions = data.getBinder("where");
    }

    @Override
    public Binder serialize(BiSerializer s) {
        Binder data = new Binder();
        data.set("name", s.serialize(this.name));
        data.set("type", s.serialize(this.type));
        data.set("transactional_id", s.serialize(this.transactional_id));
        if (this.contract_id != null) {
            data.set("contract_id", s.serialize(this.contract_id));
        }
        data.set("required", s.serialize(this.required));
        if (this.origin != null) {
            data.set("origin", s.serialize(this.origin));
        }
        data.set("signed_by", s.serialize(this.signed_by));
        data.set("roles", s.serialize(this.roles));
        data.set("fields", s.serialize(this.fields));
        data.set("where", s.serialize(this.conditions));
        return data;
    }

    public boolean equals(Reference a) {
        Binder dataThis = this.serialize(new BiSerializer());
        Binder dataA = a.serialize(new BiSerializer());
        return dataThis.equals(dataA);
    }

    private boolean isObjectMayCastToDouble(Object obj) throws Exception {
        return obj.getClass().getName().endsWith("Float") || obj.getClass().getName().endsWith("Double");
    }

    private boolean isObjectMayCastToLong(Object obj) throws Exception {
        return obj.getClass().getName().endsWith("Byte") || obj.getClass().getName().endsWith("Short") || obj.getClass().getName().endsWith("Integer") || obj.getClass().getName().endsWith("Long");
    }

    private double objectCastToDouble(Object obj) throws Exception {
        if (!obj.getClass().getName().endsWith("Float") && !obj.getClass().getName().endsWith("Double")) {
            throw new IllegalArgumentException("Expected floating point number operand in condition.");
        }
        double val = (Double)obj;
        return val;
    }

    private long objectCastToLong(Object obj) throws Exception {
        long val;
        if (obj.getClass().getName().endsWith("Byte")) {
            val = ((Byte)obj).byteValue();
        } else if (obj.getClass().getName().endsWith("Short")) {
            val = ((Short)obj).shortValue();
        } else if (obj.getClass().getName().endsWith("Integer")) {
            val = ((Integer)obj).intValue();
        } else if (obj.getClass().getName().endsWith("Long")) {
            val = (Long)obj;
        } else {
            throw new IllegalArgumentException("Expected number operand in condition.");
        }
        return val;
    }

    private boolean compareOperands(Contract refContract, String leftOperand, String rightOperand, compareOperandType typeOfRightOperand, int indxOperator, Collection<Contract> contracts, int iteration) {
        Reference ref;
        int firstPointPos;
        boolean ret = false;
        Contract leftOperandContract = null;
        Contract rightOperandContract = null;
        Object left = null;
        Object right = null;
        double leftValD = 0.0;
        double rightValD = 0.0;
        long leftValL = 0L;
        long rightValL = 0L;
        boolean isLeftDouble = false;
        boolean isRightDouble = false;
        if (leftOperand != null) {
            if (leftOperand.startsWith("ref.")) {
                leftOperand = leftOperand.substring(4);
                leftOperandContract = refContract;
            } else if (leftOperand.startsWith("this.")) {
                if (this.baseContract == null) {
                    throw new IllegalArgumentException("Use left operand in condition: " + leftOperand + ". But this contract not initialized.");
                }
                leftOperand = leftOperand.substring(5);
                leftOperandContract = this.baseContract;
            } else {
                firstPointPos = leftOperand.indexOf(".");
                if (firstPointPos > 0) {
                    if (this.baseContract == null) {
                        throw new IllegalArgumentException("Use left operand in condition: " + leftOperand + ". But this contract not initialized.");
                    }
                    ref = this.baseContract.findReferenceByName(leftOperand.substring(0, firstPointPos));
                    if (ref == null) {
                        throw new IllegalArgumentException("Not found reference: " + leftOperand.substring(0, firstPointPos));
                    }
                    for (Contract checkedContract : contracts) {
                        if (!ref.isMatchingWith(checkedContract, contracts, iteration + 1)) continue;
                        leftOperandContract = checkedContract;
                    }
                    if (leftOperandContract == null) {
                        return false;
                    }
                    leftOperand = leftOperand.substring(firstPointPos + 1);
                } else {
                    throw new IllegalArgumentException("Invalid format of left operand in condition: " + leftOperand + ". Missing contract field.");
                }
            }
        }
        if (rightOperand != null) {
            if (typeOfRightOperand == compareOperandType.FIELD) {
                if (rightOperand.startsWith("ref.")) {
                    rightOperand = rightOperand.substring(4);
                    rightOperandContract = refContract;
                } else if (rightOperand.startsWith("this.")) {
                    if (this.baseContract == null) {
                        throw new IllegalArgumentException("Use right operand in condition: " + rightOperand + ". But this contract not initialized.");
                    }
                    rightOperand = rightOperand.substring(5);
                    rightOperandContract = this.baseContract;
                } else {
                    firstPointPos = rightOperand.indexOf(".");
                    if (firstPointPos > 0) {
                        if (this.baseContract == null) {
                            throw new IllegalArgumentException("Use right operand in condition: " + rightOperand + ". But this contract not initialized.");
                        }
                        ref = this.baseContract.findReferenceByName(rightOperand.substring(0, firstPointPos));
                        if (ref == null) {
                            throw new IllegalArgumentException("Not found reference: " + rightOperand.substring(0, firstPointPos));
                        }
                        for (Contract checkedContract : contracts) {
                            if (!ref.isMatchingWith(checkedContract, contracts, iteration + 1)) continue;
                            rightOperandContract = checkedContract;
                        }
                        if (rightOperandContract == null) {
                            return false;
                        }
                        rightOperand = rightOperand.substring(firstPointPos + 1);
                    } else {
                        throw new IllegalArgumentException("Invalid format of right operand in condition: " + rightOperand + ". Missing contract field.");
                    }
                }
            }
            if (leftOperandContract != null) {
                left = leftOperandContract.get(leftOperand);
            }
            if (rightOperandContract != null) {
                right = rightOperandContract.get(rightOperand);
            }
            try {
                switch (indxOperator) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (left == null) break;
                        if (typeOfRightOperand == compareOperandType.FIELD) {
                            if (right == null) break;
                            isLeftDouble = this.isObjectMayCastToDouble(left);
                            if (isLeftDouble) {
                                leftValD = this.objectCastToDouble(left);
                            } else {
                                leftValL = this.objectCastToLong(left);
                            }
                            isRightDouble = this.isObjectMayCastToDouble(right);
                            if (isRightDouble) {
                                rightValD = this.objectCastToDouble(right);
                            } else {
                                rightValL = this.objectCastToLong(right);
                            }
                            if (!(indxOperator == 4 && (isLeftDouble ? leftValD : (double)leftValL) < (isRightDouble ? rightValD : (double)rightValL) || indxOperator == 5 && (isLeftDouble ? leftValD : (double)leftValL) > (isRightDouble ? rightValD : (double)rightValL) || indxOperator == 2 && (isLeftDouble ? leftValD : (double)leftValL) <= (isRightDouble ? rightValD : (double)rightValL))) {
                                if (indxOperator != 3) break;
                                double d = isLeftDouble ? leftValD : (double)leftValL;
                                double d2 = isRightDouble ? rightValD : (double)rightValL;
                                if (!(d >= d2)) break;
                            }
                            ret = true;
                            break;
                        }
                        if (typeOfRightOperand == compareOperandType.CONSTOTHER) {
                            isLeftDouble = this.isObjectMayCastToDouble(left);
                            if (isLeftDouble) {
                                leftValD = this.objectCastToDouble(left);
                            } else {
                                leftValL = this.objectCastToLong(left);
                            }
                            if (rightOperand == "null" || rightOperand == "false" || rightOperand == "true") break;
                            if (!(rightOperand.contains(".") && (indxOperator == 4 && (isLeftDouble ? leftValD : (double)leftValL) < Double.parseDouble(rightOperand) || indxOperator == 5 && (isLeftDouble ? leftValD : (double)leftValL) > Double.parseDouble(rightOperand) || indxOperator == 2 && (isLeftDouble ? leftValD : (double)leftValL) <= Double.parseDouble(rightOperand) || indxOperator == 3 && (isLeftDouble ? leftValD : (double)leftValL) >= Double.parseDouble(rightOperand)))) {
                                if (rightOperand.contains(".")) break;
                                if (!(indxOperator == 4 && (isLeftDouble ? leftValD : (double)leftValL) < (double)Long.parseLong(rightOperand) || indxOperator == 5 && (isLeftDouble ? leftValD : (double)leftValL) > (double)Long.parseLong(rightOperand) || indxOperator == 2 && (isLeftDouble ? leftValD : (double)leftValL) <= (double)Long.parseLong(rightOperand))) {
                                    if (indxOperator != 3) break;
                                    double d = isLeftDouble ? leftValD : (double)leftValL;
                                    if (!(d >= (double)Long.parseLong(rightOperand))) break;
                                }
                            }
                            ret = true;
                            break;
                        }
                        throw new IllegalArgumentException("Invalid operator for string in condition: " + this.operators[indxOperator]);
                    }
                    case 6: 
                    case 7: {
                        if (left != null && left.getClass().getName().endsWith("HashId")) {
                            ret = right != null && right.getClass().getName().endsWith("HashId") ? ((HashId)left).toBase64String().equals(((HashId)right).toBase64String()) : (right != null && right.getClass().getName().endsWith("String") ? ((HashId)left).toBase64String().equals((String)right) : ((HashId)left).toBase64String().equals(rightOperand));
                            if (indxOperator != 6) break;
                            ret = !ret;
                            break;
                        }
                        if (typeOfRightOperand == compareOperandType.FIELD) {
                            if (left == null || right == null) break;
                            boolean isNumbers = true;
                            isLeftDouble = this.isObjectMayCastToDouble(left);
                            if (isLeftDouble) {
                                leftValD = this.objectCastToDouble(left);
                            } else if (this.isObjectMayCastToLong(left)) {
                                leftValL = this.objectCastToLong(left);
                            } else {
                                isNumbers = false;
                            }
                            if (isNumbers) {
                                isRightDouble = this.isObjectMayCastToDouble(right);
                                if (isRightDouble) {
                                    rightValD = this.objectCastToDouble(right);
                                } else if (this.isObjectMayCastToLong(right)) {
                                    rightValL = this.objectCastToLong(right);
                                } else {
                                    isNumbers = false;
                                }
                            }
                            if (isNumbers && (isLeftDouble && !isRightDouble || !isLeftDouble && isRightDouble)) {
                                if ((indxOperator != 6 || (isLeftDouble ? leftValD : (double)leftValL) == (isRightDouble ? rightValD : (double)rightValL)) && (indxOperator != 7 || (isLeftDouble ? leftValD : (double)leftValL) != (isRightDouble ? rightValD : (double)rightValL))) break;
                                ret = true;
                                break;
                            }
                            if ((indxOperator != 6 || left.equals(right)) && (indxOperator != 7 || !left.equals(right))) break;
                            ret = true;
                            break;
                        }
                        if (left != null && (left.getClass().getName().endsWith("Role") || left.getClass().getName().endsWith("RoleLink"))) {
                            try {
                                rightOperand = rightOperand.replaceAll("\\s+", "");
                                if (rightOperand.length() > 72) {
                                    PublicKey publicKey = new PublicKey(Base64u.decodeCompactString(rightOperand));
                                    HashSet<PublicKey> keys = new HashSet<PublicKey>();
                                    keys.add(publicKey);
                                    ret = ((Role)left).isAllowedForKeys(keys);
                                } else {
                                    KeyAddress ka = new KeyAddress(rightOperand);
                                    ret = ((Role)left).isMatchingKeyAddress(ka);
                                }
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("Key or address compare error in condition: " + e.getMessage());
                            }
                            if (indxOperator != 6) break;
                            ret = !ret;
                            break;
                        }
                        if (typeOfRightOperand == compareOperandType.CONSTOTHER) {
                            if (!(rightOperand.equals("null") || rightOperand.equals("false") || rightOperand.equals("true"))) {
                                if (left == null) break;
                                if (this.isObjectMayCastToDouble(left)) {
                                    leftValD = this.objectCastToDouble(left);
                                    Double leftDouble = new Double(leftValD);
                                    if (!(rightOperand.contains(".") && (indxOperator == 6 && !leftDouble.equals(Double.parseDouble(rightOperand)) || indxOperator == 7 && leftDouble.equals(Double.parseDouble(rightOperand)))) && (rightOperand.contains(".") || (indxOperator != 6 || leftValD == (double)Long.parseLong(rightOperand)) && (indxOperator != 7 || leftValD != (double)Long.parseLong(rightOperand)))) break;
                                    ret = true;
                                    break;
                                }
                                leftValL = this.objectCastToLong(left);
                                Long leftLong = new Long(leftValL);
                                if (!(!rightOperand.contains(".") && (indxOperator == 6 && !leftLong.equals(Long.parseLong(rightOperand)) || indxOperator == 7 && leftLong.equals(Long.parseLong(rightOperand)))) && (!rightOperand.contains(".") || (indxOperator != 6 || (double)leftValL == Double.parseDouble(rightOperand)) && (indxOperator != 7 || (double)leftValL != Double.parseDouble(rightOperand)))) break;
                                ret = true;
                                break;
                            }
                            if (!(indxOperator == 6 && (rightOperand.equals("null") && left != null || rightOperand.equals("true") && left != null && (Boolean)left == false || rightOperand.equals("false") && left != null && (Boolean)left != false)) && (indxOperator != 7 || !(rightOperand.equals("null") && left == null || rightOperand.equals("true") && left != null && (Boolean)left != false) && (!rightOperand.equals("false") || left == null || ((Boolean)left).booleanValue()))) break;
                            ret = true;
                            break;
                        }
                        if (typeOfRightOperand != compareOperandType.CONSTSTR || left == null || (indxOperator != 6 || left.equals(rightOperand)) && (indxOperator != 7 || !left.equals(rightOperand))) break;
                        ret = true;
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        ret = true;
                        break;
                    }
                    case 10: {
                        if (right == null || !right.getClass().getName().endsWith("Reference")) {
                            throw new IllegalArgumentException("Expected reference in right operand in condition: " + rightOperand);
                        }
                        ret = ((Reference)right).isMatchingWith(refContract, contracts, iteration + 1);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid operator in condition");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Error compare operands in condition: " + e.getMessage());
            }
        } else if (indxOperator == 0) {
            try {
                if (leftOperandContract.get(leftOperand) != null) {
                    ret = true;
                }
            }
            catch (Exception e) {}
        } else if (indxOperator == 1) {
            try {
                ret = leftOperandContract.get(leftOperand) == null;
            }
            catch (Exception e) {
                ret = true;
            }
        } else {
            throw new IllegalArgumentException("Invalid operator in condition");
        }
        return ret;
    }

    private boolean checkCondition(String condition, Contract ref, Collection<Contract> contracts, int iteration) {
        int operPos;
        int i;
        for (i = 0; i < 2; ++i) {
            operPos = condition.lastIndexOf(this.operators[i]);
            if (operPos < 0 || condition.length() - this.operators[i].length() != operPos) continue;
            String leftOperand = condition.substring(0, operPos).replaceAll("\\s+", "");
            return this.compareOperands(ref, leftOperand, null, compareOperandType.CONSTOTHER, i, contracts, iteration);
        }
        for (i = 2; i < 10; ++i) {
            String rightOperand;
            operPos = condition.indexOf(this.operators[i]);
            int markPos = condition.indexOf("\"");
            if (operPos < 0 || markPos >= 0 && operPos > markPos) continue;
            String leftOperand = condition.substring(0, operPos).replaceAll("\\s+", "");
            String subStrR = condition.substring(operPos + this.operators[i].length());
            if (subStrR.length() == 0) {
                throw new IllegalArgumentException("Invalid format of condition: " + condition + ". Missing right operand.");
            }
            int rmarkPos1 = subStrR.indexOf("\"");
            int rmarkPos2 = subStrR.lastIndexOf("\"");
            if (rmarkPos1 >= 0 && rmarkPos1 == rmarkPos2) {
                throw new IllegalArgumentException("Invalid format of condition: " + condition + ". Only one quote is found for string.");
            }
            compareOperandType typeRightOperand = compareOperandType.CONSTOTHER;
            if (rmarkPos1 >= 0 && rmarkPos1 != rmarkPos2) {
                rightOperand = subStrR.substring(rmarkPos1 + 1, rmarkPos2);
                typeRightOperand = compareOperandType.CONSTSTR;
            } else {
                rightOperand = subStrR.replaceAll("\\s+", "");
                int firstPointPos = rightOperand.indexOf(".");
                if (firstPointPos > 0 && rightOperand.length() > firstPointPos + 1 && (rightOperand.charAt(firstPointPos + 1) < '0' || rightOperand.charAt(firstPointPos + 1) > '9')) {
                    typeRightOperand = compareOperandType.FIELD;
                }
            }
            return this.compareOperands(ref, leftOperand, rightOperand, typeRightOperand, i, contracts, iteration);
        }
        int operPos2 = condition.indexOf(this.operators[10]);
        if (operPos2 == 0 || operPos2 > 0 && condition.charAt(operPos2 - 1) != '_') {
            String subStrR = condition.substring(operPos2 + this.operators[10].length());
            if (subStrR.length() == 0) {
                throw new IllegalArgumentException("Invalid format of condition: " + condition + ". Missing right operand.");
            }
            String rightOperand = subStrR.replaceAll("\\s+", "");
            return this.compareOperands(ref, null, rightOperand, compareOperandType.FIELD, 10, contracts, iteration);
        }
        throw new IllegalArgumentException("Invalid format of condition: " + condition);
    }

    private boolean checkConditions(Binder conditions, Contract ref, Collection<Contract> contracts, int iteration) {
        boolean result;
        if (conditions == null || conditions.size() == 0) {
            return true;
        }
        if (conditions.containsKey(conditionsModeType.all_of.name())) {
            List condList = conditions.getList(conditionsModeType.all_of.name(), null);
            if (condList == null) {
                throw new IllegalArgumentException("Expected all_of conditions");
            }
            result = true;
            for (Object item : condList) {
                if (item.getClass().getName().endsWith("String")) {
                    result = result && this.checkCondition((String)item, ref, contracts, iteration);
                    continue;
                }
                result = result && this.checkConditions((Binder)item, ref, contracts, iteration);
            }
        } else if (conditions.containsKey(conditionsModeType.any_of.name())) {
            List condList = conditions.getList(conditionsModeType.any_of.name(), null);
            if (condList == null) {
                throw new IllegalArgumentException("Expected any_of conditions");
            }
            result = false;
            for (Object item : condList) {
                if (item.getClass().getName().endsWith("String")) {
                    result = result || this.checkCondition((String)item, ref, contracts, iteration);
                    continue;
                }
                result = result || this.checkConditions((Binder)item, ref, contracts, iteration);
            }
        } else {
            throw new IllegalArgumentException("Expected all_of or any_of");
        }
        return result;
    }

    public boolean isValid() {
        return this.matchingItems.size() > 0;
    }

    public boolean isMatchingWith(Approvable a, Collection<Contract> contracts) {
        return this.isMatchingWith(a, contracts, 0);
    }

    public boolean isMatchingWith(Approvable a, Collection<Contract> contracts, int iteration) {
        if (iteration > 16) {
            throw new IllegalArgumentException("Recursive checking references have more 16 iterations");
        }
        boolean result = true;
        if (a instanceof Contract) {
            Contract contract = (Contract)a;
            if (result) {
                Map<String, Role> contractRoles = contract.getRoles();
                boolean bl = result = this.roles.isEmpty() || this.roles.stream().anyMatch(role -> contractRoles.containsKey(role));
            }
            if (result) {
                boolean bl = result = this.origin == null || !contract.getOrigin().equals(this.origin);
            }
            if (result) {
                Binder stateData = contract.getStateData();
                boolean bl = result = this.fields.isEmpty() || this.fields.stream().anyMatch(field2 -> stateData.get(field2) != null);
            }
            if (result) {
                result = this.checkConditions(this.conditions, contract, contracts, iteration);
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Reference setName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Reference addRole(String role) {
        this.roles.add(role);
        return this;
    }

    public Reference setRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Reference addField(String field2) {
        this.fields.add(field2);
        return this;
    }

    public Reference setFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public Binder getConditions() {
        return this.conditions;
    }

    public Reference setConditions(Binder conditions) {
        this.conditions = conditions;
        return this;
    }

    public Reference addMatchingItem(Approvable a) {
        this.matchingItems.add(a);
        return this;
    }

    public Contract getContract() {
        return this.baseContract;
    }

    public Reference setContract(Contract contract) {
        this.baseContract = contract;
        return this;
    }

    public String toString() {
        String res = "{";
        res = res + "name:" + this.name;
        res = res + ", type:" + this.type;
        res = this.transactional_id.length() > 8 ? res + ", transactional_id:" + this.transactional_id.substring(0, 8) + "..." : res + ", transactional_id:" + this.transactional_id;
        res = res + ", contract_id:" + this.contract_id;
        res = res + ", required:" + this.required;
        res = res + ", origin:" + this.origin;
        res = res + ", signed_by:[";
        for (int i = 0; i < this.signed_by.size(); ++i) {
            if (i > 0) {
                res = res + ", ";
            }
            Role r = this.signed_by.get(i);
            res = res + r.getName() + ":" + Bytes.toHex(r.getKeys().iterator().next().fingerprint()).substring(0, 8) + "...";
        }
        res = res + "]";
        res = res + "}";
        return res;
    }

    static {
        DefaultBiMapper.registerClass(Reference.class);
    }

    static enum compareOperandType {
        FIELD,
        CONSTSTR,
        CONSTOTHER;

    }

    static enum conditionsModeType {
        all_of,
        any_of,
        simple_condition;

    }
}

