/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract;

import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.HashId;
import com.icodici.universa.HashIdentifiable;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.node2.Quantiser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.boss.Boss;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Bytes;

@BiType(name="TransactionPack")
public class TransactionPack
implements BiSerializable {
    private byte[] packedBinary;
    private boolean reconstructed = false;
    private Map<HashId, Contract> subItems = new HashMap<HashId, Contract>();
    private Map<HashId, Contract> referencedItems = new HashMap<HashId, Contract>();
    private Set<PublicKey> keysForPack = new HashSet<PublicKey>();
    private Contract contract;

    public TransactionPack(Contract contract) {
        this();
        this.setContract(contract);
    }

    public Contract getContract() {
        return this.contract;
    }

    public Contract getSubItem(HashId id) {
        return this.subItems.get(id);
    }

    public Contract getSubItem(HashIdentifiable hid) {
        return this.getSubItem(hid.getId());
    }

    public Set<PublicKey> getKeysForPack() {
        return this.keysForPack;
    }

    public TransactionPack() {
    }

    public void setContract(Contract c) {
        if (this.contract != null) {
            throw new IllegalArgumentException("the contract is already added");
        }
        this.contract = c;
        this.packedBinary = null;
        this.extractAllSubItemsAndReferenced(c);
        c.setTransactionPack(this);
        for (PrivateKey key : c.getKeysToSignWith()) {
            this.addKeys(key.getPublicKey());
        }
    }

    protected synchronized void extractAllSubItemsAndReferenced(Contract c) {
        for (Contract contract : c.getRevoking()) {
            this.putSubItem(contract);
            for (Contract contract2 : contract.getReferenced()) {
                this.addReferencedItem(contract2);
            }
        }
        for (Contract contract : c.getNew()) {
            this.putSubItem(contract);
            this.extractAllSubItemsAndReferenced(contract);
        }
        for (Contract contract : c.getReferenced()) {
            this.addReferencedItem(contract);
        }
    }

    public void addSubItem(Contract subItem) {
        if (!this.subItems.containsKey(subItem.getId())) {
            this.packedBinary = null;
            this.subItems.put(subItem.getId(), subItem);
        }
    }

    public void addReferencedItem(Contract referencedItem) {
        if (!this.referencedItems.containsKey(referencedItem.getId())) {
            this.packedBinary = null;
            this.referencedItems.put(referencedItem.getId(), referencedItem);
        }
    }

    public void addKeys(PublicKey ... keys) {
        this.packedBinary = null;
        for (PublicKey key : keys) {
            if (this.keysForPack.contains(key)) continue;
            this.keysForPack.add(key);
        }
    }

    protected synchronized void putSubItem(Contract subItem) {
        this.subItems.put(subItem.getId(), subItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) throws IOException {
        TransactionPack transactionPack = this;
        synchronized (transactionPack) {
            List foreignReferenceBytesList;
            Quantiser quantiser = new Quantiser();
            quantiser.reset(Contract.getTestQuantaLimit());
            List keysList = deserializer.deserializeCollection(data.getList("keys", new ArrayList()));
            this.keysForPack = new HashSet<PublicKey>();
            if (keysList != null) {
                for (Object x : keysList) {
                    if (x instanceof Bytes) {
                        x = ((Bytes)x).toArray();
                    }
                    if (x instanceof byte[]) {
                        this.keysForPack.add(new PublicKey((byte[])x));
                        continue;
                    }
                    throw new IllegalArgumentException("unsupported key object: " + x.getClass().getName());
                }
            }
            if ((foreignReferenceBytesList = deserializer.deserializeCollection(data.getList("referencedItems", new ArrayList()))) != null) {
                for (Bytes b : foreignReferenceBytesList) {
                    Contract frc = new Contract(b.toArray(), this);
                    quantiser.addWorkCostFrom(frc.getQuantiser());
                    this.referencedItems.put(frc.getId(), frc);
                }
            }
            List subItemsBytesList = deserializer.deserializeCollection(data.getListOrThrow("subItems"));
            HashMap<ContractDependencies, Bytes> allContractsTrees = new HashMap<ContractDependencies, Bytes>();
            ArrayList<HashId> allContractsHids = new ArrayList<HashId>();
            ArrayList sortedSubItemsBytesList = new ArrayList();
            if (subItemsBytesList != null) {
                Contract c;
                ContractDependencies ct2;
                for (Bytes b : subItemsBytesList) {
                    ct2 = new ContractDependencies(b.toArray());
                    allContractsTrees.put(ct2, b);
                    allContractsHids.add(ct2.id);
                }
                do {
                    sortedSubItemsBytesList = new ArrayList();
                    Object removingContractDependencies = new ArrayList<ContractDependencies>();
                    for (ContractDependencies ct2 : allContractsTrees.keySet()) {
                        if (ct2.dependencies.size() != 0) continue;
                        sortedSubItemsBytesList.add(allContractsTrees.get(ct2));
                        removingContractDependencies.add(ct2);
                    }
                    Iterator<Object> b = removingContractDependencies.iterator();
                    while (b.hasNext()) {
                        ct2 = (ContractDependencies)b.next();
                        allContractsTrees.remove(ct2);
                    }
                    removingContractDependencies = new ArrayList();
                    for (ContractDependencies ct2 : allContractsTrees.keySet()) {
                        boolean allDependenciesSafe = true;
                        for (HashId hid : ct2.dependencies) {
                            if (this.subItems.containsKey(hid) || !allContractsHids.contains(hid)) continue;
                            allDependenciesSafe = false;
                        }
                        if (!allDependenciesSafe) continue;
                        sortedSubItemsBytesList.add(allContractsTrees.get(ct2));
                        removingContractDependencies.add(ct2);
                    }
                    b = removingContractDependencies.iterator();
                    while (b.hasNext()) {
                        ct2 = (ContractDependencies)b.next();
                        allContractsTrees.remove(ct2);
                    }
                    for (int i = 0; i < sortedSubItemsBytesList.size(); ++i) {
                        c = new Contract(((Bytes)sortedSubItemsBytesList.get(i)).toArray(), this);
                        quantiser.addWorkCostFrom(c.getQuantiser());
                        this.subItems.put(c.getId(), c);
                    }
                } while (sortedSubItemsBytesList.size() != 0);
                for (Bytes b : allContractsTrees.values()) {
                    c = new Contract(b.toArray(), this);
                    quantiser.addWorkCostFrom(c.getQuantiser());
                    this.subItems.put(c.getId(), c);
                }
            }
            byte[] bb = data.getBinaryOrThrow("contract");
            this.contract = new Contract(bb, this);
            quantiser.addWorkCostFrom(this.contract.getQuantiser());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binder serialize(BiSerializer serializer) {
        TransactionPack transactionPack = this;
        synchronized (transactionPack) {
            Binder of = Binder.of("contract", this.contract.getLastSealedBinary(), new Object[]{"subItems", serializer.serialize(this.subItems.values().stream().map(x -> x.getLastSealedBinary()).collect(Collectors.toList()))});
            if (this.referencedItems.size() > 0) {
                of.set("referencedItems", serializer.serialize(this.referencedItems.values().stream().map(x -> x.getLastSealedBinary()).collect(Collectors.toList())));
            }
            if (this.keysForPack.size() > 0) {
                of.set("keys", serializer.serialize(this.keysForPack.stream().map(x -> x.pack()).collect(Collectors.toList())));
            }
            return of;
        }
    }

    public final boolean isReconstructed() {
        return this.reconstructed;
    }

    public static TransactionPack unpack(byte[] packOrContractBytes, boolean allowNonTransactions) throws IOException {
        Object x = Boss.load(packOrContractBytes);
        if (x instanceof TransactionPack) {
            return (TransactionPack)x;
        }
        if (!allowNonTransactions) {
            throw new IOException("expected transaction pack");
        }
        TransactionPack tp = new TransactionPack();
        tp.reconstructed = true;
        tp.packedBinary = packOrContractBytes;
        tp.contract = new Contract(packOrContractBytes, tp);
        return tp;
    }

    public static TransactionPack unpack(byte[] packOrContractBytes) throws IOException {
        return TransactionPack.unpack(packOrContractBytes, true);
    }

    public synchronized byte[] pack() {
        if (this.packedBinary == null) {
            this.packedBinary = Boss.pack(this);
        }
        return this.packedBinary;
    }

    public Map<HashId, Contract> getSubItems() {
        return this.subItems;
    }

    public Map<HashId, Contract> getReferencedItems() {
        return this.referencedItems;
    }

    public void trace() {
        System.out.println("Transaction pack");
        System.out.println("\tContract:");
        System.out.println("\t\t" + this.contract.getId());
        this.contract.getNewItems().forEach(x -> System.out.println("\t\t\tnew: " + x.getId()));
        this.contract.getRevokingItems().forEach(x -> System.out.println("\t\t\trevoke: " + x.getId()));
        System.out.println("\tSubItems:");
        this.subItems.forEach((hashId, contract) -> System.out.println("\t\t" + hashId + " -> " + contract.getId()));
    }

    static {
        DefaultBiMapper.registerClass(TransactionPack.class);
    }

    public class ContractDependencies {
        private final Set<HashId> dependencies = new HashSet<HashId>();
        private final HashId id;

        public ContractDependencies(byte[] sealed) throws IOException {
            this.id = HashId.of(sealed);
            Binder data = Boss.unpack(sealed);
            byte[] contractBytes = data.getBinaryOrThrow("data");
            Binder payload = (Binder)Boss.load(contractBytes, null);
            int apiLevel = data.getIntOrThrow("version");
            if (apiLevel >= 3) {
                HashId hid;
                for (Binder b : payload.getList("revoking", Collections.EMPTY_LIST)) {
                    hid = HashId.withDigest(b.getBinaryOrThrow("composite3"));
                    this.dependencies.add(hid);
                }
                for (Binder b : payload.getList("new", Collections.EMPTY_LIST)) {
                    hid = HashId.withDigest(b.getBinaryOrThrow("composite3"));
                    this.dependencies.add(hid);
                }
            }
        }
    }
}

