/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.permissions;

import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.roles.Role;
import java.util.Map;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.diff.ChangedItem;
import net.sergeych.diff.Delta;
import net.sergeych.diff.MapDelta;
import net.sergeych.tools.Binder;

public class ChangeNumberPermission
extends Permission {
    private int minValue;
    private int maxValue;
    private int minStep;
    private int maxStep;
    private String fieldName;
    private int newValue;

    public ChangeNumberPermission(Role role, Binder params) {
        super("decrement_permission", role, params);
        this.initFromParams();
    }

    private ChangeNumberPermission() {
    }

    protected void initFromParams() {
        this.fieldName = this.params.getStringOrThrow("field_name");
        this.minValue = this.params.getInt("min_value", 0);
        this.minStep = this.params.getInt("min_step", Integer.MIN_VALUE);
        this.maxStep = this.params.getInt("max_step", Integer.MAX_VALUE);
        this.maxValue = this.params.getInt("max_value", Integer.MAX_VALUE);
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        super.deserialize(data, deserializer);
        this.initFromParams();
    }

    @Override
    public void checkChanges(Contract contract, Contract changed, Map<String, Delta> stateChanges) {
        MapDelta dataChanges = (MapDelta)stateChanges.get("data");
        if (dataChanges == null) {
            return;
        }
        Delta delta = dataChanges.getChange(this.fieldName);
        if (delta != null) {
            if (!(delta instanceof ChangedItem)) {
                return;
            }
            try {
                int valueDelta = (Integer)delta.newValue() - (Integer)delta.oldValue();
                if (valueDelta < this.minStep || valueDelta > this.maxStep) {
                    return;
                }
                this.newValue = (Integer)delta.newValue();
                if (this.newValue > this.maxValue || this.newValue < this.minValue) {
                    return;
                }
                dataChanges.remove(this.fieldName);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    static {
        DefaultBiMapper.registerClass(ChangeNumberPermission.class);
    }
}

