/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.permissions;

import com.icodici.universa.Errors;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.roles.Role;
import java.util.Map;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.diff.Delta;
import net.sergeych.diff.MapDelta;

@BiType(name="ChangeOwnerPermission")
public class ChangeOwnerPermission
extends Permission {
    public ChangeOwnerPermission(Role role) {
        super("change_owner", role);
    }

    private ChangeOwnerPermission() {
    }

    @Override
    public void checkChanges(Contract contract, Contract changed, Map<String, Delta> stateChanges) {
        Delta x = stateChanges.get("owner");
        if (x != null) {
            stateChanges.remove("owner");
            if (!(x instanceof MapDelta)) {
                contract.addError(Errors.BAD_VALUE, "state.owner", "improper change");
            } else {
                Delta ci = x;
                if (!(ci.newValue() instanceof Role)) {
                    contract.addError(Errors.BAD_VALUE, "state.owner", "improper change (new value not a role)");
                }
            }
        }
    }

    static {
        DefaultBiMapper.registerClass(ChangeOwnerPermission.class);
    }
}

