/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.permissions;

import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.roles.Role;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.diff.ChangedItem;
import net.sergeych.diff.Delta;
import net.sergeych.diff.ListDelta;
import net.sergeych.diff.MapDelta;
import net.sergeych.tools.Binder;

@BiType(name="ModifyDataPermission")
public class ModifyDataPermission
extends Permission {
    public static final String FIELD_NAME = "modify_data";
    private Map<String, List<String>> fields = new HashMap<String, List<String>>();
    private Set<String> rootFields = new HashSet<String>(Arrays.asList("references"));

    public ModifyDataPermission() {
    }

    public ModifyDataPermission(Role role, Binder params) {
        super(FIELD_NAME, role, params);
        Object fields = params.get("fields");
        if (fields != null && fields instanceof Map) {
            this.fields.putAll((Map)fields);
        }
    }

    public ModifyDataPermission addField(String fieldName, List<String> values) {
        this.fields.put(fieldName, values);
        return this;
    }

    public void addAllFields(Map<String, List<String>> fields) {
        this.fields.putAll(fields);
    }

    @Override
    public void checkChanges(Contract contract, Contract changedContract, Map<String, Delta> stateChanges) {
        Delta data = stateChanges.get("data");
        if (data != null && data instanceof MapDelta) {
            Map mapChanges = ((MapDelta)data).getChanges();
            mapChanges.keySet().removeIf(key -> {
                Object changed = mapChanges.get(key);
                String value = "";
                if (changed != null && changed instanceof ChangedItem) {
                    value = ((ChangedItem)mapChanges.get(key)).newValue();
                }
                boolean containsField = this.fields.containsKey(key);
                List<String> foundField = this.fields.get(key);
                return containsField && foundField == null || foundField != null && foundField.contains(value) || this.isEmptyOrNull(foundField, value);
            });
        }
        for (String rootField : this.rootFields) {
            Map mapChanges;
            boolean containsField = this.fields.containsKey("/" + rootField);
            List<String> foundField = this.fields.get("/" + rootField);
            Delta rootFieldChanges = stateChanges.get(rootField);
            if (rootFieldChanges == null || (mapChanges = rootFieldChanges instanceof ListDelta ? ((ListDelta)rootFieldChanges).getChanges() : (rootFieldChanges instanceof MapDelta ? ((MapDelta)data).getChanges() : null)) == null) continue;
            mapChanges.keySet().removeIf(key -> {
                Object changed = mapChanges.get(key);
                String value = "";
                if (changed != null && changed instanceof ChangedItem) {
                    value = ((ChangedItem)mapChanges.get(key)).newValue();
                }
                return containsField && foundField == null || foundField != null && foundField.contains(value) || this.isEmptyOrNull(foundField, value);
            });
        }
    }

    private boolean isEmptyOrNull(List<String> data, Object value) {
        return !(value != null && !"".equals(value) || !data.contains(null) && !data.contains(""));
    }

    public Map<String, List<String>> getFields() {
        return this.fields;
    }

    @Override
    public Binder serialize(BiSerializer serializer) {
        Binder results = super.serialize(serializer);
        results.put("fields", serializer.serialize(this.fields));
        return results;
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        super.deserialize(data, deserializer);
        Object fields = data.get("fields");
        if (fields != null && fields instanceof Map) {
            this.fields.putAll((Map)fields);
        }
    }

    static {
        DefaultBiMapper.registerClass(ModifyDataPermission.class);
    }
}

