/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.permissions;

import com.icodici.crypto.PublicKey;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.permissions.ChangeNumberPermission;
import com.icodici.universa.contract.permissions.ChangeOwnerPermission;
import com.icodici.universa.contract.permissions.ModifyDataPermission;
import com.icodici.universa.contract.permissions.RevokePermission;
import com.icodici.universa.contract.roles.Role;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.diff.Delta;
import net.sergeych.tools.Binder;
import net.sergeych.tools.Do;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Permission
implements BiSerializable,
Comparable<Permission> {
    private String name;
    private Role role;
    private String id;
    protected Binder params;

    public @Nullable String getId() {
        return this.id;
    }

    public void setId(@NonNull String id) {
        if (this.id != null && !this.id.equals(id)) {
            throw new IllegalStateException("permission id is already set");
        }
        this.id = id;
    }

    public Binder getParams() {
        return this.params;
    }

    protected Permission() {
    }

    protected Permission(String name, Role role) {
        this.name = name;
        this.role = role;
        this.params = null;
    }

    protected Permission(String name, Role role, Binder params) {
        this.name = name;
        this.role = role;
        this.params = params;
    }

    public static Permission forName(String name, Role role, Binder params) {
        switch (name) {
            case "revoke": {
                return new RevokePermission(role);
            }
            case "change_owner": {
                return new ChangeOwnerPermission(role);
            }
            case "modify_data": {
                return new ModifyDataPermission(role, params);
            }
            case "decrement_permission": {
                return new ChangeNumberPermission(role, params);
            }
        }
        try {
            String className = "com.icodici.universa.contract.permissions." + Do.snakeToCamelCase(name) + "Permission";
            Class<?> cls = Permission.class.getClassLoader().loadClass(className);
            return (Permission)cls.getConstructor(Role.class, Binder.class).newInstance(role, Binder.from(params));
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IllegalArgumentException("unknown permission: " + name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't construct permission: " + name, e);
        }
    }

    public boolean isAllowedForKeys(PublicKey ... keys) {
        HashSet<PublicKey> keySet = new HashSet<PublicKey>();
        for (PublicKey k : keys) {
            keySet.add(k);
        }
        return this.isAllowedFor(keySet, null);
    }

    public boolean isAllowedForKeys(Collection<PublicKey> keys) {
        return this.isAllowedFor(keys, null);
    }

    public boolean isAllowedFor(Collection<PublicKey> keys, Collection<String> references) {
        return this.role.isAllowedFor(keys, references);
    }

    @Override
    public Binder serialize(BiSerializer serializer) {
        Binder results = new Binder();
        if (this.params != null) {
            results.putAll(this.params);
        }
        results.put("name", this.name);
        results.put("role", serializer.serialize(this.role));
        return results;
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        this.name = data.getStringOrThrow("name");
        this.role = (Role)deserializer.deserialize(data.get("role"));
        this.params = data;
    }

    public abstract void checkChanges(Contract var1, Contract var2, Map<String, Delta> var3);

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.name + ":" + this.role + ">";
    }

    public Role getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Permission) {
            return this.compareTo((Permission)obj) == 0;
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(Permission o) {
        return this.name.compareTo(o.name);
    }
}

