/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.permissions;

import com.icodici.universa.Approvable;
import com.icodici.universa.Decimal;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.permissions.Permission;
import com.icodici.universa.contract.roles.Role;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.diff.ChangedItem;
import net.sergeych.diff.Delta;
import net.sergeych.diff.MapDelta;
import net.sergeych.tools.Binder;

@BiType(name="SplitJoinPermission")
public class SplitJoinPermission
extends Permission {
    private Decimal minValue;
    private Decimal minUnit;
    private String fieldName;
    private int newValue;
    private List<String> mergeFields;

    public SplitJoinPermission(Role role, Binder params) {
        super("split_join", role, params);
        this.initFromParams();
    }

    protected void initFromParams() {
        this.fieldName = this.params.getStringOrThrow("field_name");
        this.minValue = new Decimal(this.params.getString("min_value", "0"));
        this.minUnit = new Decimal(this.params.getString("min_unit", "1e-9"));
        this.mergeFields = this.params.getList("join_match_fields", Arrays.asList("state.origin"));
    }

    private SplitJoinPermission() {
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        super.deserialize(data, deserializer);
        this.initFromParams();
    }

    @Override
    public void checkChanges(Contract contract, Contract changed, Map<String, Delta> stateChanges) {
        MapDelta dataChanges = (MapDelta)stateChanges.get("data");
        if (dataChanges == null) {
            return;
        }
        Delta delta = dataChanges.getChange(this.fieldName);
        if (delta != null) {
            if (!(delta instanceof ChangedItem)) {
                return;
            }
            try {
                Decimal oldValue = new Decimal(delta.oldValue().toString());
                Decimal newValue = new Decimal(delta.newValue().toString());
                int cmp = oldValue.compareTo(newValue);
                if (cmp > 0) {
                    this.checkSplit(changed, dataChanges, oldValue, newValue);
                } else if (cmp < 0) {
                    this.checkMerge(changed, dataChanges, newValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void checkMerge(Contract changed, MapDelta<String, Binder, Binder> dataChanges, Decimal newValue) {
        boolean isValid;
        Decimal sum = Decimal.ZERO;
        for (Approvable a : changed.getRevokingItems()) {
            if (!(a instanceof Contract)) continue;
            Contract c = (Contract)a;
            if (!this.isMergeable(c) || !this.validateMergeFields(changed, c)) {
                return;
            }
            sum = sum.add(new Decimal(this.getFieldName(c)));
        }
        boolean bl = isValid = sum.compareTo(newValue) == 0;
        if (!isValid) {
            isValid = this.checkSplitJoinCase(changed);
        }
        if (isValid) {
            dataChanges.remove(this.fieldName);
        }
    }

    private void checkSplit(Contract changed, MapDelta<String, Binder, Binder> dataChanges, Decimal oldValue, Decimal newValue) {
        Decimal sum = Decimal.ZERO;
        for (Contract s : changed.getSiblings()) {
            if (!this.isMergeable(s) || !this.validateMergeFields(changed, s)) {
                return;
            }
            sum = sum.add(new Decimal(s.getStateData().getString(this.fieldName)));
        }
        boolean isValid = sum.equals(oldValue);
        if (!isValid) {
            isValid = this.checkSplitJoinCase(changed);
        }
        if (isValid && newValue.compareTo(this.minValue) >= 0 && newValue.ulp().compareTo(this.minUnit) >= 0) {
            dataChanges.remove(this.fieldName);
        }
    }

    private boolean checkSplitJoinCase(Contract changed) {
        Decimal splitJoinSum = Decimal.ZERO;
        for (Contract c : changed.getSiblings()) {
            splitJoinSum = splitJoinSum.add(new Decimal(c.getStateData().getString(this.fieldName)));
        }
        Decimal rSum = Decimal.ZERO;
        for (Approvable r : changed.getRevokingItems()) {
            if (!(r instanceof Contract)) continue;
            Contract c = (Contract)r;
            if (!this.isMergeable(c) || !this.validateMergeFields(changed, c)) {
                return false;
            }
            rSum = rSum.add(new Decimal(((Contract)r).getStateData().getString(this.fieldName)));
        }
        return splitJoinSum.compareTo(rSum) == 0;
    }

    private boolean validateMergeFields(Contract changed, Contract c) {
        for (String name : this.mergeFields) {
            Object v2;
            Object v1 = changed.get(name);
            if (v1.equals(v2 = c.get(name))) continue;
            return false;
        }
        return true;
    }

    private boolean isMergeable(Contract c) {
        String s = this.getFieldName(c);
        return s != null;
    }

    private String getFieldName(Contract c) {
        return c.getStateData().getString(this.fieldName, null);
    }

    static {
        DefaultBiMapper.registerClass(SplitJoinPermission.class);
    }
}

