/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.roles;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.KeyAddress;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.contract.AnonymousId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.KeyRecord;
import com.icodici.universa.contract.roles.Role;
import com.icodici.universa.contract.roles.RoleLink;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import org.checkerframework.checker.nullness.qual.NonNull;

@BiType(name="ListRole")
public class ListRole
extends Role {
    private Mode mode = Mode.ALL;
    private Set<Role> roles = new HashSet<Role>();
    private int quorumSize = 0;

    public ListRole() {
    }

    public ListRole(String name) {
        super(name);
    }

    public ListRole(String name, Mode mode, @NonNull Collection<Role> roles) {
        super(name);
        this.setMode(mode);
        this.addAll(roles);
    }

    public ListRole(String name, int quorumSize, @NonNull Collection<Role> roles) {
        super(name);
        this.mode = Mode.QUORUM;
        this.quorumSize = quorumSize;
        this.addAll(roles);
    }

    public void addAll(Collection<Role> roles) {
        this.roles.addAll(roles);
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public ListRole addRole(Role role) {
        this.roles.add(role);
        return this;
    }

    public void setQuorum(int n) {
        this.mode = Mode.QUORUM;
        this.quorumSize = n;
    }

    public int getQuorum() {
        return this.mode == Mode.QUORUM ? this.quorumSize : 0;
    }

    public void setMode(Mode newMode) {
        if (newMode == Mode.QUORUM) {
            throw new IllegalArgumentException("Only ANY or ALL of the modes should be set.");
        }
        this.mode = newMode;
    }

    @Override
    public boolean isAllowedForKeys(Set<? extends AbstractKey> keys) {
        if (this.mode == null) {
            this.mode = Mode.ALL;
        }
        return this.mode == Mode.ANY && this.processAnyMode(keys) || this.mode == Mode.ALL && this.processAllMode(keys) || this.mode == Mode.QUORUM && this.processQuorumMode(keys);
    }

    private boolean processQuorumMode(Set<? extends AbstractKey> keys) {
        int counter = this.quorumSize;
        boolean result = counter == 0;
        Set<Role> roles = this.roles;
        for (Role role : roles) {
            if (result) break;
            if (role == null || !role.isAllowedForKeys(keys) || --counter != 0) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean processAllMode(Set<? extends AbstractKey> keys) {
        return this.roles.stream().allMatch(role -> role.isAllowedForKeys(keys));
    }

    private boolean processAnyMode(Set<? extends AbstractKey> keys) {
        return this.roles.stream().anyMatch(role -> role.isAllowedForKeys(keys));
    }

    @Override
    public boolean isValid() {
        return !this.roles.isEmpty();
    }

    @Override
    public void initWithDsl(Binder serializedRole) {
        List roleBinders = serializedRole.getListOrThrow("roles");
        this.mode = Mode.valueOf(serializedRole.getStringOrThrow("mode").toUpperCase());
        if (this.mode == Mode.QUORUM) {
            this.quorumSize = serializedRole.getIntOrThrow("quorumSize");
        }
        roleBinders.stream().forEach(x -> {
            if (x instanceof String) {
                this.roles.add(new RoleLink(x + "link" + Instant.now().toEpochMilli(), (String)x));
            } else {
                Binder binder = Binder.of(x);
                if (binder.size() == 1) {
                    String name = (String)binder.keySet().iterator().next();
                    this.roles.add(Role.fromDslBinder(name, binder.getBinderOrThrow(name)));
                } else {
                    this.roles.add(Role.fromDslBinder(null, binder));
                }
            }
        });
    }

    @Override
    public void setContract(Contract contract) {
        super.setContract(contract);
        this.roles.forEach(r -> r.setContract(contract));
    }

    @Override
    public Set<PublicKey> getKeys() {
        return this.roles.stream().flatMap(role -> role.getKeyRecords().stream().map(KeyRecord::getPublicKey)).collect(Collectors.toSet());
    }

    @Override
    public Set<AnonymousId> getAnonymousIds() {
        return this.roles.stream().flatMap(role -> role.getAnonymousIds().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<KeyAddress> getKeyAddresses() {
        return this.roles.stream().flatMap(role -> role.getKeyAddresses().stream()).collect(Collectors.toSet());
    }

    public String toString() {
        return String.format("ListRole<%s:%s:%s:%s>", System.identityHashCode(this), this.getName(), this.mode == null ? "" : (this.mode == Mode.QUORUM ? this.mode.name().toLowerCase() + "_" + this.quorumSize : this.mode.name().toLowerCase()), this.roles);
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        List<Binder> roles;
        super.deserialize(data, deserializer);
        this.quorumSize = data.getInt("quorumSize", 0);
        Object mode = data.getOrDefault("mode", null);
        if (mode != null) {
            this.mode = Mode.valueOf(mode);
        }
        if ((roles = data.getList("roles", null)) != null) {
            this.roles.clear();
            roles.forEach(role -> this.addRole((Role)deserializer.deserialize(role)));
        }
    }

    @Override
    public Binder serialize(BiSerializer s) {
        return super.serialize(s).putAll("quorumSize", s.serialize(this.quorumSize), "mode", s.serialize(this.mode == null ? null : this.mode.name()), "roles", s.serialize(this.roles));
    }

    @Override
    public void anonymize() {
        for (Role role : this.roles) {
            role.anonymize();
        }
    }

    static {
        DefaultBiMapper.registerClass(ListRole.class);
    }

    public static enum Mode {
        ALL,
        ANY,
        QUORUM;

    }
}

