/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.roles;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.KeyAddress;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.contract.AnonymousId;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.KeyRecord;
import com.icodici.universa.contract.Reference;
import com.icodici.universa.contract.roles.ListRole;
import com.icodici.universa.contract.roles.RoleLink;
import com.icodici.universa.contract.roles.SimpleRole;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializable;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.tools.Binder;
import org.checkerframework.checker.nullness.qual.NonNull;

@BiType(name="Role")
public abstract class Role
implements BiSerializable {
    private String name;
    private Contract contract;
    protected Set<String> requiredAllReferences = new HashSet<String>();
    protected Set<String> requiredAnyReferences = new HashSet<String>();

    public void addAllRequiredReferences(Collection<Reference> references, RequiredMode requiredMode) {
        (requiredMode == RequiredMode.ALL_OF ? this.requiredAllReferences : this.requiredAnyReferences).addAll(references.stream().map(reference -> reference.getName()).collect(Collectors.toSet()));
    }

    public Set<String> getReferences(RequiredMode requiredMode) {
        return requiredMode == RequiredMode.ALL_OF ? this.requiredAllReferences : this.requiredAnyReferences;
    }

    public void addRequiredReference(Reference reference, RequiredMode requiredMode) {
        this.addRequiredReference(reference.getName(), requiredMode);
    }

    public void addRequiredReference(String refName, RequiredMode requiredMode) {
        (requiredMode == RequiredMode.ALL_OF ? this.requiredAllReferences : this.requiredAnyReferences).add(refName);
    }

    protected Role() {
    }

    protected Role(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isAllowedForKeys(Set<? extends AbstractKey> var1);

    public boolean isAllowedFor(Collection<? extends AbstractKey> keys, Collection<String> references) {
        if (!this.isAllowedForKeys((Set<? extends AbstractKey>)(keys instanceof Set ? (Set<Object>)keys : new HashSet<AbstractKey>(keys)))) {
            return false;
        }
        if (this.requiredAllReferences.stream().anyMatch(ref -> references == null || !references.contains(ref))) {
            return false;
        }
        return this.requiredAnyReferences.isEmpty() || this.requiredAnyReferences.stream().anyMatch(ref -> references != null && references.contains(ref));
    }

    public boolean isMatchingKeyAddress(KeyAddress keyAddress) {
        for (KeyAddress ka : this.getKeyAddresses()) {
            if (!keyAddress.isMatchingKeyAddress(ka)) continue;
            return true;
        }
        for (PublicKey pk : this.getKeys()) {
            if (!keyAddress.isMatchingKey(pk)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatchingRole(Role role) {
        return false;
    }

    public abstract boolean isValid();

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Role) {
            Role otherRole = (Role)obj;
            return otherRole.requiredAnyReferences.equals(this.requiredAnyReferences) && otherRole.requiredAllReferences.equals(this.requiredAllReferences) && otherRole.name.equals(this.name) && otherRole.getClass() == this.getClass();
        }
        return false;
    }

    public boolean equalKeys(@NonNull Role otherRole) {
        return otherRole.getKeys().equals(this.getKeys());
    }

    public abstract void initWithDsl(Binder var1);

    public static Role fromDslBinder(String name, Binder serializedRole) {
        Role result;
        String type;
        if (name == null) {
            name = serializedRole.getStringOrThrow("name");
        }
        if ((type = serializedRole.getString("type", null)) == null || type.equalsIgnoreCase("simple")) {
            result = new SimpleRole(name);
        } else if (type.equalsIgnoreCase("link")) {
            result = new RoleLink(name);
        } else if (type.equalsIgnoreCase("list")) {
            result = new ListRole(name);
        } else {
            throw new IllegalArgumentException("Unknown role type: " + type);
        }
        ((Role)result).initWithDsl(serializedRole);
        if (serializedRole.containsKey("requires")) {
            Binder requires = serializedRole.getBinderOrThrow("requires");
            if (requires.containsKey("all_of")) {
                result.requiredAllReferences.addAll(requires.getListOrThrow("all_of"));
            }
            if (requires.containsKey("any_of")) {
                result.requiredAnyReferences.addAll(requires.getListOrThrow("any_of"));
            }
        }
        return result;
    }

    public abstract Set<PublicKey> getKeys();

    public abstract Set<AnonymousId> getAnonymousIds();

    public abstract Set<KeyAddress> getKeyAddresses();

    public Set<KeyRecord> getKeyRecords() {
        return Collections.emptySet();
    }

    public <T extends Role> @NonNull T resolve() {
        return (T)this;
    }

    @Deprecated
    public KeyRecord getKeyRecord() {
        Set<KeyRecord> kr = this.getKeyRecords();
        if (kr.size() > 1) {
            throw new IllegalStateException("can't get key record as there are many of them");
        }
        return kr.iterator().next();
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public Contract getContract() {
        return this.contract;
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        this.name = data.getStringOrThrow("name");
        this.contract = (Contract)deserializer.getContext();
        Binder required = data.getBinder("required");
        if (required != null) {
            if (required.containsKey(RequiredMode.ALL_OF.name())) {
                this.requiredAllReferences.addAll((Collection)deserializer.deserialize(required.getArray(RequiredMode.ALL_OF.name())));
            }
            if (required.containsKey(RequiredMode.ANY_OF.name())) {
                this.requiredAnyReferences.addAll((Collection)deserializer.deserialize(required.getArray(RequiredMode.ANY_OF.name())));
            }
        }
    }

    @Override
    public Binder serialize(BiSerializer s) {
        Binder b = Binder.fromKeysValues("name", this.name);
        if (!this.requiredAnyReferences.isEmpty() || !this.requiredAllReferences.isEmpty()) {
            Binder required = new Binder();
            if (!this.requiredAllReferences.isEmpty()) {
                required.set(RequiredMode.ALL_OF.name(), s.serialize(this.requiredAllReferences));
            }
            if (!this.requiredAllReferences.isEmpty()) {
                required.set(RequiredMode.ANY_OF.name(), s.serialize(this.requiredAnyReferences));
            }
            b.set("required", required);
        }
        return b;
    }

    public RoleLink linkAs(String roleName) {
        RoleLink newRole = new RoleLink(roleName, this.name);
        if (this.contract != null) {
            this.contract.registerRole(newRole);
        }
        return newRole;
    }

    public abstract void anonymize();

    public static enum RequiredMode {
        ALL_OF,
        ANY_OF;

    }
}

