/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.roles;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.KeyAddress;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.contract.AnonymousId;
import com.icodici.universa.contract.KeyRecord;
import com.icodici.universa.contract.roles.Role;
import java.util.Collection;
import java.util.Set;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import org.checkerframework.checker.nullness.qual.Nullable;

@BiType(name="RoleLink")
public class RoleLink
extends Role {
    private String roleName;

    private RoleLink() {
    }

    public RoleLink(String name) {
        super(name);
    }

    public RoleLink(String name, String roleName) {
        super(name);
        if (name.equals(roleName)) {
            throw new IllegalArgumentException("RoleLink: name and target name are equals: " + name);
        }
        this.roleName = roleName;
    }

    public @Nullable Role getRole() {
        return this.getContract().getRole(this.roleName);
    }

    @Override
    public <T extends Role> T resolve() {
        Role r = this;
        for (int maxDepth = 40; maxDepth > 0; --maxDepth) {
            if (r instanceof RoleLink) {
                if ((r = r.getRole()) != null) continue;
                return null;
            }
            return (T)r;
        }
        return null;
    }

    private void badOperation() {
        throw new RuntimeException("operation not supported for RoleLink instance");
    }

    @Override
    public Set<KeyRecord> getKeyRecords() {
        return ((Role)this.resolve()).getKeyRecords();
    }

    @Override
    public Set<AnonymousId> getAnonymousIds() {
        Object role = this.resolve();
        return role == null ? null : ((Role)role).getAnonymousIds();
    }

    @Override
    public Set<KeyAddress> getKeyAddresses() {
        Object role = this.resolve();
        return role == null ? null : ((Role)role).getKeyAddresses();
    }

    @Override
    public Set<PublicKey> getKeys() {
        Object role = this.resolve();
        return role == null ? null : ((Role)role).getKeys();
    }

    @Override
    public boolean isAllowedFor(Collection<? extends AbstractKey> keys, Collection<String> references) {
        Object role = this.resolve();
        return role == null ? false : ((Role)role).isAllowedFor(keys, references);
    }

    @Override
    public boolean isAllowedForKeys(Set<? extends AbstractKey> keys) {
        Object role = this.resolve();
        return role == null ? false : ((Role)role).isAllowedForKeys(keys);
    }

    @Override
    public boolean isValid() {
        Object role = this.resolve();
        return role == null ? false : ((Role)role).isValid();
    }

    @Override
    public boolean equalKeys(Role otherRole) {
        Role role = this.getRole();
        return role == null ? false : role.equalKeys(otherRole);
    }

    @Override
    public void initWithDsl(Binder serializedRole) {
        this.roleName = serializedRole.getStringOrThrow("target");
        if (this.getName().equals(this.roleName)) {
            throw new IllegalArgumentException("RoleLink: name and target name are equals: " + this.roleName);
        }
    }

    public String toString() {
        if (this.getContract() != null) {
            Role role = this.getRole();
            return "RoleLink<" + this.getName() + "->" + this.roleName + ":" + (role == null ? "null" : role.toString()) + ">";
        }
        return "RoleLink<" + this.getName() + "->" + this.roleName + ":not connected>";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RoleLink) {
            return ((RoleLink)obj).roleName.equals(this.roleName);
        }
        return false;
    }

    @Override
    public Binder serialize(BiSerializer s) {
        return Binder.fromKeysValues("name", this.getName(), "target_name", this.roleName);
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        super.deserialize(data, deserializer);
        this.roleName = data.getStringOrThrow("target_name");
    }

    @Override
    public void anonymize() {
        Object role = this.resolve();
        if (role != null) {
            ((Role)role).anonymize();
        }
    }

    static {
        DefaultBiMapper.registerClass(RoleLink.class);
    }
}

