/*
 * Decompiled with CFR 0.152.
 */
package com.icodici.universa.contract.roles;

import com.icodici.crypto.AbstractKey;
import com.icodici.crypto.KeyAddress;
import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.contract.AnonymousId;
import com.icodici.universa.contract.KeyRecord;
import com.icodici.universa.contract.roles.Role;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.BiType;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import org.checkerframework.checker.nullness.qual.NonNull;

@BiType(name="SimpleRole")
public class SimpleRole
extends Role {
    private final Map<PublicKey, KeyRecord> keyRecords = new HashMap<PublicKey, KeyRecord>();
    private final Set<AnonymousId> anonymousIds = new HashSet<AnonymousId>();
    private final Set<KeyAddress> keyAddresses = new HashSet<KeyAddress>();

    public SimpleRole(String name, @NonNull KeyRecord keyRecord) {
        super(name);
        this.keyRecords.put(keyRecord.getPublicKey(), keyRecord);
    }

    private SimpleRole() {
    }

    public SimpleRole(String name) {
        super(name);
    }

    public SimpleRole(String name, @NonNull Collection records) {
        super(name);
        this.initWithRecords(records);
    }

    private void initWithRecords(@NonNull Collection records) {
        records.forEach(x -> {
            KeyRecord kr = null;
            AnonymousId anonId = null;
            if (x instanceof KeyRecord) {
                kr = (KeyRecord)x;
            } else if (x instanceof PublicKey) {
                kr = new KeyRecord((PublicKey)x);
            } else if (x instanceof AnonymousId) {
                anonId = (AnonymousId)x;
            } else if (x instanceof PrivateKey) {
                kr = new KeyRecord(((PrivateKey)x).getPublicKey());
            } else if (x instanceof KeyAddress) {
                this.keyAddresses.add((KeyAddress)x);
            } else {
                throw new IllegalArgumentException("Cant create KeyRecord from " + x);
            }
            if (anonId != null) {
                this.anonymousIds.add(anonId);
            } else if (kr != null) {
                this.keyRecords.put(kr.getPublicKey(), kr);
            }
        });
    }

    public void addKeyRecord(KeyRecord keyRecord) {
        this.keyRecords.put(keyRecord.getPublicKey(), keyRecord);
    }

    @Override
    @Deprecated
    public KeyRecord getKeyRecord() {
        if (this.keyRecords.size() > 1) {
            throw new IllegalStateException("Can't use with non-single key role");
        }
        return this.keyRecords.values().iterator().next();
    }

    @Override
    public Set<KeyRecord> getKeyRecords() {
        return new HashSet<KeyRecord>(this.keyRecords.values());
    }

    @Override
    public Set<PublicKey> getKeys() {
        return this.keyRecords.keySet();
    }

    @Override
    public Set<AnonymousId> getAnonymousIds() {
        return this.anonymousIds;
    }

    @Override
    public Set<KeyAddress> getKeyAddresses() {
        return this.keyAddresses;
    }

    @Override
    public boolean isAllowedForKeys(Set<? extends AbstractKey> keys) {
        return keys.stream().anyMatch(k -> {
            boolean anyMatch1 = this.anonymousIds.stream().anyMatch(anonId -> {
                try {
                    return k.matchAnonymousId(anonId.getBytes());
                }
                catch (IOException e) {
                    return false;
                }
            });
            boolean anyMatch2 = this.keyRecords.containsKey(k.getPublicKey());
            boolean anyMatch3 = this.keyAddresses.stream().anyMatch(address -> {
                try {
                    return k.isMatchingKeyAddress((KeyAddress)address);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            });
            return anyMatch1 || anyMatch2 || anyMatch3;
        });
    }

    @Override
    public boolean isValid() {
        return !this.keyRecords.isEmpty() || !this.anonymousIds.isEmpty() || !this.keyAddresses.isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SimpleRole) {
            boolean a = ((SimpleRole)obj).getName().equals(this.getName());
            boolean b = ((SimpleRole)obj).equalKeys(this);
            boolean c = ((SimpleRole)obj).anonymousIds.containsAll(this.anonymousIds);
            boolean d = this.anonymousIds.containsAll(((SimpleRole)obj).anonymousIds);
            if (!(a && b && c && d)) {
                return false;
            }
            boolean e = true;
            for (KeyAddress ka1 : this.getKeyAddresses()) {
                e = false;
                for (KeyAddress ka2 : ((SimpleRole)obj).getKeyAddresses()) {
                    if (!ka1.equals(ka2)) continue;
                    e = true;
                    break;
                }
                if (e) continue;
                break;
            }
            if (!e) {
                return false;
            }
            e = true;
            for (KeyAddress ka1 : ((SimpleRole)obj).getKeyAddresses()) {
                e = false;
                for (KeyAddress ka2 : this.getKeyAddresses()) {
                    if (!ka1.equals(ka2)) continue;
                    e = true;
                    break;
                }
                if (e) continue;
                break;
            }
            return e;
        }
        return false;
    }

    @Override
    public void initWithDsl(Binder serializedRole) {
        List list;
        boolean keysFound = true;
        boolean addressesFound = true;
        boolean anonIdsFound = true;
        if (serializedRole.containsKey("keys")) {
            list = serializedRole.getListOrThrow("keys");
            for (Object keyRecord : list) {
                this.addKeyRecord(new KeyRecord(Binder.of(keyRecord)));
            }
        } else if (serializedRole.containsKey("key")) {
            this.addKeyRecord(new KeyRecord(serializedRole));
        } else {
            keysFound = false;
        }
        if (serializedRole.containsKey("addresses")) {
            list = serializedRole.getListOrThrow("addresses");
            for (Object address : list) {
                this.keyAddresses.add(new KeyAddress(Binder.of(address)));
            }
        } else if (serializedRole.containsKey("uaddress")) {
            this.keyAddresses.add(new KeyAddress(serializedRole));
        } else {
            addressesFound = false;
        }
        if (serializedRole.containsKey("anonIds")) {
            list = serializedRole.getListOrThrow("anonIds");
            for (Object anonId : list) {
                this.anonymousIds.add(new AnonymousId(Binder.of(anonId)));
            }
        } else if (serializedRole.containsKey("anonymousId")) {
            this.anonymousIds.add(new AnonymousId(serializedRole));
        } else {
            anonIdsFound = false;
        }
        if (!(addressesFound || anonIdsFound || keysFound)) {
            this.initWithRecords(serializedRole.getListOrThrow("binders"));
        }
    }

    public SimpleRole cloneAs(String name) {
        SimpleRole r = new SimpleRole(name);
        this.keyRecords.values().forEach(kr -> r.addKeyRecord((KeyRecord)kr));
        this.anonymousIds.forEach(aid -> r.anonymousIds.add((AnonymousId)aid));
        this.keyAddresses.forEach(keyAddr -> r.keyAddresses.add((KeyAddress)keyAddr));
        return r;
    }

    public String toString() {
        return "SimpleRole<" + System.identityHashCode(this) + ":" + this.getName() + ":anyOf:" + this.keyRecords.keySet() + "|" + this.anonymousIds + ":requiredAll:" + this.requiredAllReferences + ":requiredAny:" + this.requiredAnyReferences + ">";
    }

    public boolean isAllowedForKeys(SimpleRole anotherRole) {
        return this.isAllowedForKeys(anotherRole.keyRecords.keySet());
    }

    @Override
    public void deserialize(Binder data, BiDeserializer deserializer) {
        super.deserialize(data, deserializer);
        List<Object> keyList = data.getList("keys", null);
        this.keyRecords.clear();
        if (keyList != null) {
            keyList.forEach(kr -> this.addKeyRecord((KeyRecord)deserializer.deserialize(kr)));
        }
        List anonIdList = data.getList("anonIds", null);
        this.anonymousIds.clear();
        if (anonIdList != null) {
            for (Object aid : anonIdList) {
                AnonymousId anonymousId = (AnonymousId)deserializer.deserialize(aid);
                this.anonymousIds.add(anonymousId);
            }
        }
        List keyAddrList = data.getList("addresses", null);
        this.keyAddresses.clear();
        if (keyAddrList != null) {
            for (Object keyAddr : keyAddrList) {
                KeyAddress ka = (KeyAddress)deserializer.deserialize(keyAddr);
                this.keyAddresses.add(ka);
            }
        }
    }

    @Override
    public Binder serialize(BiSerializer s) {
        return super.serialize(s).putAll("keys", s.serialize(this.keyRecords.values()), "anonIds", s.serialize(this.anonymousIds), "addresses", s.serialize(this.keyAddresses));
    }

    @Override
    public void anonymize() {
        for (PublicKey publicKey : this.keyRecords.keySet()) {
            this.anonymousIds.add(AnonymousId.fromBytes(publicKey.createAnonymousId()));
        }
        this.keyRecords.clear();
    }

    static {
        DefaultBiMapper.registerClass(SimpleRole.class);
        DefaultBiMapper.registerClass(SimpleRole.class);
    }
}

